/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.sdklib.devices.BluetoothProfile;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Software {
    private int mMinSdkLevel = 0;
    private int mMaxSdkLevel = Integer.MAX_VALUE;
    private boolean mLiveWallpaperSupport;
    private Set<BluetoothProfile> mBluetoothProfiles = EnumSet.noneOf(BluetoothProfile.class);
    private String mGlVersion;
    private Set<String> mGlExtensions = new LinkedHashSet<String>();
    private boolean mStatusBar;

    public int getMinSdkLevel() {
        return this.mMinSdkLevel;
    }

    public void setMinSdkLevel(int sdkLevel) {
        this.mMinSdkLevel = sdkLevel;
    }

    public int getMaxSdkLevel() {
        return this.mMaxSdkLevel;
    }

    public void setMaxSdkLevel(int sdkLevel) {
        this.mMaxSdkLevel = sdkLevel;
    }

    public boolean hasLiveWallpaperSupport() {
        return this.mLiveWallpaperSupport;
    }

    public void setLiveWallpaperSupport(boolean liveWallpaperSupport) {
        this.mLiveWallpaperSupport = liveWallpaperSupport;
    }

    public Set<BluetoothProfile> getBluetoothProfiles() {
        return this.mBluetoothProfiles;
    }

    public void addBluetoothProfile(BluetoothProfile bp) {
        this.mBluetoothProfiles.add(bp);
    }

    public void addAllBluetoothProfiles(Collection<BluetoothProfile> bps) {
        this.mBluetoothProfiles.addAll(bps);
    }

    public String getGlVersion() {
        return this.mGlVersion;
    }

    public void setGlVersion(String version) {
        this.mGlVersion = version;
    }

    public Set<String> getGlExtensions() {
        return this.mGlExtensions;
    }

    public void addGlExtension(String extension) {
        this.mGlExtensions.add(extension);
    }

    public void addAllGlExtensions(Collection<String> extensions) {
        this.mGlExtensions.addAll(extensions);
    }

    public void setStatusBar(boolean hasBar) {
        this.mStatusBar = hasBar;
    }

    public boolean hasStatusBar() {
        return this.mStatusBar;
    }

    public Software deepCopy() {
        Software s = new Software();
        s.setMinSdkLevel(this.getMinSdkLevel());
        s.setMaxSdkLevel(this.getMaxSdkLevel());
        s.setLiveWallpaperSupport(this.hasLiveWallpaperSupport());
        s.addAllBluetoothProfiles(this.getBluetoothProfiles());
        s.setGlVersion(this.getGlVersion());
        s.addAllGlExtensions(this.getGlExtensions());
        s.setStatusBar(this.hasStatusBar());
        return s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Software)) {
            return false;
        }
        Software sw = (Software)o;
        return this.mMinSdkLevel == sw.getMinSdkLevel() && this.mMaxSdkLevel == sw.getMaxSdkLevel() && this.mLiveWallpaperSupport == sw.hasLiveWallpaperSupport() && this.mBluetoothProfiles.equals(sw.getBluetoothProfiles()) && this.mGlVersion.equals(sw.getGlVersion()) && this.mGlExtensions.equals(sw.getGlExtensions()) && this.mStatusBar == sw.hasStatusBar();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.mMinSdkLevel;
        hash = 31 * hash + this.mMaxSdkLevel;
        hash = 31 * hash + (this.mLiveWallpaperSupport ? 1 : 0);
        for (BluetoothProfile bp : this.mBluetoothProfiles) {
            hash = 31 * hash + bp.ordinal();
        }
        if (this.mGlVersion != null) {
            hash = 31 * hash + this.mGlVersion.hashCode();
        }
        for (String glExtension : this.mGlExtensions) {
            if (glExtension == null) continue;
            hash = 31 * hash + glExtension.hashCode();
        }
        hash = 31 * hash + (this.mStatusBar ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Software <mMinSdkLevel=");
        sb.append(this.mMinSdkLevel);
        sb.append(", mMaxSdkLevel=");
        sb.append(this.mMaxSdkLevel);
        sb.append(", mLiveWallpaperSupport=");
        sb.append(this.mLiveWallpaperSupport);
        sb.append(", mBluetoothProfiles=");
        sb.append(this.mBluetoothProfiles);
        sb.append(", mGlVersion=");
        sb.append(this.mGlVersion);
        sb.append(", mGlExtensions=");
        sb.append(this.mGlExtensions);
        sb.append(", mStatusBar=");
        sb.append(this.mStatusBar);
        sb.append(">");
        return sb.toString();
    }
}

