/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.glassfish.server;

import com.intellij.javaee.oss.glassfish.server.GlassfishConfigNames;
import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfig;
import com.intellij.javaee.oss.glassfish.server.GlassfishDomainConfigProcessor;
import com.intellij.javaee.oss.glassfish.server.GlassfishLocalModel;
import com.intellij.javaee.oss.glassfish.server.GlassfishNetworkConfigProcessor;
import com.intellij.javaee.oss.server.JavaeePortConfig;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class GlassfishPortConfig
extends JavaeePortConfig
implements GlassfishConfigNames {
    private static final Map<String, FactoryImpl> USER_SERVER_ID_2_FACTORY = new HashMap<String, FactoryImpl>();
    private static final JavaeePortConfig.Factory<GlassfishLocalModel> ADMIN = new FactoryImpl("__asadmin");
    private final String myVirtualServerId;
    private final GlassfishDomainConfig myDomainConfig;

    private GlassfishPortConfig(GlassfishLocalModel model, String virtualServerId) {
        this.myDomainConfig = new GlassfishDomainConfig(model);
        this.myVirtualServerId = virtualServerId;
    }

    protected long getStamp(JavaeeServerModel data) {
        return this.myDomainConfig.getStamp();
    }

    protected int getPort(JavaeeServerModel model) {
        final Ref resultRef = new Ref((Object)Integer.MAX_VALUE);
        new GlassfishDomainConfigProcessor(this.myDomainConfig){

            @Override
            protected void doProcessConfig(File file, Document doc, Element serverConfig) throws IOException {
                String port;
                Element httpService = serverConfig.getChild("http-service");
                if (httpService == null) {
                    return;
                }
                Element virtualServer = StringUtil.isEmpty((String)GlassfishPortConfig.this.myVirtualServerId) ? 1.getChild((Element)httpService, (String)"virtual-server") : 1.getChild((Element)httpService, (String)"virtual-server", (String)"id", (String)GlassfishPortConfig.this.myVirtualServerId);
                if (virtualServer == null) {
                    return;
                }
                String networkListenerIds = virtualServer.getAttributeValue("network-listeners");
                if (networkListenerIds == null) {
                    networkListenerIds = virtualServer.getAttributeValue("http-listeners");
                }
                if (networkListenerIds == null) {
                    return;
                }
                String networkListenerId = networkListenerIds.split("\\,")[0];
                final Ref listenerRef = new Ref();
                listenerRef.set((Object)1.getChild((Element)httpService, (String)"http-listener", (String)"id", (String)networkListenerId));
                if (listenerRef.isNull()) {
                    new GlassfishNetworkConfigProcessor(){

                        @Override
                        protected void doProcessConfig(Element networkConfig, Element networkListener) {
                            listenerRef.set((Object)networkListener);
                        }
                    }.processServerConfig(serverConfig, networkListenerId);
                }
                if (!listenerRef.isNull() && (port = ((Element)listenerRef.get()).getAttributeValue("port")) != null) {
                    try {
                        resultRef.set((Object)Integer.parseInt(port));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }.processConfig();
        return (Integer)resultRef.get();
    }

    static int getLocal(GlassfishLocalModel model) {
        String virtualServerId = model.VIRTUAL_SERVER;
        ArrayList<FactoryImpl> localFactories = new ArrayList<FactoryImpl>();
        if (StringUtil.isEmpty((String)virtualServerId)) {
            localFactories.add(GlassfishPortConfig.getOrCreateUserFactory("server"));
            localFactories.add(GlassfishPortConfig.getOrCreateUserFactory(""));
        } else {
            localFactories.add(GlassfishPortConfig.getOrCreateUserFactory(virtualServerId));
        }
        for (FactoryImpl localFactory : localFactories) {
            int result = GlassfishPortConfig.get((JavaeePortConfig.Factory)localFactory, (JavaeeServerModel)model, (int)Integer.MAX_VALUE);
            if (result == Integer.MAX_VALUE) continue;
            return result;
        }
        return model.getDefaultPort();
    }

    private static FactoryImpl getOrCreateUserFactory(String virtualServerId) {
        FactoryImpl result = USER_SERVER_ID_2_FACTORY.get(virtualServerId);
        if (result == null) {
            result = new FactoryImpl(virtualServerId);
            USER_SERVER_ID_2_FACTORY.put(virtualServerId, result);
        }
        return result;
    }

    static int getAdmin(GlassfishLocalModel model) {
        return GlassfishPortConfig.get(ADMIN, (JavaeeServerModel)model, (int)Integer.MAX_VALUE);
    }

    private static class FactoryImpl
    implements JavaeePortConfig.Factory<GlassfishLocalModel> {
        private final String myId;

        public FactoryImpl(@NonNls String id) {
            this.myId = id;
        }

        @NotNull
        public CachedConfig.Key createKey(GlassfishLocalModel data) {
            CachedConfig.Key key = new CachedConfig.Key(new String[]{data.getHome(), data.DOMAIN, this.myId});
            if (key == null) {
                FactoryImpl.$$$reportNull$$$0(0);
            }
            return key;
        }

        @NotNull
        public JavaeePortConfig createConfig(GlassfishLocalModel data) {
            GlassfishPortConfig glassfishPortConfig = new GlassfishPortConfig(data, this.myId);
            if (glassfishPortConfig == null) {
                FactoryImpl.$$$reportNull$$$0(1);
            }
            return glassfishPortConfig;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/javaee/oss/glassfish/server/GlassfishPortConfig$FactoryImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createKey";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createConfig";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

