/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.inspections;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.security.SpringSecurityBundle;
import com.intellij.spring.security.inspections.SpringSecurityBaseInspection;
import com.intellij.spring.security.inspections.SpringSecurityModelVisitor;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.spring.security.model.xml.Http;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityModelInspection
extends SpringSecurityBaseInspection {
    private static final Condition<Http> HTTP_WITHOUT_REQUEST_MATCHER_OR_REF = http -> !DomUtil.hasXml(http.getRequestMatcherRef()) && !DomUtil.hasXml(http.getRequestMatcher());
    private static final Condition<Http> HTTP_WITHOUT_PATTERN = http -> !DomUtil.hasXml(http.getPattern());

    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        Processor<SpringBeanPointer> findMultiple;
        if (!SpringSecurityUtil.isSpringSecurityNamespaceUsed(domFileElement)) {
            return;
        }
        SpringSecurityVersion springSecurityVersion = SpringSecurityUtil.getVersion(domFileElement);
        String userDetailsServiceClassFqn = springSecurityVersion.isAtLeast(SpringSecurityVersion.V_3_0) ? "org.springframework.security.core.userdetails.UserDetailsService" : "org.springframework.security.userdetails.UserDetailsService";
        PsiClass userDetailsServiceClass = DomJavaUtil.findClass((String)userDetailsServiceClassFqn, domFileElement);
        if (userDetailsServiceClass == null) {
            return;
        }
        XmlFile file = domFileElement.getFile();
        SpringModel springModel = SpringManager.getInstance((Project)file.getProject()).getSpringModelByFile((PsiFile)file);
        if (springModel == null) {
            return;
        }
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)userDetailsServiceClass).withInheritors();
        boolean multipleUserServices = !springModel.processByClass(searchParameters, (Processor)(findMultiple = new Processor<SpringBeanPointer>(){
            private int found = 0;

            public boolean process(SpringBeanPointer pointer) {
                return this.found++ <= 1;
            }
        }));
        Beans beans = (Beans)domFileElement.getRootElement();
        beans.acceptChildren((DomElementVisitor)new SpringSecurityModelVisitor(holder, multipleUserServices));
        SpringSecurityModelInspection.visitHttps(holder, beans, springSecurityVersion);
    }

    private static void visitHttps(DomElementAnnotationHolder holder, Beans beans, SpringSecurityVersion springSecurityVersion) {
        if (!springSecurityVersion.isAtLeast(SpringSecurityVersion.V_3_1)) {
            return;
        }
        List httpList = ContainerUtil.filter((Collection)DomUtil.getDefinedChildrenOfType((DomElement)beans, Http.class, (boolean)true, (boolean)false), HTTP_WITHOUT_REQUEST_MATCHER_OR_REF);
        int size = httpList.size();
        if (size <= 1) {
            return;
        }
        for (int i = 0; i < size - 1; ++i) {
            Http http = (Http)httpList.get(i);
            if (DomUtil.hasXml(http.getPattern()) && !"/**".equals(http.getPattern().getStringValue())) continue;
            holder.createProblem((DomElement)http, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.http.pattern.all.must.be.last", new Object[0]));
        }
        List httpWithoutPattern = ContainerUtil.findAll((Collection)httpList, HTTP_WITHOUT_PATTERN);
        if (httpWithoutPattern.size() > 1) {
            for (Http http : httpWithoutPattern) {
                holder.createProblem((DomElement)http, HighlightSeverity.ERROR, SpringSecurityBundle.message("model.inspection.model.http.not.multiple.without.pattern", new Object[0]));
            }
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringSecurityModelInspection" == null) {
            SpringSecurityModelInspection.$$$reportNull$$$0(0);
        }
        return "SpringSecurityModelInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/inspections/SpringSecurityModelInspection", "getShortName"));
    }
}

