/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.memoryanalyzer;

import com.android.tools.perflib.analyzer.AnalysisReport;
import com.android.tools.perflib.analyzer.AnalysisResultEntry;
import com.android.tools.perflib.analyzer.Analyzer;
import com.android.tools.perflib.analyzer.AnalyzerTask;
import com.android.tools.perflib.analyzer.Capture;
import com.android.tools.perflib.analyzer.CaptureGroup;
import com.android.tools.perflib.heap.Heap;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.memoryanalyzer.MemoryAnalyzerTask;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class MemoryAnalyzer
extends Analyzer {
    private Set<MemoryAnalyzerTask> mTasks = new HashSet<MemoryAnalyzerTask>();
    private AnalysisReport mOutstandingReport;
    private ListenableFuture<List<List<AnalysisResultEntry<?>>>> mRunningAnalyzers;
    private volatile boolean mCancelAnalysis = false;
    private boolean mAnalysisComplete = false;

    private static boolean accept(Capture capture) {
        return "hprof".equals(capture.getTypeName());
    }

    @Override
    public boolean accept(CaptureGroup captureGroup) {
        for (Capture capture : captureGroup.getCaptures()) {
            if (!MemoryAnalyzer.accept(capture)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AnalysisReport analyze(CaptureGroup captureGroup, Set<AnalysisReport.Listener> listeners, Set<? extends AnalyzerTask> tasks, Executor synchronizingExecutor, ExecutorService taskExecutor) {
        if (this.mOutstandingReport != null) {
            return this.mOutstandingReport;
        }
        for (AnalyzerTask analyzerTask : tasks) {
            if (!(analyzerTask instanceof MemoryAnalyzerTask)) continue;
            this.mTasks.add((MemoryAnalyzerTask)analyzerTask);
        }
        this.mOutstandingReport = new AnalysisReport();
        this.mOutstandingReport.addResultListeners(listeners);
        ArrayList<ListenableFutureTask> futuresList = new ArrayList<ListenableFutureTask>();
        for (Capture capture : captureGroup.getCaptures()) {
            Snapshot snapshot;
            if (!MemoryAnalyzer.accept(capture) || (snapshot = capture.getRepresentation(Snapshot.class)) == null) continue;
            ArrayList<Heap> heapsToUse = new ArrayList<Heap>(snapshot.getHeaps().size());
            for (Heap heap : snapshot.getHeaps()) {
                if (!"app".equals(heap.getName())) continue;
                heapsToUse.add(heap);
                break;
            }
            final MemoryAnalyzerTask.Configuration configuration = new MemoryAnalyzerTask.Configuration(heapsToUse);
            for (final MemoryAnalyzerTask task : this.mTasks) {
                ListenableFutureTask futureTask = ListenableFutureTask.create((Callable)new Callable<List<AnalysisResultEntry<?>>>(){

                    @Override
                    public List<AnalysisResultEntry<?>> call() throws Exception {
                        if (MemoryAnalyzer.this.mCancelAnalysis) {
                            return null;
                        }
                        return task.analyze(configuration, snapshot);
                    }
                });
                Futures.addCallback((ListenableFuture)futureTask, (FutureCallback)new FutureCallback<List<AnalysisResultEntry<?>>>(){

                    public void onSuccess(List<AnalysisResultEntry<?>> result) {
                        if (MemoryAnalyzer.this.mCancelAnalysis) {
                            return;
                        }
                        MemoryAnalyzer.this.mOutstandingReport.addAnalysisResultEntries(result);
                    }

                    public void onFailure(Throwable t) {
                    }
                }, (Executor)synchronizingExecutor);
                taskExecutor.submit((Runnable)futureTask);
                futuresList.add(futureTask);
            }
        }
        this.mRunningAnalyzers = Futures.allAsList(futuresList);
        Futures.addCallback(this.mRunningAnalyzers, (FutureCallback)new FutureCallback<List<List<AnalysisResultEntry<?>>>>(){

            public void onSuccess(List<List<AnalysisResultEntry<?>>> result) {
                MemoryAnalyzer.this.mAnalysisComplete = true;
                MemoryAnalyzer.this.mOutstandingReport.setCompleted();
            }

            public void onFailure(Throwable t) {
                MemoryAnalyzer.this.mAnalysisComplete = true;
                MemoryAnalyzer.this.mOutstandingReport.setCancelled();
            }
        }, (Executor)synchronizingExecutor);
        return this.mOutstandingReport;
    }

    @Override
    public void cancel() {
        if (this.mOutstandingReport == null || this.mAnalysisComplete) {
            return;
        }
        this.mCancelAnalysis = true;
        this.mRunningAnalyzers.cancel(true);
        this.mOutstandingReport.setCancelled();
    }

    public boolean isRunning() {
        return !this.mRunningAnalyzers.isDone();
    }
}

