/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.utils.XmlUtils;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.w3c.dom.Document;

public class CharSequences {
    public static int indexOf(CharSequence sequence, char c) {
        return CharSequences.indexOf(sequence, c, 0);
    }

    public static int indexOf(CharSequence sequence, char c, int start) {
        for (int i = start; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle, int start) {
        int length = haystack.length();
        int needleLength = needle.length();
        if (needleLength <= length && start >= 0) {
            if (needleLength > 0) {
                if (start > length - needleLength) {
                    start = length - needleLength;
                }
                char firstChar = needle.charAt(0);
                while (true) {
                    int i;
                    if ((i = CharSequences.lastIndexOf(haystack, firstChar, start)) == -1) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < needleLength && haystack.charAt(++o1) == needle.charAt(o2)) {
                    }
                    if (o2 == needleLength) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < length ? start : length;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence sequence, char c) {
        return CharSequences.lastIndexOf(sequence, c, sequence.length());
    }

    public static int lastIndexOf(CharSequence sequence, int c, int start) {
        int length = sequence.length();
        if (start >= 0) {
            if (start >= length) {
                start = length - 1;
            }
            for (int i = start; i >= 0; --i) {
                if (sequence.charAt(i) != c) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence haystack, String needle) {
        return CharSequences.lastIndexOf(haystack, needle, haystack.length());
    }

    public static boolean regionMatches(CharSequence sequence, int thisStart, CharSequence string, int start, int length) {
        if (start < 0 || string.length() - start < length) {
            return false;
        }
        if (thisStart < 0 || sequence.length() - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (sequence.charAt(thisStart + i) == string.charAt(start + i)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence sequence, boolean ignoreCase, int thisStart, CharSequence string, int start, int length) {
        if (!ignoreCase) {
            return CharSequences.regionMatches(sequence, thisStart, string, start, length);
        }
        if (thisStart < 0 || length > sequence.length() - thisStart) {
            return false;
        }
        if (start < 0 || length > string.length() - start) {
            return false;
        }
        int end = thisStart + length;
        while (thisStart < end) {
            char c2;
            char c1;
            if ((c1 = sequence.charAt(thisStart++)) == (c2 = string.charAt(start++)) || CharSequences.foldCase(c1) == CharSequences.foldCase(c2)) continue;
            return false;
        }
        return true;
    }

    private static char foldCase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix) {
        return CharSequences.startsWith(sequence, prefix, 0);
    }

    public static boolean startsWith(CharSequence sequence, CharSequence prefix, int start) {
        int prefixLength;
        int sequenceLength = sequence.length();
        if (sequenceLength + start < (prefixLength = prefix.length())) {
            return false;
        }
        int i = start;
        for (int j = 0; j < prefixLength; ++j) {
            if (sequence.charAt(i) != prefix.charAt(j)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int indexOf(CharSequence haystack, CharSequence needle) {
        return CharSequences.indexOf(haystack, needle, 0);
    }

    public static int indexOf(CharSequence haystack, CharSequence needle, int start) {
        int needleLength = needle.length();
        if (needleLength == 0) {
            return start;
        }
        char first = needle.charAt(0);
        if (needleLength == 1) {
            return CharSequences.indexOf(haystack, first);
        }
        int max = haystack.length() - needleLength;
        block0: for (int i = start; i <= max; ++i) {
            if (haystack.charAt(i) != first) continue;
            int h = i + 1;
            for (int n = 1; n < needleLength; ++n) {
                if (haystack.charAt(h) != needle.charAt(n)) continue block0;
                ++h;
            }
            return i;
        }
        return -1;
    }

    public static CharSequence createSequence(char[] data) {
        return new LintCharSequence(data);
    }

    public static CharSequence createSequence(char[] data, int offset, int length) {
        return new LintCharSequence(data, offset, length);
    }

    public static char[] getCharArray(CharSequence sequence) {
        if (sequence instanceof LintCharSequence) {
            return ((LintCharSequence)sequence).getCharArray();
        }
        return sequence.toString().toCharArray();
    }

    public static Reader getReader(CharSequence data, boolean stripBom) {
        CharSequenceReader reader = new CharSequenceReader(data);
        if (stripBom && data.length() > 0 && data.charAt(0) == '\ufeff') {
            try {
                reader.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return reader;
    }

    public static Document parseDocumentSilently(CharSequence xml, boolean namespaceAware) {
        try {
            Reader reader = CharSequences.getReader(xml, true);
            return XmlUtils.parseDocument((Reader)reader, (boolean)namespaceAware);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final class CharSequenceReader
    extends Reader {
        private CharSequence seq;
        private int pos;
        private int mark;

        public CharSequenceReader(CharSequence seq) {
            this.seq = seq;
        }

        private boolean hasRemaining() {
            return this.remaining() > 0;
        }

        private int remaining() {
            return this.seq.length() - this.pos;
        }

        @Override
        public synchronized int read(CharBuffer target) throws IOException {
            if (!this.hasRemaining()) {
                return -1;
            }
            int charsToRead = Math.min(target.remaining(), this.remaining());
            for (int i = 0; i < charsToRead; ++i) {
                target.put(this.seq.charAt(this.pos++));
            }
            return charsToRead;
        }

        @Override
        public synchronized int read() throws IOException {
            return this.hasRemaining() ? (int)this.seq.charAt(this.pos++) : -1;
        }

        @Override
        public synchronized int read(char[] cbuf, int off, int len) throws IOException {
            if (!this.hasRemaining()) {
                return -1;
            }
            int charsToRead = Math.min(len, this.remaining());
            for (int i = 0; i < charsToRead; ++i) {
                cbuf[off + i] = this.seq.charAt(this.pos++);
            }
            return charsToRead;
        }

        @Override
        public synchronized long skip(long n) throws IOException {
            int charsToSkip = (int)Math.min((long)this.remaining(), n);
            this.pos += charsToSkip;
            return charsToSkip;
        }

        @Override
        public synchronized boolean ready() throws IOException {
            return true;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public synchronized void mark(int readAheadLimit) throws IOException {
            this.mark = this.pos;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.pos = this.mark;
        }

        @Override
        public synchronized void close() throws IOException {
            this.seq = null;
        }
    }

    private static class LintCharSequence
    implements CharSequence {
        public final char[] data;
        private final int offset;
        private final int length;

        public LintCharSequence(char[] data) {
            this(data, 0, data.length);
        }

        public LintCharSequence(char[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }

        public char[] getCharArray() {
            if (this.offset == 0 && this.length == this.data.length) {
                return this.data;
            }
            return Arrays.copyOfRange(this.data, this.offset, this.offset + this.length);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.data[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new LintCharSequence(this.data, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            return new String(this.data, this.offset, this.length);
        }
    }
}

