/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import java.util.Collections;
import java.util.List;

public class SetJavaScriptEnabledDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("SetJavaScriptEnabled", "Using `setJavaScriptEnabled`", "Your code should not invoke `setJavaScriptEnabled` if you are not sure that your app really requires JavaScript support.", Category.SECURITY, 6, Severity.WARNING, new Implementation(SetJavaScriptEnabledDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/security.html");

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression call, PsiMethod method) {
        Object constant;
        PsiExpression[] arguments = call.getArgumentList().getExpressions();
        if (arguments.length == 1 && (constant = ConstantEvaluator.evaluate(context, (PsiElement)arguments[0])) != null && !Boolean.FALSE.equals(constant)) {
            context.report(ISSUE, (PsiElement)call, context.getLocation((PsiElement)call), "Using `setJavaScriptEnabled` can introduce XSS vulnerabilities into your application, review carefully.");
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setJavaScriptEnabled");
    }
}

