/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import java.util.Collections;
import java.util.List;

public class ParcelDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create("ParcelCreator", "Missing Parcelable `CREATOR` field", "According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.\"", Category.CORRECTNESS, 3, Severity.ERROR, new Implementation(ParcelDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcelable.html");

    @Override
    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.os.Parcelable");
    }

    @Override
    public void checkClass(JavaContext context, PsiClass declaration) {
        if (declaration instanceof PsiAnonymousClass) {
            return;
        }
        if (declaration.isInterface()) {
            return;
        }
        if (declaration.hasModifierProperty("abstract")) {
            return;
        }
        if (context.getEvaluator().implementsInterface(declaration, "android.text.ParcelableSpan", false)) {
            return;
        }
        PsiField field = declaration.findFieldByName("CREATOR", true);
        if (field == null) {
            Location location = context.getNameLocation((PsiElement)declaration);
            context.report(ISSUE, (PsiElement)declaration, location, "This class implements `Parcelable` but does not provide a `CREATOR` field");
        }
    }
}

