/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.EnumSet;

public class MergeMarkerDetector
extends Detector
implements Detector.OtherFileScanner {
    public static final Issue ISSUE = Issue.create("MergeMarker", "Code contains merge marker", "Many version control systems leave unmerged files with markers such as <<< in the source code. This check looks for these markers, which are sometimes accidentally left in, particularly in resource files where they don't break compilation.", Category.CORRECTNESS, 8, Severity.ERROR, new Implementation(MergeMarkerDetector.class, Scope.OTHER_SCOPE));

    @Override
    public EnumSet<Scope> getApplicableFiles() {
        return Scope.OTHER_SCOPE;
    }

    @Override
    public void run(Context context) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        if (LintUtils.isBitmapFile(context.file)) {
            return;
        }
        CharSequence source = context.getContents();
        if (source == null) {
            return;
        }
        int length = source.length();
        int offset = 0;
        while ((offset = CharSequences.indexOf(source, '\n', offset)) != -1 && offset != length - 1) {
            char peek;
            if ((peek = source.charAt(++offset)) != '<' && peek != '=' && peek != '>' || !CharSequences.startsWith(source, "<<<<<<< ", offset) && !CharSequences.startsWith(source, "=======\n", offset) && !CharSequences.startsWith(source, ">>>>>>> ", offset)) continue;
            Location location = Location.create(context.file, source, offset, offset + 7);
            context.report(ISSUE, location, "Missing merge marker?");
        }
    }
}

