/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FieldGetterDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create("FieldGetter", "Using getter instead of field", "Accessing a field within the class that defines a getter for that field is at least 3 times faster than calling the getter. For simple getters that do nothing other than return the field, you might want to just reference the local field directly instead.\n\n*NOTE*: As of Android 2.3 (Gingerbread), this optimization is performed automatically by Dalvik, so there is no need to change your code; this is only relevant if you are targeting older versions of Android.", Category.PERFORMANCE, 4, Severity.WARNING, new Implementation(FieldGetterDetector.class, Scope.CLASS_FILE_SCOPE)).setEnabledByDefault(false).addMoreInfo("http://developer.android.com/guide/practices/design/performance.html#internal_get_set");
    private ArrayList<Entry> mPendingCalls;

    @Override
    public int[] getApplicableAsmNodeTypes() {
        return new int[]{5};
    }

    @Override
    public void checkInstruction(ClassContext context, ClassNode classNode, MethodNode method, AbstractInsnNode instruction) {
        if (context.getProject().getMinSdk() >= 9) {
            return;
        }
        if ((method.access & 8) != 0) {
            return;
        }
        if (instruction.getOpcode() != 182) {
            return;
        }
        MethodInsnNode node = (MethodInsnNode)instruction;
        String name = node.name;
        String owner = node.owner;
        AbstractInsnNode prev = LintUtils.getPrevInstruction(instruction);
        if (prev == null || prev.getOpcode() != 25) {
            return;
        }
        VarInsnNode prevVar = (VarInsnNode)prev;
        if (prevVar.var != 0) {
            return;
        }
        if ((name.startsWith("get") && name.length() > 3 && Character.isUpperCase(name.charAt(3)) || name.startsWith("is") && name.length() > 2 && Character.isUpperCase(name.charAt(2))) && owner.equals(classNode.name)) {
            if (this.mPendingCalls == null) {
                this.mPendingCalls = new ArrayList();
            }
            this.mPendingCalls.add(new Entry(name, node, method));
        }
        super.checkInstruction(context, classNode, method, instruction);
    }

    @Override
    public void afterCheckFile(Context c) {
        ClassContext context = (ClassContext)c;
        if (this.mPendingCalls != null) {
            HashSet<String> names = new HashSet<String>(this.mPendingCalls.size());
            for (Entry entry : this.mPendingCalls) {
                names.add(entry.name);
            }
            Map<String, String> getters = FieldGetterDetector.checkMethods(context.getClassNode(), names);
            if (!getters.isEmpty()) {
                for (String getter : getters.keySet()) {
                    for (Entry entry : this.mPendingCalls) {
                        String name = entry.name;
                        if (!name.equals(getter)) continue;
                        Location location = context.getLocation((AbstractInsnNode)entry.call);
                        String fieldName = getters.get(getter);
                        if (fieldName == null) {
                            fieldName = "";
                        }
                        context.report(ISSUE, entry.method, (AbstractInsnNode)entry.call, location, String.format("Calling getter method `%1$s()` on self is slower than field access (`%2$s`)", getter, fieldName));
                    }
                }
            }
        }
        this.mPendingCalls = null;
    }

    private static Map<String, String> checkMethods(ClassNode classNode, Set<String> names) {
        HashMap validGetters = Maps.newHashMap();
        List methods = classNode.methods;
        String fieldName = null;
        block6: for (Object methodObject : methods) {
            MethodNode method = (MethodNode)methodObject;
            if (!names.contains(method.name) || !method.desc.startsWith("()")) continue;
            InsnList instructions = method.instructions;
            int mState = 1;
            block7: for (AbstractInsnNode curr = instructions.getFirst(); curr != null; curr = curr.getNext()) {
                switch (curr.getOpcode()) {
                    case -1: {
                        continue block7;
                    }
                    case 25: {
                        if (mState != true) continue block6;
                        fieldName = null;
                        mState = 2;
                        continue block7;
                    }
                    case 180: {
                        if (mState != 2) continue block6;
                        FieldInsnNode field = (FieldInsnNode)curr;
                        fieldName = field.name;
                        mState = 3;
                        continue block7;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        if (mState != 3) continue block6;
                        validGetters.put(method.name, fieldName);
                        continue block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
        }
        return validGetters;
    }

    private static class Entry {
        public final String name;
        public final MethodNode method;
        public final MethodInsnNode call;

        public Entry(String name, MethodInsnNode call, MethodNode method) {
            this.name = name;
            this.call = call;
            this.method = method;
        }
    }
}

