/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommentDetector
extends ResourceXmlDetector
implements Detector.JavaPsiScanner {
    private static final String STOPSHIP_COMMENT = "STOPSHIP";
    private static final Implementation IMPLEMENTATION = new Implementation(CommentDetector.class, Scope.JAVA_AND_RESOURCE_FILES, Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue EASTER_EGG = Issue.create("EasterEgg", "Code contains easter egg", "An \"easter egg\" is code deliberately hidden in the code, both from potential users and even from other developers. This lint check looks for code which looks like it may be hidden from sight.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue STOP_SHIP = Issue.create("StopShip", "Code contains `STOPSHIP` marker", "Using the comment `// STOPSHIP` can be used to flag code that is incomplete but checked in. This comment marker can be used to indicate that the code should not be shipped until the issue is addressed, and lint will look for these.", Category.CORRECTNESS, 10, Severity.WARNING, IMPLEMENTATION).setEnabledByDefault(false);
    private static final String ESCAPE_STRING = "\\u002a\\u002f";

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return null;
    }

    @Override
    public void afterCheckFile(Context context) {
        if (context instanceof JavaContext) {
            CommentDetector.checkJava((JavaContext)context);
        }
    }

    private static void checkJava(JavaContext context) {
        CharSequence source = context.getContents();
        if (source == null) {
            return;
        }
        int n = source.length() - 1;
        for (int i = 0; i < n; ++i) {
            int end;
            int start;
            char c = source.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (c != '/') continue;
            char next = source.charAt(i + 1);
            if (next == '/') {
                start = i + 2;
                end = CharSequences.indexOf(source, '\n', start);
                if (end == -1) {
                    end = n;
                }
                CommentDetector.checkComment(context, null, null, source, 0, start, end);
                continue;
            }
            if (next != '*') continue;
            start = i + 2;
            end = CharSequences.indexOf(source, "*/", start);
            if (end == -1) {
                end = n;
            }
            CommentDetector.checkComment(context, null, null, source, 0, start, end);
        }
    }

    @Override
    public void visitDocument(XmlContext context, Document document) {
        CommentDetector.checkXml(context, document);
    }

    private static void checkXml(XmlContext context, Node node) {
        if (node.getNodeType() == 8) {
            String source = node.getNodeValue();
            CommentDetector.checkComment(null, context, node, source, 0, 0, source.length());
        }
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            CommentDetector.checkXml(context, children.item(i));
        }
    }

    private static void checkComment(JavaContext javaContext, XmlContext xmlContext, Node xmlNode, CharSequence source, int offset, int start, int end) {
        assert (javaContext != null || xmlContext != null);
        int prev = 0;
        Context context = javaContext != null ? javaContext : xmlContext;
        for (int i = start; i < end - 2; ++i) {
            Location location;
            String message;
            char c = source.charAt(i);
            if (prev == 92) {
                if (c == 'u' || c == 'U') {
                    if (CharSequences.regionMatches(source, true, i - 1, ESCAPE_STRING, 0, ESCAPE_STRING.length())) {
                        message = "Code might be hidden here; found unicode escape sequence which is interpreted as comment end, compiled code follows";
                        if (javaContext != null) {
                            location = Location.create(context.file, source, offset + i - 1, offset + i - 1 + ESCAPE_STRING.length());
                            javaContext.report(EASTER_EGG, (PsiElement)null, location, message);
                        } else {
                            assert (xmlNode != null);
                            location = xmlContext.getLocation(xmlNode, i, i + ESCAPE_STRING.length());
                            xmlContext.report(EASTER_EGG, xmlNode, location, message);
                        }
                    }
                } else {
                    ++i;
                }
            } else if (prev == 83 && c == 'T' && CharSequences.regionMatches(source, i - 1, STOPSHIP_COMMENT, 0, STOPSHIP_COMMENT.length())) {
                message = "`STOPSHIP` comment found; points to code which must be fixed prior to release";
                if (javaContext != null) {
                    location = Location.create(context.file, source, offset + i - 1, offset + i - 1 + STOPSHIP_COMMENT.length());
                    javaContext.report(STOP_SHIP, (PsiElement)null, location, message);
                } else {
                    assert (xmlNode != null);
                    location = xmlContext.getLocation(xmlNode, i, i + STOPSHIP_COMMENT.length());
                    xmlContext.report(STOP_SHIP, xmlNode, location, message);
                }
            }
            prev = c;
        }
    }
}

