/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Arrays;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChildCountDetector
extends LayoutDetector {
    private static final Implementation IMPLEMENTATION = new Implementation(ChildCountDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue SCROLLVIEW_ISSUE = Issue.create("ScrollViewCount", "ScrollViews can have only one child", "ScrollViews can only have one child widget. If you want more children, wrap them in a container layout.", Category.CORRECTNESS, 8, Severity.WARNING, IMPLEMENTATION);
    public static final Issue ADAPTER_VIEW_ISSUE = Issue.create("AdapterViewChildren", "AdapterViews cannot have children in XML", "AdapterViews such as ListViews must be configured with data from Java code, such as a ListAdapter.", Category.CORRECTNESS, 10, Severity.WARNING, IMPLEMENTATION).addMoreInfo("http://developer.android.com/reference/android/widget/AdapterView.html");

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("ScrollView", "HorizontalScrollView", "ListView", "GridView");
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        int childCount = LintUtils.getChildCount(element);
        String tagName = element.getTagName();
        if (tagName.equals("ScrollView") || tagName.equals("HorizontalScrollView")) {
            if (childCount > 1 && ChildCountDetector.getAccurateChildCount(element) > 1) {
                context.report(SCROLLVIEW_ISSUE, element, context.getLocation(element), "A scroll view can have only one child");
            }
        } else if (childCount > 0 && ChildCountDetector.getAccurateChildCount(element) > 0) {
            context.report(ADAPTER_VIEW_ISSUE, element, context.getLocation(element), "A list/grid should have no children declared in XML");
        }
    }

    private static int getAccurateChildCount(Element element) {
        NodeList childNodes = element.getChildNodes();
        int childCount = 0;
        int n = childNodes.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeType() != 1 || "requestFocus".equals(child.getNodeName())) continue;
            ++childCount;
        }
        return childCount;
    }
}

