/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.RtlDetector;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.checks.VersionChecks;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.CharSequences;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.DefaultPosition;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApiDetector
extends ResourceXmlDetector
implements Detector.ClassScanner,
Detector.JavaPsiScanner {
    private static final boolean CHECK_DECLARATIONS = false;
    private static final boolean AOSP_BUILD = System.getenv("ANDROID_BUILD_TOP") != null;
    public static final String REQUIRES_API_ANNOTATION = "android.support.annotation.RequiresApi";
    public static final String SDK_SUPPRESS_ANNOTATION = "android.support.test.filters.SdkSuppress";
    public static final Issue UNSUPPORTED = Issue.create("NewApi", "Calling new methods on older versions", "This check scans through all the Android API calls in the application and warns about any calls that are not available on *all* versions targeted by this application (according to its minimum SDK attribute in the manifest).\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\n\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n\nIf you are deliberately setting `android:` attributes in style definitions, make sure you place this in a `values-vNN` folder in order to avoid running into runtime conflicts on certain devices where manufacturers have added custom attributes whose ids conflict with the new ones on later platforms.\n\nSimilarly, you can use tools:targetApi=\"11\" in an XML file to indicate that the element will only be inflated in an adequate context.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.JAVA_FILE, Scope.RESOURCE_FILE, Scope.MANIFEST), Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.CLASS_FILE_SCOPE, Scope.MANIFEST_SCOPE));
    public static final Issue INLINED = Issue.create("InlinedApi", "Using inlined constants on older versions", "This check scans through all the Android API field references in the application and flags certain constants, such as static final integers and Strings, which were introduced in later versions. These will actually be copied into the class files rather than being referenced, which means that the value is available even when running on older devices. In some cases that's fine, and in other cases it can result in a runtime crash or incorrect behavior. It depends on the context, so consider the code carefully and device whether it's safe and can be suppressed or whether the code needs tbe guarded.\n\nIf you really want to use this API and don't need to support older devices just set the `minSdkVersion` in your `build.gradle` or `AndroidManifest.xml` files.\nIf your code is *deliberately* accessing newer APIs, and you have ensured (e.g. with conditional execution) that this code will only ever be called on a supported platform, then you can annotate your class or method with the `@TargetApi` annotation specifying the local minimum SDK to apply, such as `@TargetApi(11)`, such that this check considers 11 rather than your manifest file's minimum SDK as the required API level.\n", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    public static final Issue OVERRIDE = Issue.create("Override", "Method conflicts with new inherited method", "Suppose you are building against Android API 8, and you've subclassed Activity. In your subclass you add a new method called `isDestroyed`(). At some later point, a method of the same name and signature is added to Android. Your method will now override the Android method, and possibly break its contract. Your method is not calling `super.isDestroyed()`, since your compilation target doesn't know about the method.\n\nThe above scenario is what this lint detector looks for. The above example is real, since `isDestroyed()` was added in API 17, but it will be true for *any* method you have added to a subclass of an Android class where your build target is lower than the version the method was introduced in.\n\nTo fix this, either rename your method, or if you are really trying to augment the builtin method if available, switch to a higher build target where you can deliberately add `@Override` on your overriding method, and call `super` if appropriate etc.\n", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(ApiDetector.class, EnumSet.of(Scope.CLASS_FILE, Scope.JAVA_FILE), Scope.CLASS_FILE_SCOPE, Scope.JAVA_FILE_SCOPE));
    public static final Issue UNUSED = Issue.create("UnusedAttribute", "Attribute unused on older versions", "This check finds attributes set in XML files that were introduced in a version newer than the oldest version targeted by your application (with the `minSdkVersion` attribute).\n\nThis is not an error; the application will simply ignore the attribute. However, if the attribute is important to the appearance of functionality of your application, you should consider finding an alternative way to achieve the same result with only available attributes, and then you can optionally create a copy of the layout in a layout-vNN folder which will be used on API NN or higher where you can take advantage of the newer attribute.\n\nNote: This check does not only apply to attributes. For example, some tags can be unused too, such as the new `<tag>` element in layouts introduced in API 21.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.RESOURCE_FILE_SCOPE));
    public static final Issue OBSOLETE_SDK = Issue.create("ObsoleteSdkInt", "Obsolete SDK_INT Version Check", "This check flags version checks that are not necessary, because the `minSdkVersion` (or surrounding known API level) is already at least as high as the version checked for.", Category.PERFORMANCE, 6, Severity.WARNING, new Implementation(ApiDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String REQ_API_VMSIG = "Landroid/support/annotation/RequiresApi;";
    private static final String SDK_SUPPRESS_VMSIG = "Landroid/support/test/filters/SdkSuppress;";
    private static final String TARGET_API_VMSIG_SUFFIX = "/TargetApi;";
    private static final String SWITCH_TABLE_PREFIX = "$SWITCH_TABLE$";
    private static final String ORDINAL_METHOD = "ordinal";
    public static final String ENUM_SWITCH_PREFIX = "$SwitchMap$";
    private static final String TAG_RIPPLE = "ripple";
    private static final String TAG_VECTOR = "vector";
    private static final String TAG_ANIMATED_VECTOR = "animated-vector";
    private static final String TAG_ANIMATED_SELECTOR = "animated-selector";
    protected ApiLookup mApiDatabase;
    private boolean mWarnedMissingDb;
    private int mMinApi = -1;

    @Override
    public void beforeCheckProject(Context context) {
        if (this.mApiDatabase == null) {
            this.mApiDatabase = ApiLookup.get(context.getClient());
            if (this.mApiDatabase == null && !this.mWarnedMissingDb) {
                this.mWarnedMissingDb = true;
                context.report(IssueRegistry.LINT_ERROR, Location.create(context.file), "Can't find API database; API check not performed");
            } else {
                Location location;
                AndroidSdkHandler sdk = context.getClient().getSdk();
                if (sdk == null) {
                    return;
                }
                LocalPackage pkgInfo = sdk.getLocalPackage("platform-tools", context.getClient().getRepositoryLogger());
                if (pkgInfo == null) {
                    return;
                }
                Revision revision = pkgInfo.getVersion();
                int compileSdkVersion = context.getProject().getBuildSdk();
                if (compileSdkVersion == 23 ? revision.getMajor() > 23 || revision.getMajor() == 23 && (revision.getMinor() > 0 || revision.getMicro() > 0) : compileSdkVersion <= revision.getMajor()) {
                    return;
                }
                List<File> currentFiles = context.getProject().getSubset();
                if (currentFiles != null && currentFiles.size() == 1) {
                    File file = currentFiles.get(0);
                    CharSequence contents = context.getClient().readFile(file);
                    int firstLineEnd = CharSequences.indexOf(contents, '\n');
                    if (firstLineEnd == -1) {
                        firstLineEnd = contents.length();
                    }
                    location = Location.create(file, new DefaultPosition(0, 0, 0), new DefaultPosition(0, firstLineEnd, firstLineEnd));
                } else {
                    location = Location.create(context.file);
                }
                context.report(UNSUPPORTED, location, String.format("The SDK platform-tools version (%1$s) is too old  to check APIs compiled with API %2$d; please update", revision.toShortString(), compileSdkVersion));
            }
        }
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return true;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        int api;
        int minSdk;
        String prefix;
        String message;
        Location location;
        String owner;
        if (this.mApiDatabase == null) {
            return;
        }
        int attributeApiLevel = -1;
        if ("http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            int minSdk2;
            int minSdk3;
            String name = attribute.getLocalName();
            if (!(name.equals("layout_width") && !name.equals("layout_height") && !name.equals("id") || (attributeApiLevel = this.mApiDatabase.getFieldVersion(owner = "android/R$attr", name)) <= (minSdk3 = this.getMinSdk(context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(attribute.getOwnerElement()) || ApiDetector.isBenignUnusedAttribute(name) || ApiDetector.isAlreadyWarnedDrawableFile(context, attribute, attributeApiLevel))) {
                if (RtlDetector.isRtlAttributeName(name) || "supportsRtl".equals(name)) {
                    if (name.equals("paddingStart")) {
                        boolean isOldBuildTools;
                        BuildToolInfo buildToolInfo = context.getProject().getBuildTools();
                        Revision buildTools = buildToolInfo != null ? buildToolInfo.getRevision() : null;
                        boolean bl = isOldBuildTools = buildTools != null && (buildTools.getMajor() < 23 || buildTools.getMajor() == 23 && buildTools.getMinor() == 0 && buildTools.getMicro() == 0);
                        if ((buildTools == null || isOldBuildTools) && ApiDetector.viewMayExtendTextView(attribute.getOwnerElement())) {
                            location = context.getLocation(attribute);
                            message = String.format("Attribute `%1$s` referenced here can result in a crash on some specific devices older than API %2$d (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk3);
                            if (buildTools != null) {
                                message = String.format("Upgrade `buildToolsVersion` from `%1$s` to at least `23.0.1`; if not, ", buildTools.toShortString()) + Character.toLowerCase(message.charAt(0)) + message.substring(1);
                            }
                            context.report(UNSUPPORTED, attribute, location, message);
                        }
                    }
                } else {
                    Location location2 = context.getLocation(attribute);
                    String message2 = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk3);
                    context.report(UNUSED, attribute, location2, message2);
                }
            }
            if (name.equals("divider")) {
                return;
            }
            if (name.equals("theme") && "include".equals(attribute.getOwnerElement().getTagName()) && Math.max(minSdk2 = this.getMinSdk(context), context.getFolderVersion()) < 23) {
                Location location3 = context.getLocation(attribute);
                String message3 = String.format("Attribute `android:theme` is only used by `<include>` tags in API level 23 and higher (current min is %1$d)", minSdk2);
                context.report(UNUSED, attribute, location3, message3);
            }
        }
        String value = attribute.getValue();
        owner = null;
        String name = null;
        if (value.startsWith("@android:")) {
            prefix = "@android:";
        } else if (value.startsWith("?android:")) {
            int api2;
            prefix = "?android:";
            if (context.getResourceFolderType() == ResourceFolderType.DRAWABLE && (api2 = 21) > (minSdk = this.getMinSdk(context)) && api2 > context.getFolderVersion() && api2 > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
                location = context.getLocation(attribute);
                message = String.format("Using theme references in XML drawables requires API level %1$d (current min is %2$d)", api2, minSdk);
                context.report(UNSUPPORTED, attribute, location, message);
                return;
            }
        } else if (value.startsWith("android:") && "name".equals(attribute.getName()) && "item".equals(attribute.getOwnerElement().getTagName()) && attribute.getOwnerElement().getParentNode() != null && "style".equals(attribute.getOwnerElement().getParentNode().getNodeName())) {
            owner = "android/R$attr";
            name = value.substring("android:".length());
            prefix = null;
        } else if (value.startsWith("android:") && "parent".equals(attribute.getName()) && "style".equals(attribute.getOwnerElement().getTagName())) {
            owner = "android/R$style";
            name = SdkUtils.getResourceFieldName((String)value.substring("android:".length()));
            prefix = null;
        } else {
            return;
        }
        if (owner == null) {
            int index = value.indexOf(47, prefix.length());
            if (index != -1) {
                owner = "android/R$" + value.substring(prefix.length(), index);
                name = SdkUtils.getResourceFieldName((String)value.substring(index + 1));
            } else if (value.startsWith("?android:")) {
                owner = "android/R$attr";
                name = value.substring("?android:".length());
            } else {
                return;
            }
        }
        if ((api = this.mApiDatabase.getFieldVersion(owner, name)) > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(attribute.getOwnerElement())) {
            if ("http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) {
                return;
            }
            if (attributeApiLevel < api) {
                if (attributeApiLevel > minSdk) {
                    String attributeName = attribute.getLocalName();
                    Location location4 = context.getLocation(attribute);
                    String message4 = String.format("`%1$s` requires API level %2$d (current min is %3$d), but note that attribute `%4$s` is only used in API level %5$d and higher", name, api, minSdk, attributeName, attributeApiLevel);
                    context.report(UNSUPPORTED, attribute, location4, message4);
                } else {
                    location = context.getLocation(attribute);
                    message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", value, api, minSdk);
                    context.report(UNSUPPORTED, attribute, location, message);
                }
            }
        }
    }

    private static boolean viewMayExtendTextView(Element element) {
        String tag = element.getTagName();
        if (tag.equals("view") && ((tag = element.getAttribute("class")) == null || tag.isEmpty())) {
            return false;
        }
        if (tag.indexOf(46) != -1) {
            return true;
        }
        return tag.contains("Text") || tag.contains("Button") || tag.equals("DigitalClock") || tag.equals("Chronometer") || tag.equals("CheckBox") || tag.equals("Switch");
    }

    private static boolean isAlreadyWarnedDrawableFile(XmlContext context, Attr attribute, int attributeApiLevel) {
        String root;
        return context.getResourceFolderType() == ResourceFolderType.DRAWABLE && attributeApiLevel == 21 && (TAG_RIPPLE.equals(root = attribute.getOwnerDocument().getDocumentElement().getTagName()) || TAG_VECTOR.equals(root) || TAG_ANIMATED_VECTOR.equals(root) || TAG_ANIMATED_SELECTOR.equals(root));
    }

    public static boolean isBenignUnusedAttribute(String name) {
        return "labelFor".equals(name) || "textIsSelectable".equals(name) || "textAlignment".equals(name) || "roundIcon".equals(name) || "fullBackupContent".equals(name);
    }

    @Override
    public void visitElement(XmlContext context, Element element) {
        if (this.mApiDatabase == null) {
            return;
        }
        String tag = element.getTagName();
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType != ResourceFolderType.LAYOUT) {
            if (folderType == ResourceFolderType.DRAWABLE) {
                this.checkElement(context, element, TAG_VECTOR, 21, "1.4", UNSUPPORTED);
                this.checkElement(context, element, TAG_RIPPLE, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_SELECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, TAG_ANIMATED_VECTOR, 21, null, UNSUPPORTED);
                this.checkElement(context, element, "drawable", 24, null, UNSUPPORTED);
                if ("layer-list".equals(tag)) {
                    this.checkLevelList(context, element);
                } else if (tag.contains(".")) {
                    this.checkElement(context, element, tag, 24, null, UNSUPPORTED);
                }
            }
            if (element.getParentNode().getNodeType() != 1) {
                return;
            }
            NodeList childNodes = element.getChildNodes();
            int n = childNodes.getLength();
            for (int i = 0; i < n; ++i) {
                int minSdk;
                String name;
                String owner;
                int api;
                String typeString;
                int index;
                String text;
                Node textNode = childNodes.item(i);
                if (textNode.getNodeType() != 3 || !(text = textNode.getNodeValue()).contains("@android:") || (index = (text = text.trim()).indexOf(47, "@android:".length())) == -1 || ResourceType.getEnum((String)(typeString = text.substring("@android:".length(), index))) == null || (api = this.mApiDatabase.getFieldVersion(owner = "android/R$" + typeString, name = SdkUtils.getResourceFieldName((String)text.substring(index + 1)))) <= (minSdk = this.getMinSdk(context)) || api <= context.getFolderVersion() || api <= ApiDetector.getLocalMinSdk(element)) continue;
                Location location = context.getLocation(textNode);
                String message = String.format("`%1$s` requires API level %2$d (current min is %3$d)", text, api, minSdk);
                context.report(UNSUPPORTED, element, location, message);
            }
        } else {
            int minSdk;
            int api;
            if ("view".equals(tag)) {
                tag = element.getAttribute("class");
                if (tag == null || tag.isEmpty()) {
                    return;
                }
            } else {
                this.checkElement(context, element, "tag", 21, null, UNUSED);
            }
            if (tag.indexOf(46) != -1) {
                return;
            }
            String fqn = "android/widget/" + tag;
            if (tag.equals("TextureView")) {
                fqn = "android/view/TextureView";
            }
            if ((api = this.mApiDatabase.getClassVersion(fqn)) > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element)) {
                Location location = context.getLocation(element);
                String message = String.format("View requires API level %1$d (current min is %2$d): `<%3$s>`", api, minSdk, tag);
                context.report(UNSUPPORTED, element, location, message);
            }
        }
    }

    private void checkLevelList(XmlContext context, Element element) {
        for (Node curr = element.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
            int minSdk;
            int attributeApiLevel;
            Element e;
            if (curr.getNodeType() != 1 || !"item".equals(curr.getNodeName()) || !(e = (Element)curr).hasAttributeNS("http://schemas.android.com/apk/res/android", "width") && !e.hasAttributeNS("http://schemas.android.com/apk/res/android", "height") || (attributeApiLevel = 23) <= (minSdk = this.getMinSdk(context)) || attributeApiLevel <= context.getFolderVersion() || attributeApiLevel <= ApiDetector.getLocalMinSdk(element)) continue;
            for (String attributeName : new String[]{"width", "height"}) {
                Attr attribute = e.getAttributeNodeNS("http://schemas.android.com/apk/res/android", attributeName);
                if (attribute == null) continue;
                Location location = context.getLocation(attribute);
                String message = String.format("Attribute `%1$s` is only used in API level %2$d and higher (current min is %3$d)", attribute.getLocalName(), attributeApiLevel, minSdk);
                context.report(UNUSED, attribute, location, message);
            }
        }
    }

    private void checkElement(XmlContext context, Element element, String tag, int api, String gradleVersion, Issue issue) {
        int minSdk;
        if (tag.equals(element.getTagName()) && api > (minSdk = this.getMinSdk(context)) && api > context.getFolderVersion() && api > ApiDetector.getLocalMinSdk(element) && !ApiDetector.featureProvidedByGradle(context, gradleVersion)) {
            String message;
            Location location = context.getLocation(element);
            if ("drawable".equals(tag)) {
                Attr attribute = element.getAttributeNode("class");
                if (attribute == null) {
                    return;
                }
                location = context.getLocation(attribute);
                tag = "class";
            }
            if (issue == UNSUPPORTED) {
                message = String.format("`<%1$s>` requires API level %2$d (current min is %3$d)", tag, api, minSdk);
                if (gradleVersion != null) {
                    message = message + String.format(" or building with Android Gradle plugin %1$s or higher", gradleVersion);
                } else if (tag.contains(".")) {
                    message = String.format("Custom drawables requires API level %1$d (current min is %2$d)", api, minSdk);
                }
            } else {
                assert (issue == UNUSED) : issue;
                message = String.format("`<%1$s>` is only used in API level %2$d and higher (current min is %3$d)", tag, api, minSdk);
            }
            context.report(issue, element, location, message);
        }
    }

    protected int getMinSdk(Context context) {
        if (this.mMinApi == -1) {
            AndroidVersion minSdkVersion = context.getMainProject().getMinSdkVersion();
            this.mMinApi = minSdkVersion.getFeatureLevel();
            if (this.mMinApi == 1 && !context.getMainProject().isAndroidProject()) {
                this.mMinApi = Integer.MAX_VALUE;
            }
        }
        return this.mMinApi;
    }

    @Override
    public void checkClass(ClassContext context, ClassNode classNode) {
        List methodList;
        if (!context.getDriver().hasParserErrors() && !context.getProject().getJavaSourceFolders().isEmpty()) {
            return;
        }
        if (this.mApiDatabase == null) {
            return;
        }
        if (AOSP_BUILD && classNode.name.startsWith("android/support/")) {
            return;
        }
        int classMinSdk = ApiDetector.getClassMinSdk(context, classNode);
        if (classMinSdk == -1) {
            classMinSdk = this.getMinSdk(context);
        }
        if ((methodList = classNode.methods).isEmpty()) {
            return;
        }
        boolean checkCalls = context.isEnabled(UNSUPPORTED) || context.isEnabled(INLINED);
        boolean checkMethods = context.isEnabled(OVERRIDE) && context.getMainProject().getBuildSdk() >= 1;
        Object frameworkParent = null;
        if (checkMethods) {
            LintDriver driver = context.getDriver();
            Object owner = classNode.superName;
            while (owner != null) {
                if (((String)owner).startsWith("android/") && !((String)owner).startsWith("android/support/") || ((String)owner).startsWith("java/") || ((String)owner).startsWith("javax/")) {
                    frameworkParent = owner;
                    break;
                }
                owner = driver.getSuperClass((String)owner);
            }
            if (frameworkParent == null) {
                checkMethods = false;
            }
        }
        if (checkCalls) {
            if (classNode.superName != null) {
                String signature = classNode.superName;
                this.checkExtendsClass(context, classNode, classMinSdk, signature);
            }
            if (classNode.interfaces != null) {
                List interfaceList = classNode.interfaces;
                for (String signature : interfaceList) {
                    this.checkExtendsClass(context, classNode, classMinSdk, signature);
                }
            }
        }
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            int minSdk = ApiDetector.getLocalMinSdk(method.invisibleAnnotations);
            if (minSdk == -1) {
                minSdk = classMinSdk;
            }
            InsnList nodes = method.instructions;
            if (checkMethods && Character.isJavaIdentifierStart(method.name.charAt(0))) {
                int buildSdk = context.getMainProject().getBuildSdk();
                String name = method.name;
                assert (frameworkParent != null);
                int api = this.mApiDatabase.getCallVersion((String)frameworkParent, name, method.desc);
                if (api > buildSdk && buildSdk != -1) {
                    String owner = classNode.name;
                    String fqcn = "<init>".equals(name) ? "new " + ClassContext.getFqcn(owner) : ClassContext.getFqcn(owner) + '#' + name;
                    String message = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): `%3$s`", api, buildSdk, fqcn);
                    Location location = context.getLocation(method, classNode);
                    context.report(OVERRIDE, method, null, location, message);
                }
            }
            if (!checkCalls) continue;
            List tryCatchBlocks = method.tryCatchBlocks;
            if (tryCatchBlocks.size() > 1) {
                ArrayList checked = Lists.newArrayList();
                for (Object o : tryCatchBlocks) {
                    int api;
                    TryCatchBlockNode tryCatchBlock = (TryCatchBlockNode)o;
                    String className = tryCatchBlock.type;
                    if (className == null || checked.contains(className) || (api = this.mApiDatabase.getClassVersion(className)) <= minSdk) continue;
                    LabelNode label = tryCatchBlock.handler;
                    String fqcn = ClassContext.getFqcn(className);
                    String message = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                    ApiDetector.report(context, message, (AbstractInsnNode)label, method, className.substring(className.lastIndexOf(47) + 1), null, Location.SearchHints.create(Location.SearchDirection.EOL_NEAREST).matchJavaSymbol());
                }
            }
            int n = nodes.size();
            block4: for (int i = 0; i < n; ++i) {
                Type t;
                String className;
                int api;
                String owner;
                String name;
                MethodInsnNode node;
                AbstractInsnNode instruction = nodes.get(i);
                int type = instruction.getType();
                if (type == 5) {
                    node = (MethodInsnNode)instruction;
                    name = node.name;
                    owner = node.owner;
                    String desc = node.desc;
                    if (node.getOpcode() == 182 && owner.equals(classNode.name)) {
                        owner = classNode.superName;
                    }
                    boolean checkingSuperClass = false;
                    while (owner != null) {
                        int api2 = this.mApiDatabase.getCallVersion(owner, name, desc);
                        if (api2 > minSdk) {
                            if (method.name.startsWith(SWITCH_TABLE_PREFIX) || !checkingSuperClass && node.getOpcode() == 182 && ApiDetector.methodDefinedLocally(classNode, name, desc)) continue block4;
                            String fqcn = "<init>".equals(name) ? "new " + ClassContext.getFqcn(owner) : ClassContext.getFqcn(owner) + '#' + name;
                            String message = String.format("Call requires API level %1$d (current min is %2$d): `%3$s`", api2, minSdk, fqcn);
                            if (name.equals(ORDINAL_METHOD) && instruction.getNext() != null && instruction.getNext().getNext() != null && instruction.getNext().getOpcode() == 46 && instruction.getNext().getNext().getOpcode() == 170) {
                                message = String.format("Enum for switch requires API level %1$d (current min is %2$d): `%3$s`", api2, minSdk, ClassContext.getFqcn(owner));
                            }
                            if (instruction.getOpcode() == 183 && name.equals(method.name) && desc.equals(method.desc) && !name.equals("<init>") || VersionChecks.isWithinSdkConditional(context, classNode, method, instruction, api2)) continue block4;
                            if (api2 == 19 && owner.equals("java/lang/ReflectiveOperationException") && !method.tryCatchBlocks.isEmpty()) {
                                boolean direct = false;
                                for (Object o : method.tryCatchBlocks) {
                                    if (!((TryCatchBlockNode)o).type.equals("java/lang/ReflectiveOperationException")) continue;
                                    direct = true;
                                    break;
                                }
                                if (!direct) {
                                    message = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %2$d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", api2, minSdk);
                                }
                            }
                            if (api2 == 24 && "java.util.concurrent.ConcurrentHashMap.KeySetView#iterator".equals(fqcn)) {
                                message = message + ". The `keySet()` method in `ConcurrentHashMap` changed in a backwards incompatible way in Java 8; to work around this issue, add an explicit cast to `(Map)` before the `keySet()` call.";
                            }
                            ApiDetector.report(context, message, (AbstractInsnNode)node, method, name, null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
                            continue block4;
                        }
                        if (owner.startsWith("android/") || owner.startsWith("javax/")) {
                            owner = owner.startsWith("android/support/") && api2 == -1 ? context.getDriver().getSuperClass(owner) : null;
                        } else if (owner.startsWith("java/")) {
                            if (owner.equals("java/text/SimpleDateFormat")) {
                                ApiDetector.checkSimpleDateFormat(context, method, node, minSdk);
                            }
                            owner = null;
                        } else {
                            owner = node.getOpcode() == 182 ? context.getDriver().getSuperClass(owner) : (node.getOpcode() == 184 && api2 == -1 ? context.getDriver().getSuperClass(owner) : null);
                        }
                        checkingSuperClass = true;
                    }
                    continue;
                }
                if (type == 4) {
                    node = (FieldInsnNode)instruction;
                    owner = node.owner;
                    name = node.name;
                    int api3 = this.mApiDatabase.getFieldVersion(owner, name);
                    if (api3 <= minSdk) continue;
                    if (method.name.startsWith(SWITCH_TABLE_PREFIX)) {
                        ApiDetector.checkSwitchBlock(context, classNode, (FieldInsnNode)node, method, name, owner, api3, minSdk);
                        continue;
                    }
                    if (ApiDetector.isSkippedEnumSwitch(context, classNode, method, (FieldInsnNode)node, owner, api3) || VersionChecks.isWithinSdkConditional(context, classNode, method, instruction, api3)) continue;
                    String fqcn = ClassContext.getFqcn(owner) + '#' + name;
                    String message = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api3, minSdk, fqcn);
                    ApiDetector.report(context, message, (AbstractInsnNode)node, method, name, null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
                    continue;
                }
                if (type != 9) continue;
                node = (LdcInsnNode)instruction;
                if (!(node.cst instanceof Type) || (api = this.mApiDatabase.getClassVersion(className = (t = (Type)node.cst).getInternalName())) <= minSdk) continue;
                String fqcn = ClassContext.getFqcn(className);
                String message = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                ApiDetector.report(context, message, (AbstractInsnNode)node, method, className.substring(className.lastIndexOf(47) + 1), null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
            }
        }
    }

    private void checkExtendsClass(ClassContext context, ClassNode classNode, int classMinSdk, String signature) {
        int api = this.mApiDatabase.getClassVersion(signature);
        if (api > classMinSdk) {
            String fqcn = ClassContext.getFqcn(signature);
            String message = String.format("Class requires API level %1$d (current min is %2$d): `%3$s`", api, classMinSdk, fqcn);
            String name = signature.substring(signature.lastIndexOf(47) + 1);
            name = name.substring(name.lastIndexOf(36) + 1);
            Location.SearchHints hints = Location.SearchHints.create(Location.SearchDirection.BACKWARD).matchJavaSymbol();
            int lineNumber = ClassContext.findLineNumber(classNode);
            Location location = context.getLocationForLine(lineNumber, name, null, hints);
            context.report(UNSUPPORTED, location, message);
        }
    }

    private static void checkSimpleDateFormat(ClassContext context, MethodNode method, MethodInsnNode node, int minSdk) {
        if (minSdk >= 9) {
            return;
        }
        if (node.name.equals("<init>") && !node.desc.equals("()V")) {
            AbstractInsnNode prev = LintUtils.getPrevInstruction((AbstractInsnNode)node);
            if (prev != null && !node.desc.equals("(Ljava/lang/String;)V")) {
                prev = LintUtils.getPrevInstruction(prev);
            }
            if (prev != null && prev.getOpcode() == 18) {
                LdcInsnNode ldc = (LdcInsnNode)prev;
                Object cst = ldc.cst;
                if (cst instanceof String) {
                    String pattern = (String)cst;
                    boolean isEscaped = false;
                    for (int i = 0; i < pattern.length(); ++i) {
                        char c = pattern.charAt(i);
                        if (c == '\'') {
                            isEscaped = !isEscaped;
                            continue;
                        }
                        if (isEscaped || c != 'L' && c != 'c') continue;
                        String message = String.format("The pattern character '%1$c' requires API level 9 (current min is %2$d) : \"`%3$s`\"", Character.valueOf(c), minSdk, pattern);
                        ApiDetector.report(context, message, (AbstractInsnNode)node, method, pattern, null, Location.SearchHints.create(Location.SearchDirection.FORWARD));
                        return;
                    }
                }
            }
        }
    }

    private static void checkSimpleDateFormat(JavaContext context, PsiCallExpression call, int minSdk) {
        if (minSdk >= 9) {
            return;
        }
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiExpression[] expressions = argumentList.getExpressions();
        if (expressions.length == 0) {
            return;
        }
        PsiExpression argument = expressions[0];
        Object constant = ConstantEvaluator.evaluate(context, (PsiElement)argument);
        if (constant instanceof String) {
            String pattern = (String)constant;
            boolean isEscaped = false;
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '\'') {
                    isEscaped = !isEscaped;
                    continue;
                }
                if (isEscaped || c != 'L' && c != 'c') continue;
                String message = String.format("The pattern character '%1$c' requires API level 9 (current min is %2$d) : \"`%3$s`\"", Character.valueOf(c), minSdk, pattern);
                context.report(UNSUPPORTED, (PsiElement)call, context.getRangeLocation((PsiElement)argument, i + 1, 1), message);
                return;
            }
        }
    }

    private static boolean methodDefinedLocally(ClassNode classNode, String name, String desc) {
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!name.equals(method.name) || !desc.equals(method.desc)) continue;
            return true;
        }
        return false;
    }

    private static void checkSwitchBlock(ClassContext context, ClassNode classNode, FieldInsnNode field, MethodNode method, String name, String owner, int api, int minSdk) {
        int ordinal;
        AbstractInsnNode next = field.getNext();
        if (next == null || next.getOpcode() != 182) {
            return;
        }
        if ((next = next.getNext()) == null) {
            return;
        }
        switch (next.getOpcode()) {
            case 3: {
                ordinal = 0;
                break;
            }
            case 4: {
                ordinal = 1;
                break;
            }
            case 5: {
                ordinal = 2;
                break;
            }
            case 6: {
                ordinal = 3;
                break;
            }
            case 7: {
                ordinal = 4;
                break;
            }
            case 8: {
                ordinal = 5;
                break;
            }
            case 16: {
                IntInsnNode iin = (IntInsnNode)next;
                ordinal = iin.operand;
                break;
            }
            default: {
                return;
            }
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            InsnList nodes = ((MethodNode)m).instructions;
            int n = nodes.size();
            block10: for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                if (instruction.getOpcode() != 184) continue;
                MethodInsnNode node = (MethodInsnNode)instruction;
                if (!node.name.equals(method.name) || !node.desc.equals(method.desc) || !node.owner.equals(classNode.name)) continue;
                AbstractInsnNode target = LintUtils.getNextInstruction((AbstractInsnNode)node);
                while (target != null) {
                    if (target.getOpcode() == 171) {
                        LookupSwitchInsnNode lookup = (LookupSwitchInsnNode)target;
                        List keys = lookup.keys;
                        if (keys != null && keys.contains(ordinal)) {
                            String fqcn = ClassContext.getFqcn(owner) + '#' + name;
                            String message = String.format("Enum value requires API level %1$d (current min is %2$d): `%3$s`", api, minSdk, fqcn);
                            ApiDetector.report(context, message, (AbstractInsnNode)lookup, (MethodNode)m, name, null, Location.SearchHints.create(Location.SearchDirection.FORWARD).matchJavaSymbol());
                            continue block10;
                        }
                    }
                    target = LintUtils.getNextInstruction(target);
                }
            }
        }
    }

    private static boolean isEnumSwitchInitializer(ClassNode classNode) {
        List fieldList = classNode.fields;
        for (Object f : fieldList) {
            FieldNode field = (FieldNode)f;
            if (!field.name.startsWith(ENUM_SWITCH_PREFIX)) continue;
            return true;
        }
        return false;
    }

    private static MethodNode findEnumSwitchUsage(ClassNode classNode, String owner) {
        String target = ENUM_SWITCH_PREFIX + owner.replace('/', '$');
        List methodList = classNode.methods;
        for (Object f : methodList) {
            MethodNode method = (MethodNode)f;
            InsnList nodes = method.instructions;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                if (instruction.getOpcode() != 178) continue;
                FieldInsnNode field = (FieldInsnNode)instruction;
                if (!field.name.equals(target)) continue;
                return method;
            }
        }
        return null;
    }

    private static boolean isSkippedEnumSwitch(ClassContext context, ClassNode classNode, MethodNode method, FieldInsnNode node, String owner, int api) {
        MethodNode switchUser;
        LintDriver driver;
        ClassNode outer;
        AbstractInsnNode next = LintUtils.getNextInstruction((AbstractInsnNode)node);
        if (next != null && next.getOpcode() == 182 && "<clinit>".equals(method.name) && ORDINAL_METHOD.equals(((MethodInsnNode)next).name) && classNode.outerClass != null && ApiDetector.isEnumSwitchInitializer(classNode) && (outer = (driver = context.getDriver()).getOuterClassNode(classNode)) != null && (switchUser = ApiDetector.findEnumSwitchUsage(outer, owner)) != null) {
            if (driver.isSuppressed(UNSUPPORTED, outer, switchUser, null)) {
                return true;
            }
            if (ApiDetector.getLocalMinSdk(switchUser.invisibleAnnotations) >= api || ApiDetector.getLocalMinSdk(outer.invisibleAnnotations) >= api) {
                return true;
            }
        }
        return false;
    }

    private static int getClassMinSdk(ClassContext context, ClassNode classNode) {
        int classMinSdk = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations);
        if (classMinSdk != -1) {
            return classMinSdk;
        }
        LintDriver driver = context.getDriver();
        while (classNode != null) {
            ClassNode prev = classNode;
            if ((classNode = driver.getOuterClassNode(classNode)) == null) continue;
            if (prev.outerMethod != null) {
                List methods = classNode.methods;
                for (Object m : methods) {
                    MethodNode method = (MethodNode)m;
                    if (!method.name.equals(prev.outerMethod) || !method.desc.equals(prev.outerMethodDesc)) continue;
                    int methodMinSdk = ApiDetector.getLocalMinSdk(method.invisibleAnnotations);
                    if (methodMinSdk == -1) break;
                    return methodMinSdk;
                }
            }
            if ((classMinSdk = ApiDetector.getLocalMinSdk(classNode.invisibleAnnotations)) == -1) continue;
            return classMinSdk;
        }
        return -1;
    }

    private static int getLocalMinSdk(List annotations) {
        if (annotations != null) {
            for (AnnotationNode annotation : annotations) {
                Object value;
                String key;
                int i;
                int n;
                String desc = annotation.desc;
                if (desc.endsWith(TARGET_API_VMSIG_SUFFIX)) {
                    if (annotation.values == null) continue;
                    n = annotation.values.size();
                    for (i = 0; i < n; i += 2) {
                        key = (String)annotation.values.get(i);
                        if (!key.equals("value") || !((value = annotation.values.get(i + 1)) instanceof Integer)) continue;
                        return (Integer)value;
                    }
                    continue;
                }
                if (!desc.equals(REQ_API_VMSIG) && !desc.equals(SDK_SUPPRESS_VMSIG) || annotation.values == null) continue;
                n = annotation.values.size();
                for (i = 0; i < n; i += 2) {
                    int api;
                    key = (String)annotation.values.get(i);
                    if (!key.equals("value") && !key.equals("api") && !key.equals("minSdkVersion") || !((value = annotation.values.get(i + 1)) instanceof Integer) || (api = ((Integer)value).intValue()) <= 1) continue;
                    return api;
                }
            }
        }
        return -1;
    }

    private static int getLocalMinSdk(Element element) {
        while (element != null) {
            String targetApi = element.getAttributeNS("http://schemas.android.com/tools", "targetApi");
            if (targetApi != null && !targetApi.isEmpty()) {
                if (Character.isDigit(targetApi.charAt(0))) {
                    try {
                        return Integer.parseInt(targetApi);
                    }
                    catch (NumberFormatException e) {
                        break;
                    }
                }
                return SdkVersionInfo.getApiByBuildCode((String)targetApi, (boolean)true);
            }
            Node parent = element.getParentNode();
            if (parent == null || parent.getNodeType() != 1) break;
            element = (Element)parent;
        }
        return -1;
    }

    private static boolean featureProvidedByGradle(XmlContext context, String minGradleVersionString) {
        GradleVersion minVersion;
        if (minGradleVersionString == null) {
            return false;
        }
        GradleVersion gradleModelVersion = context.getProject().getGradleModelVersion();
        return gradleModelVersion != null && (minVersion = GradleVersion.tryParse((String)minGradleVersionString)) != null && gradleModelVersion.compareIgnoringQualifiers(minVersion) >= 0;
    }

    private static void report(ClassContext context, String message, AbstractInsnNode node, MethodNode method, String patternStart, String patternEnd, Location.SearchHints hints) {
        int lineNumber;
        int n = lineNumber = node != null ? ClassContext.findLineNumber(node) : -1;
        if (patternStart != null && patternStart.equals("<init>") && node instanceof MethodInsnNode) {
            if (hints != null) {
                hints = hints.matchConstructor();
            }
            patternStart = ((MethodInsnNode)node).owner;
        }
        if (patternStart != null) {
            int index = patternStart.lastIndexOf(36);
            if (index != -1) {
                patternStart = patternStart.substring(index + 1);
            }
            if ((index = patternStart.lastIndexOf(47)) != -1) {
                patternStart = patternStart.substring(index + 1);
            }
        }
        Location location = context.getLocationForLine(lineNumber, patternStart, patternEnd, hints);
        context.report(UNSUPPORTED, method, node, location, message);
    }

    @Override
    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        if (this.mApiDatabase == null || context.isTestSource()) {
            return new JavaElementVisitor(){};
        }
        return new ApiVisitor(context);
    }

    @Override
    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        ArrayList<Class<? extends PsiElement>> types = new ArrayList<Class<? extends PsiElement>>(12);
        types.add(PsiImportStaticStatement.class);
        types.add(PsiReferenceExpression.class);
        types.add(PsiLocalVariable.class);
        types.add(PsiTryStatement.class);
        types.add(PsiTypeCastExpression.class);
        types.add(PsiAssignmentExpression.class);
        types.add(PsiCallExpression.class);
        types.add(PsiClass.class);
        types.add(PsiMethod.class);
        types.add(PsiForeachStatement.class);
        types.add(PsiClassObjectAccessExpression.class);
        types.add(PsiSwitchStatement.class);
        return types;
    }

    public static boolean isBenignConstantUsage(PsiElement node, String name, String owner) {
        if (owner.equals("android/os/Build$VERSION_CODES")) {
            return true;
        }
        if (owner.equals("android/view/ViewGroup$LayoutParams") && name.equals("MATCH_PARENT")) {
            return true;
        }
        if (owner.equals("android/widget/AbsListView") && (name.equals("CHOICE_MODE_NONE") || name.equals("CHOICE_MODE_MULTIPLE") || name.equals("CHOICE_MODE_SINGLE"))) {
            return true;
        }
        if ("android/view/Gravity".equals(owner) && ("START".equals(name) || "END".equals(name))) {
            return true;
        }
        if (node == null) {
            return false;
        }
        for (PsiElement curr = node.getParent(); curr != null; curr = curr.getParent()) {
            if (curr instanceof PsiSwitchLabelStatement) {
                PsiExpression condition = ((PsiSwitchLabelStatement)curr).getCaseValue();
                return condition != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
            }
            if (curr instanceof PsiIfStatement) {
                PsiExpression condition = ((PsiIfStatement)curr).getCondition();
                return condition != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
            }
            if (curr instanceof PsiConditionalExpression) {
                PsiExpression condition = ((PsiConditionalExpression)curr).getCondition();
                return PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)node, (boolean)false);
            }
            if (curr instanceof PsiMethod || curr instanceof PsiClass) break;
        }
        return false;
    }

    private static boolean isSuppressed(JavaContext context, int api, PsiElement element, int minSdk) {
        if (api <= minSdk) {
            return true;
        }
        int target = ApiDetector.getTargetApi(element);
        if (target != -1 && api <= target) {
            return true;
        }
        LintDriver driver = context.getDriver();
        return driver.isSuppressed(context, UNSUPPORTED, element) || driver.isSuppressed(context, INLINED, element) || VersionChecks.isWithinVersionCheckConditional(element, api) || VersionChecks.isPrecededByVersionCheckExit(element, api);
    }

    public static int getTargetApi(PsiElement scope) {
        while (scope != null) {
            PsiModifierList modifierList;
            int targetApi;
            if (scope instanceof PsiModifierListOwner && (targetApi = ApiDetector.getTargetApi(modifierList = ((PsiModifierListOwner)scope).getModifierList())) != -1) {
                return targetApi;
            }
            if (!((scope = scope.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return -1;
    }

    public static int getTargetApi(PsiModifierList modifierList) {
        if (modifierList == null) {
            return -1;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            String fqcn = annotation.getQualifiedName();
            if (fqcn == null || !fqcn.equals("android.annotation.TargetApi") && !fqcn.equals(REQUIRES_API_ANNOTATION) && !fqcn.equals(SDK_SUPPRESS_ANNOTATION) && !fqcn.equals("TargetApi")) continue;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair pair : parameterList.getAttributes()) {
                PsiAnnotationMemberValue v = pair.getValue();
                if (v instanceof PsiLiteral) {
                    PsiLiteral literal = (PsiLiteral)v;
                    Object value = literal.getValue();
                    if (value instanceof Integer) {
                        return (Integer)value;
                    }
                    if (!(value instanceof String)) continue;
                    return VersionChecks.codeNameToApi((String)value);
                }
                if (v instanceof PsiArrayInitializerMemberValue) {
                    PsiArrayInitializerMemberValue mv = (PsiArrayInitializerMemberValue)v;
                    for (PsiAnnotationMemberValue mmv : mv.getInitializers()) {
                        if (!(mmv instanceof PsiLiteral)) continue;
                        PsiLiteral literal = (PsiLiteral)mmv;
                        Object value = literal.getValue();
                        if (value instanceof Integer) {
                            return (Integer)value;
                        }
                        if (!(value instanceof String)) continue;
                        return VersionChecks.codeNameToApi((String)value);
                    }
                    continue;
                }
                if (!(v instanceof PsiExpression)) continue;
                if (v instanceof PsiReferenceExpression) {
                    String name = ((PsiReferenceExpression)v).getQualifiedName();
                    return VersionChecks.codeNameToApi(name);
                }
                return VersionChecks.codeNameToApi(v.getText());
            }
        }
        return -1;
    }

    public static int getRequiredVersion(Issue issue, String errorMessage, TextFormat format) {
        Pattern pattern;
        Matcher matcher;
        errorMessage = format.toText(errorMessage);
        if ((issue == UNSUPPORTED || issue == INLINED) && (matcher = (pattern = Pattern.compile("\\s(\\d+)\\s")).matcher(errorMessage)).find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return -1;
    }

    protected void checkObsoleteSdkVersion(JavaContext context, PsiElement node) {
        int minSdk;
        Boolean isConditional;
        PsiBinaryExpression binary = (PsiBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PsiBinaryExpression.class, (boolean)true);
        if (binary != null && (isConditional = VersionChecks.isVersionCheckConditional(minSdk = this.getMinSdk(context), binary)) != null) {
            String message = isConditional != false ? "Unnecessary; SDK_INT is always >= " + minSdk : "Unnecessary; SDK_INT is never < " + minSdk;
            context.report(OBSOLETE_SDK, (PsiElement)binary, context.getLocation((PsiElement)binary), message);
        }
    }

    public static Boolean getVersionCheckConstant(String errorMessage, TextFormat format) {
        if ((errorMessage = format.toText(errorMessage)).contains("always")) {
            return true;
        }
        if (errorMessage.contains("never")) {
            return false;
        }
        return null;
    }

    private final class ApiVisitor
    extends JavaElementVisitor {
        private final JavaContext mContext;
        private final boolean willScanBytecode;
        private final boolean checkRequiresApi;

        private ApiVisitor(JavaContext context) {
            this.mContext = context;
            LintDriver driver = context.getDriver();
            boolean isInIde = !driver.getScope().contains((Object)Scope.CLASS_FILE);
            this.checkRequiresApi = !isInIde;
            this.willScanBytecode = driver.hasParserErrors() && !isInIde;
        }

        public void visitImportStaticStatement(PsiImportStaticStatement statement) {
            PsiElement resolved;
            if (!statement.isOnDemand() && (resolved = statement.resolve()) instanceof PsiField) {
                this.checkField((PsiElement)statement, (PsiField)resolved);
            }
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiElement parent = LintUtils.skipParentheses(expression.getParent());
            if (parent instanceof PsiReferenceExpression && !(LintUtils.skipParentheses(parent.getParent()) instanceof PsiCallExpression)) {
                return;
            }
            PsiElement resolved = expression.resolve();
            if (resolved instanceof PsiField) {
                this.checkField((PsiElement)expression, (PsiField)resolved);
            } else if (resolved instanceof PsiMethod && expression instanceof PsiMethodReferenceExpression) {
                this.checkMethodReference(expression, (PsiMethod)resolved);
            }
        }

        private void checkMethodReference(PsiReferenceExpression expression, PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            String owner = evaluator.getInternalName(containingClass);
            if (owner == null) {
                return;
            }
            if (!ApiDetector.this.mApiDatabase.containsClass(owner)) {
                return;
            }
            String name = LintUtils.getInternalMethodName(method);
            String desc = evaluator.getInternalDescription(method, false, false);
            if (desc == null) {
                return;
            }
            int api = ApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
            if (ApiDetector.isSuppressed(this.mContext, api, (PsiElement)expression, minSdk)) {
                return;
            }
            String signature = expression.getText();
            Location location = this.mContext.getLocation((PsiElement)expression);
            String message = String.format("Method reference requires API level %1$d (current min is %2$d): %3$s", api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)expression)), signature);
            this.mContext.report(UNSUPPORTED, (PsiElement)expression, location, message);
        }

        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            PsiTypeElement castTypeElement = expression.getCastType();
            PsiExpression operand = expression.getOperand();
            if (operand == null || castTypeElement == null) {
                return;
            }
            PsiType operandType = operand.getType();
            PsiType castType = castTypeElement.getType();
            if (castType.equals(operandType)) {
                return;
            }
            if (!(operandType instanceof PsiClassType)) {
                return;
            }
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)operandType;
            PsiClassType interfaceType = (PsiClassType)castType;
            this.checkCast((PsiElement)expression, classType, interfaceType);
        }

        private void checkCast(PsiElement node, PsiClassType classType, PsiClassType interfaceType) {
            if (classType.equals((Object)interfaceType)) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            String classTypeInternal = evaluator.getInternalName(classType);
            String interfaceTypeInternal = evaluator.getInternalName(interfaceType);
            if (interfaceTypeInternal == null || classTypeInternal == null) {
                return;
            }
            if ("java/lang/Object".equals(interfaceTypeInternal)) {
                return;
            }
            int api = ApiDetector.this.mApiDatabase.getValidCastVersion(classTypeInternal, interfaceTypeInternal);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
            if (api <= minSdk) {
                return;
            }
            if (ApiDetector.isSuppressed(this.mContext, api, node, minSdk)) {
                return;
            }
            Location location = this.mContext.getLocation(node);
            String message = String.format("Cast from %1$s to %2$s requires API level %3$d (current min is %4$d)", classType.getClassName(), interfaceType.getClassName(), api, Math.max(minSdk, ApiDetector.getTargetApi(node)));
            this.mContext.report(UNSUPPORTED, node, location, message);
        }

        public void visitMethod(PsiMethod method) {
            String fqcn;
            PsiClass cls;
            int minSdk;
            int api;
            if (method.getModifierList().hasExplicitModifier("default") && !ApiDetector.isSuppressed(this.mContext, api = 24, (PsiElement)method, minSdk = ApiDetector.this.getMinSdk(this.mContext))) {
                Location location = this.mContext.getLocation((PsiElement)method);
                String message = String.format("Default method requires API level %1$d (current min is %2$d)", api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)method)));
                this.mContext.report(UNSUPPORTED, (PsiElement)method, location, message);
            }
            if (this.willScanBytecode) {
                return;
            }
            int buildSdk = this.mContext.getMainProject().getBuildSdk();
            String name = method.getName();
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiMethod superMethod = evaluator.getSuperMethod(method);
            while (superMethod != null && (cls = superMethod.getContainingClass()) != null && (fqcn = cls.getQualifiedName()) != null && (fqcn.startsWith("android.") || fqcn.startsWith("java.") && !fqcn.equals("java.lang.Object") || fqcn.startsWith("javax."))) {
                String desc = evaluator.getInternalDescription(superMethod, false, false);
                if (desc != null) {
                    String owner = evaluator.getInternalName(cls);
                    if (owner == null) {
                        return;
                    }
                    int api2 = ApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc);
                    if (api2 > buildSdk && buildSdk != -1) {
                        if (this.mContext.getDriver().isSuppressed(this.mContext, OVERRIDE, (PsiElement)method)) {
                            return;
                        }
                        PsiClass containingClass = method.getContainingClass();
                        if (containingClass != null) {
                            String className = containingClass.getName();
                            String fullClassName = containingClass.getQualifiedName();
                            if (fullClassName != null) {
                                className = fullClassName;
                            }
                            fqcn = className + '#' + name;
                        } else {
                            fqcn = name;
                        }
                        String message = String.format("This method is not overriding anything with the current build target, but will in API level %1$d (current target is %2$d): %3$s", api2, buildSdk, fqcn);
                        PsiIdentifier locationNode = method.getNameIdentifier();
                        if (locationNode == null) {
                            locationNode = method;
                        }
                        Location location = this.mContext.getLocation((PsiElement)locationNode);
                        this.mContext.report(OVERRIDE, (PsiElement)method, location, message);
                    }
                }
                superMethod = evaluator.getSuperMethod(superMethod);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void visitClass(PsiClass aClass) {
            PsiReferenceList implementsList;
            PsiModifierList modifierList;
            if (aClass.isAnnotationType() && (modifierList = aClass.getModifierList()) != null) {
                for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                    PsiNameValuePair[] attributes;
                    String name = psiAnnotation.getQualifiedName();
                    if ("java.lang.annotation.Repeatable".equals(name)) {
                        int api = 24;
                        int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                        if (ApiDetector.isSuppressed(this.mContext, api, (PsiElement)aClass, minSdk)) continue;
                        Location location = this.mContext.getLocation((PsiElement)psiAnnotation);
                        String message = String.format("Repeatable annotation requires API level %1$d (current min is %2$d)", api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)aClass)));
                        this.mContext.report(UNSUPPORTED, (PsiElement)psiAnnotation, location, message);
                        continue;
                    }
                    if (!"java.lang.annotation.Target".equals(name)) continue;
                    for (PsiNameValuePair pair : attributes = psiAnnotation.getParameterList().getAttributes()) {
                        PsiAnnotationMemberValue value = pair.getValue();
                        if (value instanceof PsiArrayInitializerMemberValue) {
                            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value;
                            for (PsiAnnotationMemberValue t : array.getInitializers()) {
                                this.checkAnnotationTarget(t, modifierList);
                            }
                            continue;
                        }
                        if (value == null) continue;
                        this.checkAnnotationTarget(value, modifierList);
                    }
                }
            }
            if (this.willScanBytecode) {
                return;
            }
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null) {
                for (PsiAnnotation psiAnnotation : extendsList.getReferenceElements()) {
                    PsiElement resolved = psiAnnotation.resolve();
                    if (!(resolved instanceof PsiClass)) continue;
                    PsiClass cls = (PsiClass)resolved;
                    this.checkClass((PsiElement)psiAnnotation, cls, null);
                }
            }
            if ((implementsList = aClass.getImplementsList()) != null) {
                void var6_11;
                PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = implementsList.getReferenceElements();
                int n = psiJavaCodeReferenceElementArray.length;
                boolean bl = false;
                while (var6_11 < n) {
                    PsiJavaCodeReferenceElement element = psiJavaCodeReferenceElementArray[var6_11];
                    PsiElement resolved = element.resolve();
                    if (resolved instanceof PsiClass) {
                        PsiClass cls = (PsiClass)resolved;
                        this.checkClass((PsiElement)element, cls, null);
                    }
                    ++var6_11;
                }
            }
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
            if (this.willScanBytecode) {
                return;
            }
            PsiTypeElement element = expression.getOperand();
            PsiType type = element.getType();
            if (type instanceof PsiClassType) {
                this.checkClassType((PsiElement)element, (PsiClassType)type, null);
            }
        }

        private void checkClassType(PsiElement element, PsiClassType classType, String descriptor) {
            String owner = this.mContext.getEvaluator().getInternalName(classType);
            String fqcn = classType.getCanonicalText();
            if (owner != null && fqcn != null) {
                this.checkClass(element, descriptor, owner, fqcn);
            }
        }

        private void checkClass(PsiElement element, PsiClass cls, String descriptor) {
            String owner = this.mContext.getEvaluator().getInternalName(cls);
            if (owner == null) {
                return;
            }
            String fqcn = cls.getQualifiedName();
            if (fqcn != null) {
                this.checkClass(element, descriptor, owner, fqcn);
            }
        }

        private void checkClass(PsiElement element, String descriptor, String owner, String fqcn) {
            int api = ApiDetector.this.mApiDatabase.getClassVersion(owner);
            if (api == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
            if (ApiDetector.isSuppressed(this.mContext, api, element, minSdk)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class) != null) {
                return;
            }
            Location location = this.mContext.getNameLocation(element);
            minSdk = Math.max(minSdk, ApiDetector.getTargetApi(element));
            String message = String.format("%1$s requires API level %2$d (current min is %3$d): %4$s", descriptor == null ? "Class" : descriptor, api, Math.max(minSdk, ApiDetector.getTargetApi(element)), fqcn);
            this.mContext.report(UNSUPPORTED, element, location, message);
        }

        private void checkAnnotationTarget(PsiAnnotationMemberValue element, PsiModifierList modifierList) {
            PsiAnnotation retention;
            PsiReferenceExpression ref;
            if (element instanceof PsiReferenceExpression && ("TYPE_PARAMETER".equals((ref = (PsiReferenceExpression)element).getReferenceName()) || "TYPE_USE".equals(ref.getReferenceName())) && ((retention = modifierList.findAnnotation("java.lang.annotation.Retention")) == null || retention.getText().contains("RUNTIME"))) {
                Location location = this.mContext.getLocation((PsiElement)element);
                String message = String.format("Type annotations are not supported in Android: %1$s", ref.getReferenceName());
                this.mContext.report(UNSUPPORTED, (PsiElement)element, location, message);
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement) {
            if (this.willScanBytecode) {
                return;
            }
            PsiExpression value = statement.getIteratedValue();
            if (value == null) {
                return;
            }
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiType type = value.getType();
            if (type instanceof PsiClassType) {
                PsiMethod keySet;
                PsiMethodCallExpression valueCall;
                String expressionOwner = evaluator.getInternalName((PsiClassType)type);
                if (expressionOwner == null) {
                    return;
                }
                int api = ApiDetector.this.mApiDatabase.getClassVersion(expressionOwner);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                if (ApiDetector.isSuppressed(this.mContext, api, (PsiElement)statement, minSdk)) {
                    return;
                }
                Location location = this.mContext.getLocation((PsiElement)value);
                String message = String.format("The type of the for loop iterated value is %1$s, which requires API level %2$d (current min is %3$d)", type.getCanonicalText(), api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)statement)));
                if (value instanceof PsiMethodCallExpression && "keySet".equals((valueCall = (PsiMethodCallExpression)value).getMethodExpression().getReferenceName()) && (keySet = valueCall.resolveMethod()) != null && keySet.getContainingClass() != null && "java.util.concurrent.ConcurrentHashMap".equals(keySet.getContainingClass().getQualifiedName())) {
                    message = message + "; to work around this, add an explicit cast to (Map) before the `keySet` call.";
                }
                this.mContext.report(UNSUPPORTED, (PsiElement)statement, location, message);
            }
        }

        public void visitCallExpression(PsiCallExpression expression) {
            PsiMethod containingMethod;
            PsiMethodCallExpression call;
            PsiReferenceExpression methodExpression;
            int api;
            JavaEvaluator evaluator;
            String owner;
            PsiModifierList modifierList;
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (this.checkRequiresApi && !this.checkRequiresApi(expression, method, modifierList = method.getModifierList()) && (modifierList = containingClass.getModifierList()) != null) {
                this.checkRequiresApi(expression, method, modifierList);
            }
            if (this.willScanBytecode) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() > 0) {
                PsiParameter[] parameters = parameterList.getParameters();
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList != null) {
                    PsiExpression[] arguments = argumentList.getExpressions();
                    for (int i = 0; i < parameters.length; ++i) {
                        PsiType parameterType = parameters[i].getType();
                        if (!(parameterType instanceof PsiClassType)) continue;
                        if (i >= arguments.length) break;
                        PsiExpression argument = arguments[i];
                        PsiType argumentType = argument.getType();
                        if (argumentType == null || parameterType.equals(argumentType) || !(argumentType instanceof PsiClassType)) continue;
                        this.checkCast((PsiElement)argument, (PsiClassType)argumentType, (PsiClassType)parameterType);
                    }
                }
            }
            if ((owner = (evaluator = this.mContext.getEvaluator()).getInternalName(containingClass)) == null) {
                return;
            }
            if (!ApiDetector.this.mApiDatabase.containsClass(owner)) {
                return;
            }
            String name = LintUtils.getInternalMethodName(method);
            String desc = evaluator.getInternalDescription(method, false, false);
            if (desc == null) {
                return;
            }
            if (owner.equals("java/text/SimpleDateFormat") && name.equals("<init>") && !desc.equals("()V")) {
                ApiDetector.checkSimpleDateFormat(this.mContext, expression, ApiDetector.this.getMinSdk(this.mContext));
            }
            if ((api = ApiDetector.this.mApiDatabase.getCallVersion(owner, name, desc)) == -1) {
                return;
            }
            int minSdk = ApiDetector.this.getMinSdk(this.mContext);
            if (api <= minSdk) {
                return;
            }
            String fqcn = containingClass.getQualifiedName();
            if (expression instanceof PsiMethodCallExpression) {
                PsiExpression qualifier = ((PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression();
                if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
                    String expressionOwner;
                    PsiType type = qualifier.getType();
                    if (type instanceof PsiClassType && (expressionOwner = evaluator.getInternalName((PsiClassType)type)) != null && !expressionOwner.equals(owner)) {
                        int specificApi = ApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                        if (specificApi == -1) {
                            if (ApiLookup.isRelevantOwner(expressionOwner)) {
                                return;
                            }
                        } else {
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = type.getCanonicalText();
                            }
                            api = Math.min(specificApi, api);
                        }
                    }
                } else {
                    PsiElement resolved;
                    PsiQualifiedExpression pte;
                    PsiJavaCodeReferenceElement operand;
                    PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                    if ((qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) && (operand = (pte = (PsiQualifiedExpression)qualifier).getQualifier()) != null && (resolved = operand.resolve()) instanceof PsiClass) {
                        cls = (PsiClass)resolved;
                    }
                    while (cls != null) {
                        String expressionOwner;
                        if (cls instanceof PsiAnonymousClass) {
                            boolean found = false;
                            PsiClassType anonymousBaseType = ((PsiAnonymousClass)cls).getBaseClassType();
                            PsiClass anonymousBase = anonymousBaseType.resolve();
                            if (anonymousBase != null && anonymousBase.isInheritor(containingClass, true)) {
                                cls = anonymousBase;
                                found = true;
                            } else {
                                PsiClass surroundingBaseType = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class, (boolean)true);
                                if (surroundingBaseType != null && surroundingBaseType.isInheritor(containingClass, true)) {
                                    cls = surroundingBaseType;
                                    found = true;
                                }
                            }
                            if (!found) break;
                        }
                        if ((expressionOwner = evaluator.getInternalName(cls)) == null || "java/lang/Object".equals(expressionOwner)) break;
                        int specificApi = ApiDetector.this.mApiDatabase.getCallVersion(expressionOwner, name, desc);
                        if (specificApi != -1) {
                            if (specificApi <= minSdk) {
                                return;
                            }
                            if (specificApi < api) {
                                api = specificApi;
                                fqcn = cls.getQualifiedName();
                            }
                            api = Math.min(specificApi, api);
                            break;
                        }
                        if (ApiLookup.isRelevantOwner(expressionOwner)) {
                            return;
                        }
                        cls = cls.getSuperClass();
                    }
                }
            }
            if (ApiDetector.isSuppressed(this.mContext, api, (PsiElement)expression, minSdk)) {
                return;
            }
            if (expression instanceof PsiMethodCallExpression && (methodExpression = (call = (PsiMethodCallExpression)expression).getMethodExpression()).getQualifierExpression() instanceof PsiSuperExpression && (containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class, (boolean)true)) != null && name.equals(containingMethod.getName()) && evaluator.areSignaturesEqual(method, containingMethod) && !method.isConstructor()) {
                return;
            }
            String signature = "<init>".equals(name) ? "new " + fqcn : fqcn + '#' + name;
            PsiElement nameIdentifier = LintUtils.getCallName(expression);
            Location location = nameIdentifier != null ? (method.isConstructor() ? this.mContext.getRangeLocation((PsiElement)expression, 0, nameIdentifier, 0) : this.mContext.getLocation(nameIdentifier)) : this.mContext.getLocation((PsiElement)expression);
            String message = String.format("Call requires API level %1$d (current min is %2$d): %3$s", api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)expression)), signature);
            this.mContext.report(UNSUPPORTED, (PsiElement)expression, location, message);
        }

        private boolean checkRequiresApi(PsiCallExpression expression, PsiMethod method, PsiModifierList modifierList) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                int target;
                int minSdk;
                if (!ApiDetector.REQUIRES_API_ANNOTATION.equals(annotation.getQualifiedName())) continue;
                int api = (int)SupportAnnotationDetector.getLongAttribute(annotation, "value", -1L);
                if (api <= 1) {
                    api = (int)SupportAnnotationDetector.getLongAttribute(annotation, "api", -1L);
                }
                if (api > (minSdk = ApiDetector.this.getMinSdk(this.mContext)) && ((target = ApiDetector.getTargetApi((PsiElement)expression)) == -1 || api > target)) {
                    if (VersionChecks.isWithinVersionCheckConditional((PsiElement)expression, api)) {
                        return true;
                    }
                    if (VersionChecks.isPrecededByVersionCheckExit((PsiElement)expression, api)) {
                        return true;
                    }
                    Location location = this.mContext.getNameLocation((PsiElement)expression);
                    String fqcn = method.getName();
                    String message = String.format("Call requires API level %1$d (current min is %2$d): `%3$s`", api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)expression)), fqcn);
                    this.mContext.report(UNSUPPORTED, (PsiElement)expression, location, message);
                }
                return true;
            }
            return false;
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            PsiType initializerType = initializer.getType();
            if (!(initializerType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = variable.getType();
            if (initializerType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast((PsiElement)initializer, (PsiClassType)initializerType, (PsiClassType)interfaceType);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            PsiExpression rExpression = expression.getRExpression();
            if (rExpression == null) {
                return;
            }
            PsiType rhsType = rExpression.getType();
            if (!(rhsType instanceof PsiClassType)) {
                return;
            }
            PsiType interfaceType = expression.getLExpression().getType();
            if (rhsType.equals(interfaceType)) {
                return;
            }
            if (!(interfaceType instanceof PsiClassType)) {
                return;
            }
            this.checkCast((PsiElement)rExpression, (PsiClassType)rhsType, (PsiClassType)interfaceType);
        }

        public void visitTryStatement(PsiTryStatement statement) {
            int minSdk;
            int api;
            PsiResourceList resourceList = statement.getResourceList();
            if (resourceList != null && (api = 19) > (minSdk = ApiDetector.this.getMinSdk(this.mContext)) && api > ApiDetector.getTargetApi((PsiElement)statement)) {
                Location location = this.mContext.getLocation((PsiElement)resourceList);
                String message = String.format("Try-with-resources requires API level %1$d (current min is %2$d)", api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)statement)));
                this.mContext.report(UNSUPPORTED, (PsiElement)statement, location, message);
            }
            if (this.willScanBytecode) {
                return;
            }
            for (PsiParameter parameter : statement.getCatchBlockParameters()) {
                PsiTypeElement typeElement = parameter.getTypeElement();
                if (typeElement == null) continue;
                this.checkCatchTypeElement(statement, typeElement, typeElement.getType());
            }
        }

        public void visitSwitchStatement(PsiSwitchStatement statement) {
            PsiType type;
            if (this.willScanBytecode) {
                return;
            }
            PsiExpression expression = statement.getExpression();
            if (expression != null && (type = expression.getType()) instanceof PsiClassType) {
                this.checkClassType((PsiElement)expression, (PsiClassType)type, "Enum for switch");
            }
        }

        private void checkCatchTypeElement(PsiTryStatement statement, PsiTypeElement typeElement, PsiType type) {
            PsiClass resolved = null;
            if (type instanceof PsiDisjunctionType) {
                PsiDisjunctionType disjunctionType = (PsiDisjunctionType)type;
                if ((type = disjunctionType.getLeastUpperBound()) instanceof PsiClassType) {
                    resolved = ((PsiClassType)type).resolve();
                }
                for (PsiElement child : typeElement.getChildren()) {
                    PsiTypeElement childTypeElement;
                    PsiType childType;
                    if (child instanceof PsiParenthesizedExpression) {
                        child = ((PsiParenthesizedExpression)child).getExpression();
                    }
                    if (!(child instanceof PsiTypeElement) || type.equals(childType = (childTypeElement = (PsiTypeElement)child).getType())) continue;
                    this.checkCatchTypeElement(statement, childTypeElement, childType);
                }
            } else if (type instanceof PsiClassType) {
                resolved = ((PsiClassType)type).resolve();
            }
            if (resolved != null) {
                String signature = this.mContext.getEvaluator().getInternalName(resolved);
                if (signature == null) {
                    return;
                }
                int api = ApiDetector.this.mApiDatabase.getClassVersion(signature);
                if (api == -1) {
                    return;
                }
                int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                if (ApiDetector.isSuppressed(this.mContext, api, (PsiElement)statement, minSdk)) {
                    return;
                }
                Location location = this.mContext.getLocation((PsiElement)typeElement);
                String fqcn = resolved.getQualifiedName();
                String message = String.format("Class requires API level %1$d (current min is %2$d): %3$s", api, Math.max(minSdk, ApiDetector.getTargetApi((PsiElement)statement)), fqcn);
                if (api == 19 && "java.lang.ReflectiveOperationException".equals(fqcn)) {
                    message = String.format("Multi-catch with these reflection exceptions requires API level 19 (current min is %2$d) because they get compiled to the common but new super type `ReflectiveOperationException`. As a workaround either create individual catch statements, or catch `Exception`.", api, minSdk);
                }
                this.mContext.report(UNSUPPORTED, (PsiElement)statement, location, message);
            }
        }

        private boolean checkField(PsiElement node, PsiField field) {
            PsiClass containingClass;
            PsiType type = field.getType();
            String name = field.getName();
            if ("SDK_INT".equals(name)) {
                ApiDetector.this.checkObsoleteSdkVersion(this.mContext, node);
            }
            if ((containingClass = field.getContainingClass()) == null || name == null) {
                return false;
            }
            String owner = this.mContext.getEvaluator().getInternalName(containingClass);
            if (owner == null) {
                return false;
            }
            int api = ApiDetector.this.mApiDatabase.getFieldVersion(owner, name);
            if (api != -1) {
                int minSdk = ApiDetector.this.getMinSdk(this.mContext);
                if (api > minSdk && api > ApiDetector.getTargetApi(node)) {
                    PsiJavaCodeReferenceElement reference;
                    Issue issue = INLINED;
                    if (!(type instanceof PsiPrimitiveType) && !LintUtils.isString(type)) {
                        PsiExpression condition;
                        issue = UNSUPPORTED;
                        if (this.willScanBytecode) {
                            return true;
                        }
                        PsiElement parent = LintUtils.skipParentheses(node.getParent());
                        if (parent instanceof PsiSwitchLabelStatement && node == (condition = ((PsiSwitchLabelStatement)parent).getCaseValue())) {
                            return true;
                        }
                    } else if (ApiDetector.isBenignConstantUsage(node, name, owner)) {
                        return true;
                    }
                    String fqcn = ClassContext.getFqcn(owner) + '#' + name;
                    if (node instanceof PsiImportStatementBase && (reference = ((PsiImportStatementBase)node).getImportReference()) != null) {
                        node = reference;
                    }
                    if (ApiDetector.isSuppressed(this.mContext, api, node, minSdk)) {
                        return true;
                    }
                    String message = String.format("Field requires API level %1$d (current min is %2$d): `%3$s`", api, Math.max(minSdk, ApiDetector.getTargetApi(node)), fqcn);
                    Location location = this.mContext.getLocation(node);
                    this.mContext.report(issue, node, location, message);
                }
                return true;
            }
            return false;
        }
    }
}

