/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AllowAllHostnameVerifierDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AllowAllHostnameVerifierDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("AllowAllHostnameVerifier", "Insecure HostnameVerifier", "This check looks for use of HostnameVerifier implementations whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    public List<String> getApplicableConstructorTypes() {
        return Collections.singletonList("org.apache.http.conn.ssl.AllowAllHostnameVerifier");
    }

    @Override
    public void visitConstructor(JavaContext context, JavaElementVisitor visitor, PsiNewExpression node, PsiMethod constructor) {
        Location location = context.getLocation((PsiElement)node);
        context.report(ISSUE, (PsiElement)node, location, "Using the AllowAllHostnameVerifier HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames");
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("setHostnameVerifier", "setDefaultHostnameVerifier");
    }

    @Override
    public void visitMethod(JavaContext context, JavaElementVisitor visitor, PsiMethodCallExpression node, PsiMethod method) {
        PsiField field;
        PsiExpression argument;
        PsiElement resolvedArgument;
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.methodMatches(method, null, false, "javax.net.ssl.HostnameVerifier") && (resolvedArgument = evaluator.resolve((PsiElement)(argument = node.getArgumentList().getExpressions()[0]))) instanceof PsiField && "ALLOW_ALL_HOSTNAME_VERIFIER".equals((field = (PsiField)resolvedArgument).getName())) {
            Location location = context.getLocation((PsiElement)argument);
            String message = "Using the ALLOW_ALL_HOSTNAME_VERIFIER HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames";
            context.report(ISSUE, (PsiElement)argument, location, message);
        }
    }
}

