/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.res2.AbstractResourceRepository;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;

public class AllCapsDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("AllCaps", "Combining textAllCaps and markup", "The textAllCaps text transform will end up calling `toString` on the `CharSequence`, which has the net effect of removing any markup such as `<b>`. This check looks for usages of strings containing markup that also specify `textAllCaps=true`.", Category.TYPOGRAPHY, 8, Severity.WARNING, new Implementation(AllCapsDetector.class, Scope.ALL_RESOURCES_SCOPE, Scope.RESOURCE_FILE_SCOPE));

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("textAllCaps");
    }

    @Override
    public void visitAttribute(XmlContext context, Attr attribute) {
        Project project;
        if (!"http://schemas.android.com/apk/res/android".equals(attribute.getNamespaceURI())) {
            return;
        }
        if (!"true".equals(attribute.getValue())) {
            return;
        }
        String text = attribute.getOwnerElement().getAttributeNS("http://schemas.android.com/apk/res/android", "text");
        if (text.isEmpty()) {
            return;
        }
        ResourceUrl url = ResourceUrl.parse((String)text);
        if (url == null || url.framework) {
            return;
        }
        LintClient client = context.getClient();
        AbstractResourceRepository repository = client.getResourceRepository(project = context.getMainProject(), true, true);
        if (repository == null) {
            return;
        }
        List items = repository.getResourceItem(url.type, url.name);
        if (items == null || items.isEmpty()) {
            return;
        }
        ResourceValue resourceValue = ((ResourceItem)items.get(0)).getResourceValue(false);
        if (resourceValue == null) {
            return;
        }
        String rawXmlValue = resourceValue.getRawXmlValue();
        if (rawXmlValue.contains("<")) {
            String message = String.format("Using `textAllCaps` with a string (`%1$s`) that contains markup; the markup will be dropped by the caps conversion", url.name);
            context.report(ISSUE, attribute, context.getLocation(attribute), message);
        }
    }
}

