/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.ServiceLoader;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.tooling.ErrorMessageBuilder;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;
import org.jetbrains.plugins.gradle.tooling.annotation.TargetVersions;
import org.jetbrains.plugins.gradle.tooling.util.VersionMatcher;

public class ExtraModelBuilder
implements ToolingModelBuilder {
    private final List<ModelBuilderService> modelBuilderServices;
    @NotNull
    private final GradleVersion myCurrentGradleVersion;

    public ExtraModelBuilder() {
        this(GradleVersion.current());
    }

    public ExtraModelBuilder(@NotNull GradleVersion gradleVersion) {
        if (gradleVersion == null) {
            ExtraModelBuilder.$$$reportNull$$$0(0);
        }
        this.myCurrentGradleVersion = gradleVersion;
        this.modelBuilderServices = Lists.newArrayList(ServiceLoader.load(ModelBuilderService.class, ExtraModelBuilder.class.getClassLoader()));
    }

    public boolean canBuild(String modelName) {
        for (ModelBuilderService service : this.modelBuilderServices) {
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object buildAll(String modelName, Project project) {
        for (ModelBuilderService service : this.modelBuilderServices) {
            Object object;
            if (!service.canBuild(modelName) || !this.isVersionMatch(service)) continue;
            long startTime = System.currentTimeMillis();
            try {
                object = service.buildAll(modelName, project);
            }
            catch (Exception e) {
                try {
                    ErrorMessageBuilder builderError = service.getErrorMessageBuilder(project, e);
                    project.getLogger().error(builderError.build());
                }
                catch (Throwable throwable) {
                    if (!Boolean.getBoolean("idea.gradle.custom.tooling.perf")) throw throwable;
                    long timeInMs = System.currentTimeMillis() - startTime;
                    project.getLogger().error(ErrorMessageBuilder.create((Project)project, null, (String)"Performance statistics").withDescription(String.format("service %s imported data in %d ms", service.getClass().getSimpleName(), timeInMs)).build());
                    throw throwable;
                }
                if (!Boolean.getBoolean("idea.gradle.custom.tooling.perf")) return null;
                long timeInMs = System.currentTimeMillis() - startTime;
                project.getLogger().error(ErrorMessageBuilder.create((Project)project, null, (String)"Performance statistics").withDescription(String.format("service %s imported data in %d ms", service.getClass().getSimpleName(), timeInMs)).build());
                return null;
            }
            if (!Boolean.getBoolean("idea.gradle.custom.tooling.perf")) return object;
            long timeInMs = System.currentTimeMillis() - startTime;
            project.getLogger().error(ErrorMessageBuilder.create((Project)project, null, (String)"Performance statistics").withDescription(String.format("service %s imported data in %d ms", service.getClass().getSimpleName(), timeInMs)).build());
            return object;
        }
        throw new IllegalArgumentException("Unsupported model: " + modelName);
    }

    private boolean isVersionMatch(@NotNull ModelBuilderService builderService) {
        if (builderService == null) {
            ExtraModelBuilder.$$$reportNull$$$0(1);
        }
        TargetVersions targetVersions = builderService.getClass().getAnnotation(TargetVersions.class);
        return new VersionMatcher(this.myCurrentGradleVersion).isVersionMatch(targetVersions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builderService";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/internal/ExtraModelBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isVersionMatch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

