/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.server.management.remote;

import com.springsource.server.management.remote.Bundle;
import com.springsource.server.management.remote.BundleAdmin;
import com.springsource.server.management.remote.PackageExport;
import com.springsource.server.management.remote.PackageImport;
import com.springsource.server.management.remote.ServerCommandInterpreter;
import com.springsource.server.management.remote.ServiceReference;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.osgi.util.OsgiServiceReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedResource(objectName="com.springsource.server:type=BundleAdmin", description="SpringSource Tool Suite Connector Bean")
public class StandardBundleAdmin
implements BundleAdmin {
    private final PlatformAdmin platformAdmin;
    private final PackageAdmin packageAdmin;
    private final BundleContext bundleContext;
    private ServiceTracker consoleProviderTracker;

    public StandardBundleAdmin(PlatformAdmin platformAdmin, PackageAdmin packageAdmin, BundleContext bundleContext) {
        this.platformAdmin = platformAdmin;
        this.packageAdmin = packageAdmin;
        this.bundleContext = bundleContext;
        this.consoleProviderTracker = new ServiceTracker(bundleContext, CommandProvider.class.getName(), null);
        this.consoleProviderTracker.open();
    }

    @ManagedOperation(description="Stop the given bundle")
    public void stop(long bundleId) {
        this.execute("stop " + bundleId);
    }

    @ManagedOperation(description="Start the given bundle")
    public void start(long bundleId) {
        this.execute("start " + bundleId);
    }

    @ManagedOperation(description="Refresh the given bundle")
    public void refresh(long bundleId) {
        this.execute("refresh " + bundleId);
    }

    @ManagedOperation(description="Refresh the given bundle")
    public void update(long bundleId) {
        this.execute("update " + bundleId);
    }

    @Override
    @ManagedOperation(description="Executes the given command")
    public String execute(String cmdLine) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        try {
            ServerCommandInterpreter interpreter = new ServerCommandInterpreter(cmdLine, this.getServices(), printWriter);
            interpreter.execute(interpreter.nextArgument());
            try {
                writer.close();
                printWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string = writer.toString();
            return string;
        }
        finally {
            try {
                writer.close();
                printWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    @ManagedOperation(description="Returns the current OSGi Bundles")
    public Map<Long, Bundle> retrieveBundles() {
        HashMap<Long, Bundle> bundles = new HashMap<Long, Bundle>();
        org.osgi.framework.Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            org.osgi.framework.Bundle usingBundle;
            org.osgi.framework.Bundle[] bundleArray2;
            Map props;
            ServiceReference reference;
            ExportPackageDescription[] exportPackageDescriptionArray;
            ExportPackageDescription[] visiblePackages;
            int n3;
            org.osgi.framework.Bundle b = bundleArray[n2];
            Object version = b.getHeaders().get("Bundle-Version");
            Bundle bundle = new Bundle(Long.toString(b.getBundleId()), b.getSymbolicName(), version != null ? version.toString() : "0", this.getState(b), b.getLocation());
            Dictionary headers = b.getHeaders();
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = headers.get(key);
                bundle.addHeader(key.toString(), value.toString());
            }
            BundleDescription bundleDescription = this.platformAdmin.getState(false).getBundle(b.getBundleId());
            ExportPackageDescription[] exportedPackages = bundleDescription.getExportPackages();
            if (exportedPackages != null) {
                ExportPackageDescription[] exportPackageDescriptionArray2 = exportedPackages;
                n3 = exportedPackages.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportedPackage = exportPackageDescriptionArray2[n4];
                    PackageExport packageExport = new PackageExport(exportedPackage.getName(), exportedPackage.getVersion() != null ? exportedPackage.getVersion().toString() : "0");
                    bundle.addPackageExport(packageExport);
                    ++n4;
                }
            }
            if ((visiblePackages = this.platformAdmin.getStateHelper().getVisiblePackages(bundleDescription)) != null) {
                exportPackageDescriptionArray = visiblePackages;
                int n5 = visiblePackages.length;
                n3 = 0;
                while (n3 < n5) {
                    ExportPackageDescription visiblePackage = exportPackageDescriptionArray[n3];
                    PackageImport packageImport = new PackageImport(visiblePackage.getName(), visiblePackage.getVersion() != null ? visiblePackage.getVersion().toString() : "0", Long.toString(visiblePackage.getSupplier().getBundleId()));
                    bundle.addPackageImport(packageImport);
                    ++n3;
                }
            }
            if (b.getRegisteredServices() != null) {
                exportPackageDescriptionArray = b.getRegisteredServices();
                int n6 = exportPackageDescriptionArray.length;
                n3 = 0;
                while (n3 < n6) {
                    ExportPackageDescription ref = exportPackageDescriptionArray[n3];
                    reference = new ServiceReference(ServiceReference.Type.REGISTERED, ref.getBundle().getBundleId(), OsgiServiceReferenceUtils.getServiceObjectClasses((org.osgi.framework.ServiceReference)ref));
                    props = OsgiServiceReferenceUtils.getServicePropertiesAsMap((org.osgi.framework.ServiceReference)ref);
                    for (Object key : props.keySet()) {
                        String value = props.get(key).toString();
                        if (props.get(key).getClass().isArray()) {
                            value = Arrays.deepToString((Object[])props.get(key));
                        }
                        reference.addProperty(key.toString(), value);
                    }
                    if (ref.getUsingBundles() != null) {
                        bundleArray2 = ref.getUsingBundles();
                        int value = bundleArray2.length;
                        int n7 = 0;
                        while (n7 < value) {
                            usingBundle = bundleArray2[n7];
                            reference.addUsingBundle(usingBundle.getBundleId());
                            ++n7;
                        }
                    }
                    bundle.addRegisteredService(reference);
                    ++n3;
                }
            }
            if (b.getServicesInUse() != null) {
                exportPackageDescriptionArray = b.getServicesInUse();
                int n8 = exportPackageDescriptionArray.length;
                n3 = 0;
                while (n3 < n8) {
                    ExportPackageDescription ref = exportPackageDescriptionArray[n3];
                    reference = new ServiceReference(ServiceReference.Type.IN_USE, ref.getBundle().getBundleId(), OsgiServiceReferenceUtils.getServiceObjectClasses((org.osgi.framework.ServiceReference)ref));
                    props = OsgiServiceReferenceUtils.getServicePropertiesAsMap((org.osgi.framework.ServiceReference)ref);
                    for (Object key : props.keySet()) {
                        String value = props.get(key).toString();
                        if (props.get(key).getClass().isArray()) {
                            value = Arrays.deepToString((Object[])props.get(key));
                        }
                        reference.addProperty(key.toString(), value);
                    }
                    if (ref.getUsingBundles() != null) {
                        bundleArray2 = ref.getUsingBundles();
                        int n9 = bundleArray2.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            usingBundle = bundleArray2[n10];
                            reference.addUsingBundle(usingBundle.getBundleId());
                            ++n10;
                        }
                    }
                    bundle.addUsingService(reference);
                    ++n3;
                }
            }
            bundles.put(Long.valueOf(bundle.getId()), bundle);
            ++n2;
        }
        return bundles;
    }

    private Object[] getServices() {
        Object[] serviceRefs = this.consoleProviderTracker.getServiceReferences();
        if (serviceRefs == null) {
            return new Object[0];
        }
        Util.dsort((Object[])serviceRefs, (int)0, (int)serviceRefs.length);
        Object[] serviceObjects = new Object[serviceRefs.length];
        int i = 0;
        while (i < serviceRefs.length) {
            serviceObjects[i] = this.bundleContext.getService((org.osgi.framework.ServiceReference)serviceRefs[i]);
            ++i;
        }
        return serviceObjects;
    }

    private String getState(org.osgi.framework.Bundle b) {
        switch (b.getState()) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "UNKNOWN";
    }
}

