/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueNameGenerator
implements Condition<String> {
    private final Set<String> myExistingNames;

    public <T> UniqueNameGenerator(@NotNull Collection<T> elements, @Nullable Function<T, String> namer) {
        if (elements == null) {
            UniqueNameGenerator.$$$reportNull$$$0(0);
        }
        this.myExistingNames = new THashSet();
        for (T t : elements) {
            this.addExistingName(namer != null ? StringUtil.notNullize(namer.fun(t)) : t.toString());
        }
    }

    public UniqueNameGenerator() {
        this.myExistingNames = new THashSet();
    }

    @Override
    public final boolean value(String candidate) {
        return this.isUnique(candidate);
    }

    public final boolean isUnique(@NotNull String candidate) {
        if (candidate == null) {
            UniqueNameGenerator.$$$reportNull$$$0(1);
        }
        return !this.myExistingNames.contains(candidate);
    }

    public final boolean isUnique(String name, String prefix, String suffix) {
        return this.value(prefix + name + suffix);
    }

    @NotNull
    public static String generateUniqueName(String defaultName, Collection<String> existingNames) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, "", "", existingNames);
        if (string == null) {
            UniqueNameGenerator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, final Collection<String> existingNames) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, new Condition<String>(){

            @Override
            public boolean value(String s) {
                return !existingNames.contains(s);
            }
        });
        if (string == null) {
            UniqueNameGenerator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, Condition<String> validator) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, "", "", validator);
        if (string == null) {
            UniqueNameGenerator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, Condition<String> validator) {
        String string = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, "", "", validator);
        if (string == null) {
            UniqueNameGenerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber, Condition<String> validator) {
        String defaultFullName = prefix + defaultName + suffix;
        if (validator.value(defaultFullName)) {
            String string = defaultFullName;
            if (string == null) {
                UniqueNameGenerator.$$$reportNull$$$0(6);
            }
            return string;
        }
        int i = 2;
        while (true) {
            String fullName;
            if (validator.value(fullName = prefix + defaultName + beforeNumber + i + afterNumber + suffix)) {
                String string = fullName;
                if (string == null) {
                    UniqueNameGenerator.$$$reportNull$$$0(7);
                }
                return string;
            }
            ++i;
        }
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix) {
        String string = this.generateUniqueName(defaultName, prefix, suffix, "", "");
        if (string == null) {
            UniqueNameGenerator.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber) {
        String result = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, beforeNumber, afterNumber, this);
        this.addExistingName(result);
        String string = result;
        if (string == null) {
            UniqueNameGenerator.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void addExistingName(@NotNull String result) {
        if (result == null) {
            UniqueNameGenerator.$$$reportNull$$$0(10);
        }
        this.myExistingNames.add(result);
    }

    public String generateUniqueName(String defaultName) {
        return this.generateUniqueName(defaultName, "", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/UniqueNameGenerator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/UniqueNameGenerator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isUnique";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addExistingName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

