/*
 * Decompiled with CFR 0.152.
 */
package javafx.embed.swing;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.embed.swing.Disposer;
import com.sun.javafx.embed.swing.DisposerRecord;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGExternalNode;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.WindowHelper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.embed.swing.FXDnD;
import javafx.embed.swing.SwingCursors;
import javafx.embed.swing.SwingEvents;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.ScrollEvent;
import javafx.scene.text.Font;
import javafx.stage.Window;
import javax.swing.JComponent;
import sun.awt.UngrabEvent;
import sun.swing.JLightweightFrame;
import sun.swing.LightweightContent;

public class SwingNode
extends Node {
    private double fxWidth;
    private double fxHeight;
    private int swingPrefWidth;
    private int swingPrefHeight;
    private int swingMaxWidth;
    private int swingMaxHeight;
    private int swingMinWidth;
    private int swingMinHeight;
    private volatile JComponent content;
    private volatile JLightweightFrame lwFrame;
    private NGExternalNode peer;
    private final ReentrantLock paintLock = new ReentrantLock();
    private boolean skipBackwardUnrgabNotification;
    private boolean grabbed;
    private volatile int scale = 1;
    private static final OptionalMethod<JLightweightFrame> jlfNotifyDisplayChanged = new OptionalMethod<JLightweightFrame>(JLightweightFrame.class, "notifyDisplayChanged", Integer.TYPE);
    private List<Runnable> peerRequests = new ArrayList<Runnable>();
    private final InvalidationListener locationListener = observable -> this.locateLwFrame();
    private final EventHandler<FocusUngrabEvent> ungrabHandler = event -> {
        if (!this.skipBackwardUnrgabNotification && this.lwFrame != null) {
            AccessController.doPrivileged(new PostEventAction(new UngrabEvent(this.lwFrame)));
        }
    };
    private final ChangeListener<Boolean> windowVisibleListener = (observable, oldValue, newValue) -> {
        if (!newValue.booleanValue()) {
            this.disposeLwFrame();
        } else {
            this.setContent(this.content);
        }
    };
    private final ChangeListener<Window> sceneWindowListener = (observable, oldValue, newValue) -> {
        if (oldValue != null) {
            this.removeWindowListeners((Window)oldValue);
        }
        if (newValue != null) {
            this.addWindowListeners((Window)newValue);
        }
    };
    private static final OptionalMethod<JLightweightFrame> jlfSetHostBounds = new OptionalMethod<JLightweightFrame>(JLightweightFrame.class, "setHostBounds", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);

    final JLightweightFrame getLightweightFrame() {
        return this.lwFrame;
    }

    public SwingNode() {
        this.setFocusTraversable(true);
        this.setEventHandler(javafx.scene.input.MouseEvent.ANY, new SwingMouseEventHandler());
        this.setEventHandler(KeyEvent.ANY, new SwingKeyEventHandler());
        this.setEventHandler(ScrollEvent.SCROLL, new SwingScrollEventHandler());
        this.focusedProperty().addListener((observable, oldValue, newValue) -> this.activateLwFrame((boolean)newValue));
        Font.getFamilies();
    }

    public void setContent(JComponent content) {
        this.content = content;
        SwingFXUtils.runOnEDT(() -> this.setContentImpl(content));
    }

    public JComponent getContent() {
        return this.content;
    }

    private void setContentImpl(JComponent content) {
        if (this.lwFrame != null) {
            this.lwFrame.dispose();
            this.lwFrame = null;
        }
        if (content != null) {
            this.lwFrame = new JLightweightFrame();
            SwingNodeWindowFocusListener snfListener = new SwingNodeWindowFocusListener(this);
            this.lwFrame.addWindowFocusListener(snfListener);
            jlfNotifyDisplayChanged.invoke(this.lwFrame, this.scale);
            this.lwFrame.setContent(new SwingNodeContent(content, this));
            this.lwFrame.setVisible(true);
            SwingNodeDisposer disposeRec = new SwingNodeDisposer(this.lwFrame);
            Disposer.addRecord(this, disposeRec);
            SwingFXUtils.runOnFxThread(() -> {
                this.locateLwFrame();
                if (this.focusedProperty().get()) {
                    this.activateLwFrame(true);
                }
            });
        }
    }

    void setImageBuffer(int[] data, int x, int y, int w, int h, int linestride, int scale) {
        Runnable r = () -> {
            Window win = this.getScene().getWindow();
            float uiScale = WindowHelper.getWindowAccessor().getUIScale(win);
            this.peer.setImageBuffer(IntBuffer.wrap(data), x, y, w, h, (float)w / uiScale, (float)h / uiScale, linestride, scale);
        };
        SwingFXUtils.runOnFxThread(() -> {
            if (this.peer != null) {
                r.run();
            } else {
                this.peerRequests.clear();
                this.peerRequests.add(r);
            }
        });
    }

    void setImageBounds(int x, int y, int w, int h) {
        Runnable r = () -> {
            Window win = this.getScene().getWindow();
            float uiScale = WindowHelper.getWindowAccessor().getUIScale(win);
            this.peer.setImageBounds(x, y, w, h, (float)w / uiScale, (float)h / uiScale);
        };
        SwingFXUtils.runOnFxThread(() -> {
            if (this.peer != null) {
                r.run();
            } else {
                this.peerRequests.add(r);
            }
        });
    }

    void repaintDirtyRegion(int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
        Runnable r = () -> {
            this.peer.repaintDirtyRegion(dirtyX, dirtyY, dirtyWidth, dirtyHeight);
            this.impl_markDirty(DirtyBits.NODE_CONTENTS);
        };
        SwingFXUtils.runOnFxThread(() -> {
            if (this.peer != null) {
                r.run();
            } else {
                this.peerRequests.add(r);
            }
        });
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double width, double height) {
        super.resize(width, height);
        if (width != this.fxWidth || height != this.fxHeight) {
            this.fxWidth = width;
            this.fxHeight = height;
            this.impl_geomChanged();
            this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            SwingFXUtils.runOnEDT(() -> {
                if (this.lwFrame != null) {
                    this.locateLwFrame();
                }
            });
        }
    }

    @Override
    public double prefWidth(double height) {
        float uiScale = WindowHelper.getWindowAccessor().getUIScale(this.getScene().getWindow());
        return (float)this.swingPrefWidth / uiScale;
    }

    @Override
    public double prefHeight(double width) {
        float uiScale = WindowHelper.getWindowAccessor().getUIScale(this.getScene().getWindow());
        return (float)this.swingPrefHeight / uiScale;
    }

    @Override
    public double maxWidth(double height) {
        float uiScale = WindowHelper.getWindowAccessor().getUIScale(this.getScene().getWindow());
        return (float)this.swingMaxWidth / uiScale;
    }

    @Override
    public double maxHeight(double width) {
        float uiScale = WindowHelper.getWindowAccessor().getUIScale(this.getScene().getWindow());
        return (float)this.swingMaxHeight / uiScale;
    }

    @Override
    public double minWidth(double height) {
        float uiScale = WindowHelper.getWindowAccessor().getUIScale(this.getScene().getWindow());
        return (float)this.swingMinWidth / uiScale;
    }

    @Override
    public double minHeight(double width) {
        float uiScale = WindowHelper.getWindowAccessor().getUIScale(this.getScene().getWindow());
        return (float)this.swingMinHeight / uiScale;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double localX, double localY) {
        return true;
    }

    private void removeSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.removeWindowListeners(window);
        }
        scene.windowProperty().removeListener(this.sceneWindowListener);
    }

    private void addSceneListeners(Scene scene) {
        Window window = scene.getWindow();
        if (window != null) {
            this.addWindowListeners(window);
        }
        scene.windowProperty().addListener(this.sceneWindowListener);
    }

    private void addWindowListeners(Window window) {
        window.xProperty().addListener(this.locationListener);
        window.yProperty().addListener(this.locationListener);
        window.addEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().addListener(this.windowVisibleListener);
        this.scale = Math.round(WindowHelper.getWindowAccessor().getRenderScale(window));
        this.setLwFrameScale(this.scale);
    }

    private void removeWindowListeners(Window window) {
        window.xProperty().removeListener(this.locationListener);
        window.yProperty().removeListener(this.locationListener);
        window.removeEventHandler(FocusUngrabEvent.FOCUS_UNGRAB, this.ungrabHandler);
        window.showingProperty().removeListener(this.windowVisibleListener);
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        this.peer = new NGExternalNode();
        this.peer.setLock(this.paintLock);
        for (Runnable request : this.peerRequests) {
            request.run();
        }
        this.peerRequests = null;
        if (this.getScene() != null) {
            this.addSceneListeners(this.getScene());
        }
        this.sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                this.removeSceneListeners((Scene)oldValue);
                this.disposeLwFrame();
            }
            if (newValue != null) {
                if (this.content != null && this.lwFrame == null) {
                    this.setContent(this.content);
                }
                this.addSceneListeners((Scene)newValue);
            }
        });
        this.impl_treeVisibleProperty().addListener((observable, oldValue, newValue) -> this.setLwFrameVisible((boolean)newValue));
        return this.peer;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_VISIBLE) || this.impl_isDirty(DirtyBits.NODE_BOUNDS)) {
            this.locateLwFrame();
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            this.peer.markContentDirty();
        }
    }

    private void locateLwFrame() {
        if (this.getScene() == null || this.lwFrame == null || this.getScene().getWindow() == null || !this.getScene().getWindow().isShowing()) {
            return;
        }
        Window w = this.getScene().getWindow();
        float renderScale = WindowHelper.getWindowAccessor().getRenderScale(w);
        float uiScale = WindowHelper.getWindowAccessor().getUIScale(w);
        int lwScale = Math.round(renderScale);
        boolean sendScale = this.scale != lwScale;
        this.scale = lwScale;
        Point2D loc = this.localToScene(0.0, 0.0);
        int windowX = (int)(w.getX() * (double)uiScale);
        int windowY = (int)(w.getY() * (double)uiScale);
        int windowW = (int)(w.getWidth() * (double)uiScale);
        int windowH = (int)(w.getHeight() * (double)uiScale);
        int frameX = (int)Math.round((w.getX() + this.getScene().getX() + loc.getX()) * (double)uiScale);
        int frameY = (int)Math.round((w.getY() + this.getScene().getY() + loc.getY()) * (double)uiScale);
        int frameW = (int)(this.fxWidth * (double)uiScale);
        int frameH = (int)(this.fxHeight * (double)uiScale);
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                if (sendScale) {
                    jlfNotifyDisplayChanged.invoke(this.lwFrame, this.scale);
                }
                this.lwFrame.setSize(frameW, frameH);
                this.lwFrame.setLocation(frameX, frameY);
                jlfSetHostBounds.invoke(this.lwFrame, windowX, windowY, windowW, windowH);
            }
        });
    }

    private void activateLwFrame(boolean activate) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.lwFrame.emulateActivation(activate);
            }
        });
    }

    private void disposeLwFrame() {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.lwFrame.dispose();
                this.lwFrame = null;
            }
        });
    }

    private void setLwFrameVisible(boolean visible) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(() -> {
            if (this.lwFrame != null) {
                this.lwFrame.setVisible(visible);
            }
        });
    }

    private void setLwFrameScale(final int scale) {
        if (this.lwFrame == null) {
            return;
        }
        SwingFXUtils.runOnEDT(new Runnable(){

            @Override
            public void run() {
                if (SwingNode.this.lwFrame != null) {
                    jlfNotifyDisplayChanged.invoke(SwingNode.this.lwFrame, scale);
                }
            }
        });
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        bounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.fxWidth, (float)this.fxHeight, 0.0f);
        tx.transform(bounds, bounds);
        return bounds;
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm alg, MXNodeAlgorithmContext ctx) {
        return alg.processLeafNode(this, ctx);
    }

    private void ungrabFocus(boolean postUngrabEvent) {
        if (PlatformUtil.isLinux()) {
            return;
        }
        if (this.grabbed && this.getScene() != null && this.getScene().getWindow() != null && this.getScene().getWindow().impl_getPeer() != null) {
            this.skipBackwardUnrgabNotification = !postUngrabEvent;
            this.getScene().getWindow().impl_getPeer().ungrabFocus();
            this.skipBackwardUnrgabNotification = false;
            this.grabbed = false;
        }
    }

    private class SwingKeyEventHandler
    implements EventHandler<KeyEvent> {
        private SwingKeyEventHandler() {
        }

        @Override
        public void handle(KeyEvent event) {
            String text;
            int swingID;
            JLightweightFrame frame = SwingNode.this.lwFrame;
            if (frame == null) {
                return;
            }
            if (event.getCharacter().isEmpty()) {
                return;
            }
            if (event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.UP || event.getCode() == KeyCode.DOWN || event.getCode() == KeyCode.TAB) {
                event.consume();
            }
            if ((swingID = SwingEvents.fxKeyEventTypeToKeyID(event)) < 0) {
                return;
            }
            int swingModifiers = SwingEvents.fxKeyModsToKeyMods(event);
            int swingKeyCode = event.getCode().impl_getCode();
            char swingChar = event.getCharacter().charAt(0);
            if (event.getEventType() == KeyEvent.KEY_PRESSED && (text = event.getText()).length() == 1) {
                swingChar = text.charAt(0);
            }
            long swingWhen = System.currentTimeMillis();
            java.awt.event.KeyEvent keyEvent = new java.awt.event.KeyEvent(frame, swingID, swingWhen, swingModifiers, swingKeyCode, swingChar);
            AccessController.doPrivileged(new PostEventAction(keyEvent));
        }
    }

    private class SwingScrollEventHandler
    implements EventHandler<ScrollEvent> {
        private SwingScrollEventHandler() {
        }

        @Override
        public void handle(ScrollEvent event) {
            double delta;
            boolean isShift;
            JLightweightFrame frame = SwingNode.this.lwFrame;
            if (frame == null) {
                return;
            }
            int swingModifiers = SwingEvents.fxScrollModsToMouseWheelMods(event);
            boolean bl = isShift = (swingModifiers & 0x40) != 0;
            if (!isShift && event.getDeltaY() != 0.0) {
                this.sendMouseWheelEvent(frame, event.getX(), event.getY(), swingModifiers, event.getDeltaY() / event.getMultiplierY());
            }
            double d = delta = isShift && event.getDeltaY() != 0.0 ? event.getDeltaY() / event.getMultiplierY() : event.getDeltaX() / event.getMultiplierX();
            if (delta != 0.0) {
                this.sendMouseWheelEvent(frame, event.getX(), event.getY(), swingModifiers |= 0x40, delta);
            }
        }

        private void sendMouseWheelEvent(Component source, double fxX, double fxY, int swingModifiers, double delta) {
            int wheelRotation = (int)delta;
            int signum = (int)Math.signum(delta);
            if ((double)signum * delta < 1.0) {
                wheelRotation = signum;
            }
            Window w = SwingNode.this.getScene().getWindow();
            float uiScale = WindowHelper.getWindowAccessor().getUIScale(w);
            int x = (int)Math.round(fxX * (double)uiScale);
            int y = (int)Math.round(fxY * (double)uiScale);
            MouseWheelEvent mouseWheelEvent = new MouseWheelEvent(source, 507, System.currentTimeMillis(), swingModifiers, x, y, 0, 0, 0, false, 0, 1, -wheelRotation);
            AccessController.doPrivileged(new PostEventAction(mouseWheelEvent));
        }
    }

    private class SwingMouseEventHandler
    implements EventHandler<javafx.scene.input.MouseEvent> {
        private final Set<MouseButton> mouseClickedAllowed = new HashSet<MouseButton>();

        private SwingMouseEventHandler() {
        }

        @Override
        public void handle(javafx.scene.input.MouseEvent event) {
            JLightweightFrame frame = SwingNode.this.lwFrame;
            if (frame == null) {
                return;
            }
            int swingID = SwingEvents.fxMouseEventTypeToMouseID(event);
            if (swingID < 0) {
                return;
            }
            event.consume();
            EventType<? extends javafx.scene.input.MouseEvent> type = event.getEventType();
            if (type == javafx.scene.input.MouseEvent.MOUSE_PRESSED) {
                this.mouseClickedAllowed.add(event.getButton());
            } else if (type != javafx.scene.input.MouseEvent.MOUSE_RELEASED) {
                if (type == javafx.scene.input.MouseEvent.MOUSE_DRAGGED) {
                    this.mouseClickedAllowed.clear();
                } else if (type == javafx.scene.input.MouseEvent.MOUSE_CLICKED) {
                    if (event.getClickCount() == 1 && !this.mouseClickedAllowed.contains((Object)event.getButton())) {
                        return;
                    }
                    this.mouseClickedAllowed.remove((Object)event.getButton());
                }
            }
            int swingModifiers = SwingEvents.fxMouseModsToMouseMods(event);
            boolean swingPopupTrigger = event.isPopupTrigger();
            int swingButton = SwingEvents.fxMouseButtonToMouseButton(event);
            long swingWhen = System.currentTimeMillis();
            Window win = SwingNode.this.getScene().getWindow();
            float uiScale = WindowHelper.getWindowAccessor().getUIScale(win);
            int relX = (int)Math.round(event.getX() * (double)uiScale);
            int relY = (int)Math.round(event.getY() * (double)uiScale);
            int absX = (int)Math.round(event.getScreenX() * (double)uiScale);
            int absY = (int)Math.round(event.getScreenY() * (double)uiScale);
            MouseEvent mouseEvent = new MouseEvent(frame, swingID, swingWhen, swingModifiers, relX, relY, absX, absY, event.getClickCount(), swingPopupTrigger, swingButton);
            AccessController.doPrivileged(new PostEventAction(mouseEvent));
        }
    }

    private class PostEventAction
    implements PrivilegedAction<Void> {
        private AWTEvent event;

        public PostEventAction(AWTEvent event) {
            this.event = event;
        }

        @Override
        public Void run() {
            EventQueue eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
            eq.postEvent(this.event);
            return null;
        }
    }

    private static class SwingNodeContent
    implements LightweightContent {
        private JComponent comp;
        private volatile FXDnD dnd;
        private WeakReference<SwingNode> swingNodeRef;

        public SwingNodeContent(JComponent comp, SwingNode swingNode) {
            this.comp = comp;
            this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
        }

        @Override
        public JComponent getComponent() {
            return this.comp;
        }

        @Override
        public void paintLock() {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.paintLock.lock();
            }
        }

        @Override
        public void paintUnlock() {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.paintLock.unlock();
            }
        }

        @Override
        public void imageBufferReset(int[] data, int x, int y, int width, int height, int linestride) {
            this.imageBufferReset(data, x, y, width, height, linestride, 1);
        }

        @Override
        public void imageBufferReset(int[] data, int x, int y, int width, int height, int linestride, int scale) {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.setImageBuffer(data, x, y, width, height, linestride, scale);
            }
        }

        @Override
        public void imageReshaped(int x, int y, int width, int height) {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.setImageBounds(x, y, width, height);
            }
        }

        @Override
        public void imageUpdated(int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
            SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
            if (swingNode != null) {
                swingNode.repaintDirtyRegion(dirtyX, dirtyY, dirtyWidth, dirtyHeight);
            }
        }

        @Override
        public void focusGrabbed() {
            SwingFXUtils.runOnFxThread(() -> {
                Scene scene;
                if (PlatformUtil.isLinux()) {
                    return;
                }
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null && (scene = swingNode.getScene()) != null && scene.getWindow() != null && scene.getWindow().impl_getPeer() != null) {
                    scene.getWindow().impl_getPeer().grabFocus();
                    swingNode.grabbed = true;
                }
            });
        }

        @Override
        public void focusUngrabbed() {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.ungrabFocus(false);
                }
            });
        }

        @Override
        public void preferredSizeChanged(int width, int height) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.swingPrefWidth = width;
                    swingNode.swingPrefHeight = height;
                    swingNode.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void maximumSizeChanged(int width, int height) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.swingMaxWidth = width;
                    swingNode.swingMaxHeight = height;
                    swingNode.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void minimumSizeChanged(int width, int height) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.swingMinWidth = width;
                    swingNode.swingMinHeight = height;
                    swingNode.impl_notifyLayoutBoundsChanged();
                }
            });
        }

        @Override
        public void setCursor(Cursor cursor) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.setCursor(SwingCursors.embedCursorToCursor(cursor));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initDnD() {
            SwingNodeContent swingNodeContent = this;
            synchronized (swingNodeContent) {
                SwingNode swingNode;
                if (this.dnd == null && (swingNode = (SwingNode)this.swingNodeRef.get()) != null) {
                    this.dnd = new FXDnD(swingNode);
                }
            }
        }

        @Override
        public synchronized <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> abstractRecognizerClass, DragSource ds, Component c, int srcActions, DragGestureListener dgl) {
            this.initDnD();
            return this.dnd.createDragGestureRecognizer(abstractRecognizerClass, ds, c, srcActions, dgl);
        }

        @Override
        public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
            this.initDnD();
            return this.dnd.createDragSourceContextPeer(dge);
        }

        @Override
        public void addDropTarget(DropTarget dt) {
            this.initDnD();
            this.dnd.addDropTarget(dt);
        }

        @Override
        public void removeDropTarget(DropTarget dt) {
            this.initDnD();
            this.dnd.removeDropTarget(dt);
        }
    }

    private static class SwingNodeWindowFocusListener
    implements WindowFocusListener {
        private WeakReference<SwingNode> swingNodeRef;

        SwingNodeWindowFocusListener(SwingNode swingNode) {
            this.swingNodeRef = new WeakReference<SwingNode>(swingNode);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.requestFocus();
                }
            });
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            SwingFXUtils.runOnFxThread(() -> {
                SwingNode swingNode = (SwingNode)this.swingNodeRef.get();
                if (swingNode != null) {
                    swingNode.ungrabFocus(true);
                }
            });
        }
    }

    private static class SwingNodeDisposer
    implements DisposerRecord {
        JLightweightFrame lwFrame;

        SwingNodeDisposer(JLightweightFrame ref) {
            this.lwFrame = ref;
        }

        @Override
        public void dispose() {
            if (this.lwFrame != null) {
                this.lwFrame.dispose();
                this.lwFrame = null;
            }
        }
    }

    private static final class OptionalMethod<T> {
        private final Method method;

        public OptionalMethod(Class<T> cls, String name, Class<?> ... args) {
            Method m;
            try {
                m = cls.getMethod(name, args);
            }
            catch (NoSuchMethodException ignored) {
                m = null;
            }
            catch (Throwable ex) {
                throw new RuntimeException("Error when calling " + cls.getName() + ".getMethod('" + name + "').", ex);
            }
            this.method = m;
        }

        public boolean isSupported() {
            return this.method != null;
        }

        public Object invoke(T object, Object ... args) {
            if (this.method != null) {
                try {
                    return this.method.invoke(object, args);
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Error when calling " + object.getClass().getName() + "." + this.method.getName() + "().", ex);
                }
            }
            return null;
        }
    }
}

