/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ListBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableListValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class ListExpression<E>
implements ObservableListValue<E> {
    private static final ObservableList EMPTY_LIST = FXCollections.emptyObservableList();

    @Override
    public ObservableList<E> getValue() {
        return (ObservableList)this.get();
    }

    public static <E> ListExpression<E> listExpression(final ObservableListValue<E> value) {
        if (value == null) {
            throw new NullPointerException("List must be specified.");
        }
        return value instanceof ListExpression ? (ListExpression<E>)value : new ListBinding<E>(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected ObservableList<E> computeValue() {
                return (ObservableList)value.get();
            }

            @Override
            public ObservableList<ObservableListValue<E>> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public int getSize() {
        return this.size();
    }

    public abstract ReadOnlyIntegerProperty sizeProperty();

    public abstract ReadOnlyBooleanProperty emptyProperty();

    public ObjectBinding<E> valueAt(int index) {
        return Bindings.valueAt(this, index);
    }

    public ObjectBinding<E> valueAt(ObservableIntegerValue index) {
        return Bindings.valueAt(this, index);
    }

    public BooleanBinding isEqualTo(ObservableList<?> other) {
        return Bindings.equal(this, other);
    }

    public BooleanBinding isNotEqualTo(ObservableList<?> other) {
        return Bindings.notEqual(this, other);
    }

    public BooleanBinding isNull() {
        return Bindings.isNull(this);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull(this);
    }

    public StringBinding asString() {
        return (StringBinding)StringFormatter.convert(this);
    }

    @Override
    public int size() {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.size() : list.size();
    }

    @Override
    public boolean isEmpty() {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.isEmpty() : list.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.contains(obj) : list.contains(obj);
    }

    @Override
    public Iterator<E> iterator() {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.iterator() : list.iterator();
    }

    @Override
    public Object[] toArray() {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.toArray() : list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] array) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.toArray(array) : list.toArray(array);
    }

    @Override
    public boolean add(E element) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.add(element) : list.add(element);
    }

    @Override
    public boolean remove(Object obj) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.remove(obj) : list.remove(obj);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.contains(objects) : list.containsAll(objects);
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.addAll(elements) : list.addAll(elements);
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> elements) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.addAll(i, elements) : list.addAll(i, elements);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.removeAll(objects) : list.removeAll(objects);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.retainAll(objects) : list.retainAll(objects);
    }

    @Override
    public void clear() {
        ObservableList list = (ObservableList)this.get();
        if (list == null) {
            EMPTY_LIST.clear();
        } else {
            list.clear();
        }
    }

    @Override
    public E get(int i) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.get(i) : list.get(i);
    }

    @Override
    public E set(int i, E element) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.set(i, element) : list.set(i, element);
    }

    @Override
    public void add(int i, E element) {
        ObservableList list = (ObservableList)this.get();
        if (list == null) {
            EMPTY_LIST.add(i, element);
        } else {
            list.add(i, element);
        }
    }

    @Override
    public E remove(int i) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.remove(i) : list.remove(i);
    }

    @Override
    public int indexOf(Object obj) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.indexOf(obj) : list.indexOf(obj);
    }

    @Override
    public int lastIndexOf(Object obj) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.lastIndexOf(obj) : list.lastIndexOf(obj);
    }

    @Override
    public ListIterator<E> listIterator() {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.listIterator() : list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.listIterator(i) : list.listIterator(i);
    }

    @Override
    public List<E> subList(int from, int to) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.subList(from, to) : list.subList(from, to);
    }

    @Override
    public boolean addAll(E ... elements) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.addAll(elements) : list.addAll(elements);
    }

    @Override
    public boolean setAll(E ... elements) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.setAll(elements) : list.setAll(elements);
    }

    @Override
    public boolean setAll(Collection<? extends E> elements) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.setAll(elements) : list.setAll(elements);
    }

    @Override
    public boolean removeAll(E ... elements) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.removeAll(elements) : list.removeAll(elements);
    }

    @Override
    public boolean retainAll(E ... elements) {
        ObservableList list = (ObservableList)this.get();
        return list == null ? EMPTY_LIST.retainAll(elements) : list.retainAll(elements);
    }

    @Override
    public void remove(int from, int to) {
        ObservableList list = (ObservableList)this.get();
        if (list == null) {
            EMPTY_LIST.remove(from, to);
        } else {
            list.remove(from, to);
        }
    }
}

