/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.prism.ps.Shader;
import com.sun.scenario.effect.ColorAdjust;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.ps.PPSOneSamplerPeer;
import java.util.HashMap;

public class PPSColorAdjustPeer
extends PPSOneSamplerPeer {
    public PPSColorAdjustPeer(FilterContext fctx, Renderer r, String shaderName) {
        super(fctx, r, shaderName);
    }

    @Override
    protected final ColorAdjust getEffect() {
        return (ColorAdjust)super.getEffect();
    }

    private float getHue() {
        return this.getEffect().getHue() / 2.0f;
    }

    private float getSaturation() {
        return this.getEffect().getSaturation() + 1.0f;
    }

    private float getBrightness() {
        return this.getEffect().getBrightness() + 1.0f;
    }

    private float getContrast() {
        float c = this.getEffect().getContrast();
        if (c > 0.0f) {
            c *= 3.0f;
        }
        return c + 1.0f;
    }

    @Override
    protected boolean isSamplerLinear(int i) {
        switch (i) {
            default: 
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> samplers = new HashMap<String, Integer>();
        samplers.put("baseImg", 0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("saturation", 1);
        params.put("brightness", 2);
        params.put("contrast", 3);
        params.put("hue", 0);
        return this.getRenderer().createShader(this.getShaderName(), samplers, params, false);
    }

    @Override
    protected void updateShader(Shader shader) {
        shader.setConstant("saturation", this.getSaturation());
        shader.setConstant("brightness", this.getBrightness());
        shader.setConstant("contrast", this.getContrast());
        shader.setConstant("hue", this.getHue());
    }
}

