/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.webkit.theme;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.webkit.Accessor;
import com.sun.javafx.webkit.theme.Renderer;
import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.graphics.Ref;
import com.sun.webkit.graphics.RenderTheme;
import com.sun.webkit.graphics.WCGraphicsContext;
import com.sun.webkit.graphics.WCSize;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Application;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.geometry.Orientation;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;

public final class RenderThemeImpl
extends RenderTheme {
    private static final Logger log = Logger.getLogger(RenderThemeImpl.class.getName());
    private Accessor accessor;
    private boolean isDefault;
    private Pool<FormControl> pool;

    public RenderThemeImpl(Accessor accessor) {
        this.accessor = accessor;
        this.pool = new Pool<FormControl>(fc -> accessor.removeChild(fc.asControl()), FormControl.class);
        accessor.addViewListener(new ViewListener(this.pool, accessor));
    }

    public RenderThemeImpl() {
        this.isDefault = true;
    }

    private void ensureNotDefault() {
        if (this.isDefault) {
            throw new IllegalStateException("the method should not be called in this context");
        }
    }

    @Override
    protected Ref createWidget(long id, int widgetIndex, int state, int w, int h, int bgColor, ByteBuffer extParams) {
        this.ensureNotDefault();
        FormControl fc = this.pool.get(id);
        WidgetType type = WidgetType.convert(widgetIndex);
        if (fc == null || fc.getType() != type) {
            if (fc != null) {
                this.accessor.removeChild(fc.asControl());
            }
            switch (type) {
                case TEXTFIELD: {
                    fc = new FormTextField();
                    break;
                }
                case BUTTON: {
                    fc = new FormButton();
                    break;
                }
                case CHECKBOX: {
                    fc = new FormCheckBox();
                    break;
                }
                case RADIOBUTTON: {
                    fc = new FormRadioButton();
                    break;
                }
                case MENULIST: {
                    fc = new FormMenuList();
                    break;
                }
                case MENULISTBUTTON: {
                    fc = new FormMenuListButton();
                    break;
                }
                case SLIDER: {
                    fc = new FormSlider();
                    break;
                }
                case PROGRESSBAR: {
                    fc = new FormProgressBar(WidgetType.PROGRESSBAR);
                    break;
                }
                case METER: {
                    fc = new FormProgressBar(WidgetType.METER);
                    break;
                }
                default: {
                    log.log(Level.ALL, "unknown widget index: {0}", widgetIndex);
                    return null;
                }
            }
            fc.asControl().setFocusTraversable(false);
            this.pool.put(id, fc, this.accessor.getPage().getUpdateContentCycleID());
            this.accessor.addChild(fc.asControl());
        }
        fc.setState(state);
        Control ctrl = fc.asControl();
        if (ctrl.getWidth() != (double)w || ctrl.getHeight() != (double)h) {
            ctrl.resize(w, h);
        }
        if (ctrl.isManaged()) {
            ctrl.setManaged(false);
        }
        if (type == WidgetType.SLIDER) {
            Slider slider = (Slider)ctrl;
            extParams.order(ByteOrder.nativeOrder());
            slider.setOrientation(extParams.getInt() == 0 ? Orientation.HORIZONTAL : Orientation.VERTICAL);
            slider.setMax(extParams.getFloat());
            slider.setMin(extParams.getFloat());
            slider.setValue(extParams.getFloat());
        } else if (type == WidgetType.PROGRESSBAR) {
            ProgressBar progress = (ProgressBar)ctrl;
            extParams.order(ByteOrder.nativeOrder());
            progress.setProgress(extParams.getInt() == 1 ? (double)extParams.getFloat() : -1.0);
        } else if (type == WidgetType.METER) {
            ProgressBar progress = (ProgressBar)ctrl;
            extParams.order(ByteOrder.nativeOrder());
            progress.setProgress(extParams.getFloat());
            progress.setStyle(this.getMeterStyle(extParams.getInt()));
        }
        return new FormControlRef(fc);
    }

    private String getMeterStyle(int region) {
        switch (region) {
            case 1: {
                return "-fx-accent: yellow";
            }
            case 2: {
                return "-fx-accent: red";
            }
        }
        return "-fx-accent: green";
    }

    @Override
    public void drawWidget(WCGraphicsContext g, Ref widget, int x, int y) {
        Control control;
        this.ensureNotDefault();
        FormControl fcontrol = ((FormControlRef)widget).asFormControl();
        if (fcontrol != null && (control = fcontrol.asControl()) != null) {
            g.saveState();
            g.translate(x, y);
            Renderer.getRenderer().render(control, g);
            g.restoreState();
        }
    }

    @Override
    public WCSize getWidgetSize(Ref widget) {
        this.ensureNotDefault();
        FormControl fcontrol = ((FormControlRef)widget).asFormControl();
        if (fcontrol != null) {
            Control control = fcontrol.asControl();
            return new WCSize((float)control.getWidth(), (float)control.getHeight());
        }
        return new WCSize(0.0f, 0.0f);
    }

    @Override
    protected int getRadioButtonSize() {
        String style = Application.getUserAgentStylesheet();
        if ("MODENA".equalsIgnoreCase(style)) {
            return 20;
        }
        if ("CASPIAN".equalsIgnoreCase(style)) {
            return 19;
        }
        return 20;
    }

    @Override
    protected int getSelectionColor(int index) {
        switch (index) {
            case 0: {
                return -16739329;
            }
            case 1: {
                return -1;
            }
        }
        return 0;
    }

    private static boolean hasState(int state, int mask) {
        return (state & mask) != 0;
    }

    private static final class FormMenuListButton
    extends Button
    implements FormControl {
        private static final int MAX_WIDTH = 20;
        private static final int MIN_WIDTH = 16;

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setHover(RenderThemeImpl.hasState(state, 32));
            this.setPressed(RenderThemeImpl.hasState(state, 16));
            if (this.isPressed()) {
                this.arm();
            } else {
                this.disarm();
            }
        }

        private FormMenuListButton() {
            this.setSkin(new Skin());
            this.setFocusTraversable(false);
            this.getStyleClass().add("form-select-button");
        }

        @Override
        public void resize(double width, double height) {
            width = height > 20.0 ? 20.0 : (height < 16.0 ? 16.0 : height);
            super.resize(width, height);
            this.setTranslateX(-width);
        }

        @Override
        public WidgetType getType() {
            return WidgetType.MENULISTBUTTON;
        }

        private final class Skin
        extends BehaviorSkinBase {
            Skin() {
                super(FormMenuListButton.this, new BehaviorBase<FormMenuListButton>(FormMenuListButton.this, Collections.EMPTY_LIST));
                Region arrow = new Region();
                arrow.getStyleClass().add("arrow");
                arrow.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
                BorderPane pane = new BorderPane();
                pane.setCenter(arrow);
                this.getChildren().add(pane);
            }
        }
    }

    private static final class FormMenuList
    extends ChoiceBox
    implements FormControl {
        private FormMenuList() {
            ArrayList<String> l = new ArrayList<String>();
            l.add("");
            this.setItems(FXCollections.observableList(l));
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setFocused(RenderThemeImpl.hasState(state, 8));
            this.setHover(RenderThemeImpl.hasState(state, 32) && !this.isDisabled());
        }

        @Override
        public WidgetType getType() {
            return WidgetType.MENULIST;
        }
    }

    private static final class FormProgressBar
    extends ProgressBar
    implements FormControl {
        private final WidgetType type;

        private FormProgressBar(WidgetType type) {
            this.type = type;
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setFocused(RenderThemeImpl.hasState(state, 8));
            this.setHover(RenderThemeImpl.hasState(state, 32) && !this.isDisabled());
        }

        @Override
        public WidgetType getType() {
            return this.type;
        }
    }

    private static final class FormSlider
    extends Slider
    implements FormControl {
        private FormSlider() {
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setFocused(RenderThemeImpl.hasState(state, 8));
            this.setHover(RenderThemeImpl.hasState(state, 32) && !this.isDisabled());
        }

        @Override
        public WidgetType getType() {
            return WidgetType.SLIDER;
        }
    }

    private static final class FormRadioButton
    extends RadioButton
    implements FormControl {
        private FormRadioButton() {
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setFocused(RenderThemeImpl.hasState(state, 8));
            this.setHover(RenderThemeImpl.hasState(state, 32) && !this.isDisabled());
            this.setSelected(RenderThemeImpl.hasState(state, 1));
        }

        @Override
        public WidgetType getType() {
            return WidgetType.RADIOBUTTON;
        }
    }

    private static final class FormCheckBox
    extends CheckBox
    implements FormControl {
        private FormCheckBox() {
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setFocused(RenderThemeImpl.hasState(state, 8));
            this.setHover(RenderThemeImpl.hasState(state, 32) && !this.isDisabled());
            this.setSelected(RenderThemeImpl.hasState(state, 1));
        }

        @Override
        public WidgetType getType() {
            return WidgetType.CHECKBOX;
        }
    }

    private static final class FormTextField
    extends TextField
    implements FormControl {
        private FormTextField() {
            this.setStyle("-fx-display-caret: false");
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setEditable(RenderThemeImpl.hasState(state, 64));
            this.setFocused(RenderThemeImpl.hasState(state, 8));
            this.setHover(RenderThemeImpl.hasState(state, 32) && !this.isDisabled());
        }

        @Override
        public WidgetType getType() {
            return WidgetType.TEXTFIELD;
        }
    }

    private static final class FormButton
    extends Button
    implements FormControl {
        private FormButton() {
        }

        @Override
        public Control asControl() {
            return this;
        }

        @Override
        public void setState(int state) {
            this.setDisabled(!RenderThemeImpl.hasState(state, 4));
            this.setFocused(RenderThemeImpl.hasState(state, 8));
            this.setHover(RenderThemeImpl.hasState(state, 32) && !this.isDisabled());
            this.setPressed(RenderThemeImpl.hasState(state, 16));
            if (this.isPressed()) {
                this.arm();
            } else {
                this.disarm();
            }
        }

        @Override
        public WidgetType getType() {
            return WidgetType.BUTTON;
        }
    }

    private static interface FormControl
    extends Widget {
        public Control asControl();

        public void setState(int var1);
    }

    static interface Widget {
        public WidgetType getType();
    }

    private static final class FormControlRef
    extends Ref {
        private final WeakReference<FormControl> fcRef;

        private FormControlRef(FormControl fc) {
            this.fcRef = new WeakReference<FormControl>(fc);
        }

        private FormControl asFormControl() {
            return (FormControl)this.fcRef.get();
        }
    }

    static class ViewListener
    implements InvalidationListener {
        private final Pool pool;
        private final Accessor accessor;
        private LoadListenerClient loadListener;

        ViewListener(Pool pool, Accessor accessor) {
            this.pool = pool;
            this.accessor = accessor;
        }

        @Override
        public void invalidated(Observable ov) {
            this.pool.clear();
            if (this.accessor.getPage() != null && this.loadListener == null) {
                this.loadListener = new LoadListenerClient(){

                    @Override
                    public void dispatchLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
                        if (state == 0) {
                            pool.clear();
                        }
                    }

                    @Override
                    public void dispatchResourceLoadEvent(long frame, int state, String url, String contentType, double progress, int errorCode) {
                    }
                };
                this.accessor.getPage().addLoadListenerClient(this.loadListener);
            }
        }
    }

    static final class Pool<T extends Widget> {
        private static final int INITIAL_CAPACITY = 100;
        private int capacity = 100;
        private final LinkedHashMap<Long, Integer> ids = new LinkedHashMap();
        private final Map<Long, WeakReference<T>> pool = new HashMap<Long, WeakReference<T>>();
        private final Notifier<T> notifier;
        private final String type;

        Pool(Notifier<T> notifier, Class<T> type) {
            this.notifier = notifier;
            this.type = type.getSimpleName();
        }

        T get(long id) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "type: {0}, size: {1}, id: 0x{2}", new Object[]{this.type, this.pool.size(), Long.toHexString(id)});
            }
            assert (this.ids.size() == this.pool.size());
            WeakReference<T> controlRef = this.pool.get(id);
            if (controlRef == null) {
                return null;
            }
            Widget control = (Widget)controlRef.get();
            if (control == null) {
                return null;
            }
            Integer value = (Integer)this.ids.remove(id);
            this.ids.put(id, value);
            return (T)control;
        }

        void put(long id, T control, int updateContentCycleID) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "size: {0}, id: 0x{1}, control: {2}", new Object[]{this.pool.size(), Long.toHexString(id), control.getType()});
            }
            if (this.ids.size() >= this.capacity) {
                Long _id = this.ids.keySet().iterator().next();
                Integer cycleID = this.ids.get(_id);
                if (cycleID != updateContentCycleID) {
                    this.ids.remove(_id);
                    Widget _control = (Widget)this.pool.remove(_id).get();
                    if (_control != null) {
                        this.notifier.notifyRemoved(_control);
                    }
                } else {
                    this.capacity = Math.min(this.capacity, (int)Math.ceil(1.073741823E9)) * 2;
                }
            }
            this.ids.put(id, updateContentCycleID);
            this.pool.put(id, new WeakReference<T>(control));
        }

        void clear() {
            if (log.isLoggable(Level.FINE)) {
                log.fine("size: " + this.pool.size() + ", controls: " + this.pool.values());
            }
            if (this.pool.size() == 0) {
                return;
            }
            this.ids.clear();
            for (WeakReference<T> controlRef : this.pool.values()) {
                Widget control = (Widget)controlRef.get();
                if (control == null) continue;
                this.notifier.notifyRemoved(control);
            }
            this.pool.clear();
            this.capacity = 100;
        }

        static interface Notifier<T> {
            public void notifyRemoved(T var1);
        }
    }

    static enum WidgetType {
        TEXTFIELD(0),
        BUTTON(1),
        CHECKBOX(2),
        RADIOBUTTON(3),
        MENULIST(4),
        MENULISTBUTTON(5),
        SLIDER(6),
        PROGRESSBAR(7),
        METER(8),
        SCROLLBAR(9);

        private static final HashMap<Integer, WidgetType> map;
        private final int value;

        private WidgetType(int value) {
            this.value = value;
        }

        private static WidgetType convert(int index) {
            return map.get(index);
        }

        static {
            map = new HashMap();
            for (WidgetType v : WidgetType.values()) {
                map.put(v.value, v);
            }
        }
    }
}

