/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;

abstract class InputField
extends Control {
    public static final int DEFAULT_PREF_COLUMN_COUNT = 12;
    private BooleanProperty editable = new SimpleBooleanProperty(this, "editable", true);
    private StringProperty promptText = new StringPropertyBase(""){

        @Override
        protected void invalidated() {
            String txt = this.get();
            if (txt != null && txt.contains("\n")) {
                txt = txt.replace("\n", "");
                this.set(txt);
            }
        }

        @Override
        public Object getBean() {
            return InputField.this;
        }

        @Override
        public String getName() {
            return "promptText";
        }
    };
    private IntegerProperty prefColumnCount = new IntegerPropertyBase(12){
        private int oldValue;
        {
            this.oldValue = this.get();
        }

        @Override
        protected void invalidated() {
            int value = this.get();
            if (value < 0) {
                if (this.isBound()) {
                    this.unbind();
                }
                this.set(this.oldValue);
                throw new IllegalArgumentException("value cannot be negative.");
            }
            this.oldValue = value;
        }

        @Override
        public Object getBean() {
            return InputField.this;
        }

        @Override
        public String getName() {
            return "prefColumnCount";
        }
    };
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        @Override
        protected void invalidated() {
            InputField.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return InputField.this;
        }

        @Override
        public String getName() {
            return "onAction";
        }
    };

    public final boolean isEditable() {
        return this.editable.getValue();
    }

    public final void setEditable(boolean value) {
        this.editable.setValue(value);
    }

    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    public final StringProperty promptTextProperty() {
        return this.promptText;
    }

    public final String getPromptText() {
        return (String)this.promptText.get();
    }

    public final void setPromptText(String value) {
        this.promptText.set(value);
    }

    public final IntegerProperty prefColumnCountProperty() {
        return this.prefColumnCount;
    }

    public final int getPrefColumnCount() {
        return this.prefColumnCount.getValue();
    }

    public final void setPrefColumnCount(int value) {
        this.prefColumnCount.setValue(value);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public final void setOnAction(EventHandler<ActionEvent> value) {
        this.onActionProperty().set(value);
    }

    public InputField() {
        this.getStyleClass().setAll((String[])new String[]{"input-field"});
    }
}

