/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SimpleAttributeReference
implements PsiReference {
    protected final XmlAttribute myAttribute;

    protected SimpleAttributeReference(XmlAttribute attribute) {
        this.myAttribute = attribute;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getTextRange().substring(this.myAttribute.getValue());
        if (string == null) {
            SimpleAttributeReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement getElement() {
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        return value;
    }

    public TextRange getRangeInElement() {
        return this.getTextRange().shiftRight(1);
    }

    public boolean isReferenceTo(PsiElement element) {
        if (this instanceof PsiPolyVariantReference) {
            ResolveResult[] results;
            PsiPolyVariantReference reference = (PsiPolyVariantReference)this;
            for (ResolveResult result : results = reference.multiResolve(false)) {
                if (!Comparing.equal((Object)result.getElement(), (Object)element)) continue;
                return true;
            }
            return false;
        }
        return Comparing.equal((Object)this.resolve(), (Object)element);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            SimpleAttributeReference.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        this.myAttribute.setValue(this.getTextRange().replace(this.myAttribute.getValue(), newElementName));
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        return value;
    }

    @Nullable
    public final PsiElement resolve() {
        return (PsiElement)ResolveCache.getInstance((Project)this.myAttribute.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

            @Nullable
            public PsiElement resolve(@NotNull PsiReference psiReference, boolean b) {
                if (psiReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                return SimpleAttributeReference.this.resolveImpl();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReference", "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference$1", "resolve"));
            }
        }, false, false);
    }

    @Nullable
    protected abstract PsiElement resolveImpl();

    @NotNull
    protected abstract TextRange getTextRange();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/references/SimpleAttributeReference";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

