/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.validation.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathNodeTest;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.validation.inspections.XPathInspection;
import org.jetbrains.annotations.NotNull;

public interface XPathQuickFixFactory {
    public Fix<XPathExpression>[] createImplicitTypeConversionFixes(XPathExpression var1, XPathType var2, boolean var3);

    public Fix<XPathExpression>[] createRedundantTypeConversionFixes(XPathExpression var1);

    public Fix<XPathNodeTest>[] createUnknownNodeTestFixes(XPathNodeTest var1);

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(XPathInspection var1);

    public boolean isSuppressedFor(PsiElement var1, XPathInspection var2);

    public static abstract class Fix<E extends PsiElement>
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected Fix(E element) {
            super(element);
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                Fix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                Fix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                Fix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                Fix.$$$reportNull$$$0(3);
            }
            return startElement.isValid() && startElement.getParent().isValid();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                Fix.$$$reportNull$$$0(4);
            }
            if (file == null) {
                Fix.$$$reportNull$$$0(5);
            }
            if (startElement == null) {
                Fix.$$$reportNull$$$0(6);
            }
            if (endElement == null) {
                Fix.$$$reportNull$$$0(7);
            }
            this.invokeImpl(project, file);
        }

        protected abstract void invokeImpl(Project var1, PsiFile var2) throws IncorrectOperationException;

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/lang/xpath/validation/inspections/quickfix/XPathQuickFixFactory$Fix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAvailable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

