/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.xpath.psi.XPathElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReferenceBase
implements PsiReference {
    private final XPathElement element;
    private final ASTNode nameNode;

    public ReferenceBase(XPathElement element, ASTNode nameNode) {
        this.element = element;
        this.nameNode = nameNode;
    }

    public XPathElement getElement() {
        return this.element;
    }

    public TextRange getRangeInElement() {
        int outer = this.element.getTextRange().getStartOffset();
        return TextRange.from((int)(this.nameNode.getTextRange().getStartOffset() - outer), (int)this.nameNode.getTextLength());
    }

    @Nullable
    public PsiElement resolve() {
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.nameNode.getText();
        if (string == null) {
            ReferenceBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new IncorrectOperationException("unsupported");
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ReferenceBase.$$$reportNull$$$0(1);
        }
        throw new IncorrectOperationException("unsupported");
    }

    public boolean isReferenceTo(PsiElement element) {
        return Comparing.equal((Object)this.resolve(), (Object)element);
    }

    @NotNull
    public abstract Object[] getVariants();

    public boolean isSoft() {
        return true;
    }

    public ASTNode getNameNode() {
        return this.nameNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/psi/impl/ReferenceBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/psi/impl/ReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

