/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspJava;

import com.intellij.application.options.JspCodeStyleSettings;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportListAttribute;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatementImpl;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspElementTypeEx;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspxImportListImpl
extends CompositePsiElement
implements JspxImportList {
    public JspxImportListImpl() {
        super(JspElementTypeEx.JSP_IMPORT_LIST_WRAPPER);
    }

    private JspxImportListAttribute[] computeAttributes(boolean checkIncludes) {
        ArrayList<JspxImportListAttribute> listAttributes = new ArrayList<JspxImportListAttribute>();
        List<XmlTag> allImportDirectives = this.getAllImportDirectives(checkIncludes);
        for (XmlTag xmlTag : allImportDirectives) {
            for (XmlAttribute attribute : xmlTag.getAttributes()) {
                String namespace;
                if (!"import".equals(attribute.getName()) || !(namespace = attribute.getNamespace()).isEmpty() && !"http://java.sun.com/JSP/Page".equals(namespace)) continue;
                listAttributes.add(new JspxImportListAttribute(attribute, this));
            }
        }
        return listAttributes.toArray(new JspxImportListAttribute[listAttributes.size()]);
    }

    private List<XmlTag> getAllImportDirectives(boolean checkIncludes) {
        XmlTag[] directiveTags;
        ArrayList<XmlTag> importStatements = new ArrayList<XmlTag>();
        JspFile jspFile = this.getJspRoot();
        block0: for (XmlTag directiveTag : directiveTags = jspFile.getDirectiveTags(JspDirectiveKind.PAGE, checkIncludes)) {
            for (XmlAttribute attribute : directiveTag.getAttributes()) {
                String namespace;
                if (!"import".equals(attribute.getName()) || !(namespace = attribute.getNamespace()).isEmpty() && !"http://java.sun.com/JSP/Page".equals(namespace)) continue;
                importStatements.add(directiveTag);
                continue block0;
            }
        }
        return importStatements;
    }

    private JspFile getJspRoot() {
        FileViewProvider viewProvider = this.getContainingFile().getViewProvider();
        return (JspFile)viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @NotNull
    public PsiImportStatement[] getImportStatements() {
        JspxImportListAttribute[] importAttributes = this.getImportAttributes();
        ArrayList importStatements = new ArrayList(importAttributes.length);
        for (JspxImportListAttribute importAttribute : importAttributes) {
            ContainerUtil.addAll(importStatements, (Object[])importAttribute.getImportStatements());
        }
        PsiImportStatement[] psiImportStatementArray = importStatements.isEmpty() ? PsiImportStatement.EMPTY_ARRAY : importStatements.toArray(new PsiImportStatement[importStatements.size()]);
        if (psiImportStatementArray == null) {
            JspxImportListImpl.$$$reportNull$$$0(0);
        }
        return psiImportStatementArray;
    }

    private synchronized JspxImportListAttribute[] getImportAttributes() {
        if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
            return this.computeAttributes(false);
        }
        return (JspxImportListAttribute[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            JspxImportListAttribute[] attributes = this.computeAttributes(true);
            return new CachedValueProvider.Result((Object)attributes, new Object[]{this, PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    @NotNull
    public PsiImportStaticStatement[] getImportStaticStatements() {
        JspxImportListAttribute[] importAttributes;
        ArrayList importStatements = new ArrayList();
        for (JspxImportListAttribute importAttribute : importAttributes = this.getImportAttributes()) {
            ContainerUtil.addAll(importStatements, (Object[])importAttribute.getStaticImportStatements());
        }
        PsiImportStaticStatement[] psiImportStaticStatementArray = importStatements.toArray(new PsiImportStaticStatement[importStatements.size()]);
        if (psiImportStaticStatementArray == null) {
            JspxImportListImpl.$$$reportNull$$$0(1);
        }
        return psiImportStaticStatementArray;
    }

    @NotNull
    public PsiImportStatementBase[] getAllImportStatements() {
        PsiImportStatementBase[] psiImportStatementBaseArray = (PsiImportStatementBase[])ArrayUtil.mergeArrays((Object[])this.getImportStatements(), (Object[])this.getImportStaticStatements(), (ArrayFactory)PsiImportStatementBase.ARRAY_FACTORY);
        if (psiImportStatementBaseArray == null) {
            JspxImportListImpl.$$$reportNull$$$0(2);
        }
        return psiImportStatementBaseArray;
    }

    public PsiImportStatement findSingleClassImportStatement(String qName) {
        return this.findImportStatement(qName);
    }

    @Nullable
    private PsiImportStatement findImportStatement(String text) {
        PsiImportStatement[] importStatements;
        for (PsiImportStatement importStatement : importStatements = this.getImportStatements()) {
            if (!text.equals(importStatement.getQualifiedName())) continue;
            return importStatement;
        }
        return null;
    }

    public PsiImportStatement findOnDemandImportStatement(String packageName) {
        return this.findImportStatement(packageName + ".*");
    }

    public PsiImportStatementBase findSingleImportStatement(String name) {
        return this.findImportStatement(name);
    }

    public boolean isReplaceEquivalent(PsiImportList otherList) {
        PsiImportStatement[] importStatements2;
        PsiImportStatement[] importStatements1 = this.getImportStatements();
        if (importStatements1.length != (importStatements2 = otherList.getImportStatements()).length) {
            return false;
        }
        for (int i = 0; i < importStatements1.length; ++i) {
            PsiImportStatement importStatement1 = importStatements1[i];
            PsiImportStatement importStatement2 = importStatements2[i];
            if (Comparing.strEqual((String)importStatement1.getQualifiedName(), (String)importStatement2.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        String qualifiedName;
        if (element == null) {
            JspxImportListImpl.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiImportStatement) && !(element instanceof PsiImportStaticStatement)) {
            throw new IncorrectOperationException("Cannot add anything but import statements into JSP import list: " + element);
        }
        XmlTag rootTag = this.getJspRoot().getRootTag();
        PsiImportStatementBase importStatement = (PsiImportStatementBase)element;
        boolean isStatic = importStatement instanceof PsiImportStaticStatement;
        if (isStatic) {
            PsiJavaCodeReferenceElement reference = importStatement.getImportReference();
            assert (reference != null);
            qualifiedName = reference.getCanonicalText();
        } else {
            qualifiedName = ((PsiImportStatement)importStatement).getQualifiedName();
        }
        XmlTag lastImportDirective = this.findLastImportDirective();
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)this.getProject()).getCurrentSettings();
        if (((JspCodeStyleSettings)codeStyleSettings.getCustomSettings(JspCodeStyleSettings.class)).JSP_PREFER_COMMA_SEPARATED_IMPORT_LIST && lastImportDirective != null) {
            XmlAttribute attribute = lastImportDirective.getAttribute("import");
            assert (attribute != null);
            attribute.setValue(attribute.getValue() + ", " + qualifiedName + (importStatement.isOnDemand() ? ".*" : ""));
        } else {
            ASTNode anchor = lastImportDirective != null ? lastImportDirective.getNode() : XmlChildRole.START_TAG_END_FINDER.findChild(rootTag.getNode());
            ASTNode parent = anchor == null ? null : TreeUtil.findParent((ASTNode)anchor, (IElementType)XmlElementType.XML_TAG);
            XmlTag directive = this.getJspRoot().createDirective(parent != null ? (XmlTag)parent.getPsi() : null, JspDirectiveKind.PAGE);
            String text = qualifiedName + (importStatement.isOnDemand() ? ".*" : "");
            if (isStatic) {
                text = "static " + text;
            }
            directive.setAttribute("import", text);
            if (anchor != null) {
                anchor.getTreeParent().getPsi().addAfter((PsiElement)directive, anchor.getPsi());
            } else {
                rootTag.add((PsiElement)directive);
            }
        }
        PsiImportStaticStatement[] importStatements = isStatic ? this.getImportStaticStatements() : this.getImportStatements();
        return importStatements[importStatements.length - 1];
    }

    @Nullable
    private XmlTag findLastImportDirective() {
        List<XmlTag> importDirectives = this.getAllImportDirectives(false);
        return importDirectives.isEmpty() ? null : importDirectives.get(importDirectives.size() - 1);
    }

    public void delete() throws IncorrectOperationException {
        PsiImportStatement[] importStatements;
        for (PsiImportStatement importStatement : importStatements = this.getImportStatements()) {
            importStatement.delete();
        }
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JspxImportListImpl.$$$reportNull$$$0(4);
        }
        if (!(newElement instanceof PsiImportList)) {
            throw new IncorrectOperationException("Can't replace import list with " + newElement);
        }
        PsiImportList importList = (PsiImportList)newElement;
        PsiImportStatement[] jspxImportStatements = this.getImportStatements();
        PsiImportStatement[] importStatements = importList.getImportStatements();
        ArrayList<JspxImportStatementImpl> localImports = new ArrayList<JspxImportStatementImpl>(jspxImportStatements.length);
        ArrayList<JspxImportStatementImpl> includedImports = new ArrayList<JspxImportStatementImpl>(jspxImportStatements.length);
        for (PsiImportStatement jspxImportStatement : jspxImportStatements) {
            JspxImportStatementImpl jspxImportStatementImpl = (JspxImportStatementImpl)jspxImportStatement;
            if (jspxImportStatementImpl.isForeignFileImport()) {
                includedImports.add(jspxImportStatementImpl);
                continue;
            }
            localImports.add(jspxImportStatementImpl);
        }
        Iterator iterator = localImports.iterator();
        block1: for (PsiImportStatement psiImportStatement : importStatements) {
            PsiJavaCodeReferenceElement importReference = psiImportStatement.getImportReference();
            if (importReference == null) continue;
            for (PsiImportStatement psiImportStatement2 : includedImports) {
                PsiJavaCodeReferenceElement reference = psiImportStatement2.getImportReference();
                if (reference == null || !reference.getText().equals(importReference.getText())) continue;
                continue block1;
            }
            if (iterator.hasNext()) {
                ((PsiImportStatement)iterator.next()).replace((PsiElement)psiImportStatement);
                continue;
            }
            this.add((PsiElement)psiImportStatement);
        }
        while (iterator.hasNext()) {
            ((PsiImportStatement)iterator.next()).delete();
        }
        return this;
    }

    public String toString() {
        return "JspxImportList";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStaticStatements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllImportStatements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

