/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import org.jetbrains.annotations.NonNls;

public class TaglibUriXmlBuilder
extends NanoXmlUtil.BaseXmlBuilder {
    @NonNls
    private static final String TAGLIB_TAG = "taglib";
    @NonNls
    private static final String FACELET_TAGLIB_TAG = "facelet-taglib";
    @NonNls
    private static final String URI_TAG = "uri";
    @NonNls
    private static final String NAMESPACE_TAG = "namespace";
    @NonNls
    private static final String LIBRARY_CLASS_TAG = "library-class";
    private static final String TAGLIB_URI_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"taglib", "uri"});
    private static final String FACELET_NAMESPACE_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"facelet-taglib", "namespace"});
    private static final String FACELET_NAMESPACE_LOCATION2 = NanoXmlUtil.createLocation((String[])new String[]{"facelet-taglib", "library-class"});
    private static final String TAGLIB_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"taglib"});
    private static final String FACELET_LOCATION = NanoXmlUtil.createLocation((String[])new String[]{"facelet-taglib"});
    private String myUri;
    private boolean myTagLib;
    private boolean myUriFound;
    private String myShortName;
    private String myVersion;

    public void addPCData(Reader reader, String systemID, int lineNr) throws Exception {
        super.addPCData(reader, systemID, lineNr);
        if (this.isInUri()) {
            this.myUri = TaglibUriXmlBuilder.readText((Reader)reader).trim();
        } else {
            String location = this.getLocation();
            if (location.equals("taglib.short-name") || location.equals("taglib.shortname")) {
                this.myShortName = TaglibUriXmlBuilder.readText((Reader)reader).trim();
            } else if (location.equals("taglib.taglib-version") || location.equals("taglib.taglibversion")) {
                this.myVersion = TaglibUriXmlBuilder.readText((Reader)reader).trim();
            }
        }
    }

    public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
        super.startElement(name, nsPrefix, nsURI, systemID, lineNr);
        String location = this.getLocation();
        if (location.equals(TAGLIB_LOCATION) || location.equals(FACELET_LOCATION)) {
            this.myTagLib = true;
        }
        if (!location.startsWith(TAGLIB_LOCATION) && !location.startsWith(FACELET_LOCATION)) {
            TaglibUriXmlBuilder.stop();
        }
    }

    public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
        if (this.isInUri()) {
            this.myUriFound = true;
            if (this.myUri == null) {
                this.myUri = "";
            }
            TaglibUriXmlBuilder.stopAfterUriFound();
        }
        super.endElement(name, nsPrefix, nsURI);
    }

    protected static void stopAfterUriFound() throws Exception {
        TaglibUriXmlBuilder.stop();
    }

    private boolean isInUri() {
        return this.getLocation().equals(TAGLIB_URI_LOCATION) || this.getLocation().equals(FACELET_NAMESPACE_LOCATION) || this.getLocation().equals(FACELET_NAMESPACE_LOCATION2);
    }

    public boolean isTagLib() {
        return this.myTagLib;
    }

    public boolean isUriFound() {
        return this.myUriFound;
    }

    public String getUri() {
        return this.myUri;
    }

    public String getShortName() {
        return this.myShortName;
    }

    public String getVersion() {
        return this.myVersion;
    }
}

