/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.psi.impl.source.jsp.TaglibUriXmlBuilder;
import com.intellij.psi.impl.source.jsp.TldProcessorFactory;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaglibIndex
extends XmlIndex<TaglibInfo> {
    @NonNls
    private static final MultiMap<String, String> WRAPPED_FACELETS_TAGLIBS = new MultiMap();
    public static final ID<String, TaglibInfo> NAME;

    public static List<IndexedRelevantResource<String, TaglibInfo>> getTldFiles(String namespace, @NotNull Module module, @Nullable JspFile context) {
        if (module == null) {
            TaglibIndex.$$$reportNull$$$0(0);
        }
        GlobalSearchScope scope = TaglibIndex.computeAdditionalScope(module, context);
        List resources = IndexedRelevantResource.getResources(NAME, (Object)namespace, (Module)module, (Project)module.getProject(), (GlobalSearchScope)scope);
        Collections.sort(resources);
        TldProcessorFactory.getFactory(context).processResources(resources);
        return resources;
    }

    @Nullable
    private static GlobalSearchScope computeAdditionalScope(Module module, @Nullable JspFile context) {
        if (context == null) {
            return null;
        }
        VirtualFile file = context.getVirtualFile();
        if (file == null) {
            return null;
        }
        final ArtifactBySourceFileFinder finder = ArtifactBySourceFileFinder.getInstance((Project)module.getProject());
        final Collection artifacts = finder.findArtifacts(file);
        if (artifacts.isEmpty()) {
            return null;
        }
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                Collection a = finder.findArtifacts(file);
                return ContainerUtil.intersects((Collection)artifacts, (Collection)a);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(3);
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/TaglibIndex$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compare";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static List<IndexedRelevantResource<String, TaglibInfo>> getTldFiles(Module module, JspFile context) {
        return IndexedRelevantResource.getAllResources(NAME, (Module)module, (Project)module.getProject(), resources -> {
            TldProcessorFactory.getFactory(context).processResources((List<IndexedRelevantResource<String, TaglibInfo>>)resources);
            return resources.isEmpty() ? null : (IndexedRelevantResource)Collections.max(resources);
        });
    }

    @NotNull
    public ID<String, TaglibInfo> getName() {
        ID<String, TaglibInfo> iD = NAME;
        if (iD == null) {
            TaglibIndex.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                String name;
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (name = file.getName()).endsWith(".tld") || name.endsWith(".taglib.xml") || name.endsWith(".xml") && file.isInLocalFileSystem();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/TaglibIndex$2", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            TaglibIndex.$$$reportNull$$$0(2);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @NotNull
    public DataIndexer<String, TaglibInfo, FileContent> getIndexer() {
        DataIndexer<String, TaglibInfo, FileContent> dataIndexer = new DataIndexer<String, TaglibInfo, FileContent>(){

            @NotNull
            public Map<String, TaglibInfo> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    3.$$$reportNull$$$0(0);
                }
                TaglibUriXmlBuilder builder = new TaglibUriXmlBuilder();
                NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)builder);
                if (builder.isUriFound()) {
                    String uri = builder.getUri();
                    Collection realUris = WRAPPED_FACELETS_TAGLIBS.get((Object)uri);
                    if (realUris.isEmpty()) {
                        Map<String, TaglibInfo> map = Collections.singletonMap(uri, new TaglibInfo(builder.getShortName(), null, builder.getVersion()));
                        if (map == null) {
                            3.$$$reportNull$$$0(1);
                        }
                        return map;
                    }
                }
                Map<String, TaglibInfo> map = Collections.emptyMap();
                if (map == null) {
                    3.$$$reportNull$$$0(2);
                }
                return map;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/impl/source/jsp/TaglibIndex$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/impl/source/jsp/TaglibIndex$3";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            TaglibIndex.$$$reportNull$$$0(3);
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<TaglibInfo> getValueExternalizer() {
        DataExternalizer<TaglibInfo> dataExternalizer = new DataExternalizer<TaglibInfo>(){

            public void save(@NotNull DataOutput out, TaglibInfo value) throws IOException {
                if (out == null) {
                    4.$$$reportNull$$$0(0);
                }
                out.writeUTF(value.shortName);
                out.writeUTF(value.wrappingClass);
                out.writeUTF(value.version);
            }

            public TaglibInfo read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    4.$$$reportNull$$$0(1);
                }
                return new TaglibInfo(in.readUTF(), in.readUTF(), in.readUTF());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/TaglibIndex$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            TaglibIndex.$$$reportNull$$$0(4);
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 7;
    }

    public static boolean isFaceletsTaglib(VirtualFile file) {
        return file.getName().endsWith(".xml");
    }

    static {
        WRAPPED_FACELETS_TAGLIBS.put((Object)"com.sun.facelets.tag.jstl.core.JstlCoreLibrary", Arrays.asList("http://java.sun.com/jstl/core", "http://java.sun.com/jsp/jstl/core"));
        WRAPPED_FACELETS_TAGLIBS.put((Object)"com.sun.facelets.tag.jstl.fn.JstlFnLibrary", Arrays.asList("http://java.sun.com/jstl/functions", "http://java.sun.com/jsp/jstl/functions"));
        WRAPPED_FACELETS_TAGLIBS.putValue((Object)"com.sun.facelets.tag.ui.UILibrary", (Object)"http://java.sun.com/jsf/facelets");
        WRAPPED_FACELETS_TAGLIBS.putValue((Object)"com.sun.facelets.tag.jsf.html.HtmlLibrary", (Object)"http://java.sun.com/jsf/html");
        WRAPPED_FACELETS_TAGLIBS.putValue((Object)"com.sun.facelets.tag.jsf.core.CoreLibrary", (Object)"http://java.sun.com/jsf/core");
        NAME = ID.create((String)"taglibUris");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/jsp/TaglibIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/jsp/TaglibIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTldFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TaglibInfo
    implements Comparable<TaglibInfo> {
        private final String shortName;
        private final String wrappingClass;
        private final String version;

        private TaglibInfo(String shortName, String wrappingClass, String version) {
            this.version = version == null ? "" : version;
            this.wrappingClass = wrappingClass == null ? "" : wrappingClass;
            this.shortName = shortName == null ? "" : shortName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getWrappingClass() {
            return this.wrappingClass;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaglibInfo that = (TaglibInfo)o;
            if (!this.shortName.equals(that.shortName)) {
                return false;
            }
            if (!this.wrappingClass.equals(that.wrappingClass)) {
                return false;
            }
            return this.version.equals(that.version);
        }

        public int hashCode() {
            int result = this.shortName.hashCode();
            result = 31 * result + this.wrappingClass.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }

        @Override
        public int compareTo(@NotNull TaglibInfo o) {
            if (o == null) {
                TaglibInfo.$$$reportNull$$$0(0);
            }
            return this.version.compareTo(o.getVersion());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/impl/source/jsp/TaglibIndex$TaglibInfo", "compareTo"));
        }
    }
}

