/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.jsp.JspWithOtherWorldIntegrationService;
import com.intellij.lexer.JspxLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.XHtmlHighlightingLexerWithEL;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspxHighlightingLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lexer.JspxHighlightingLexer");
    private static final int TAG_FOUND_STATE = 1;
    private static final int JAVA_LEXER_STARTED_STATE = 3;
    private static final int TAG_START_STATE = 2;
    private static final int ATTR_EMBEDDMENT_START_STATE = 4;
    private static final int ATTR_EMBEDDMENT_END_STATE = 5;
    private static final int INITIAL_STATE = 0;
    private final Lexer myXmlLexer = new XHtmlHighlightingLexerWithEL((Lexer)JspxLexer.createElAwareXmlLexer(true));
    private final Lexer myJavaLexer = JspWithOtherWorldIntegrationService.getInstance().createJavaLexer();
    private int myTokenStart = 0;
    private int myTokenEnd = 0;
    private IElementType myTokenType = null;
    private int myState = 0;
    @NonNls
    private static final String TOKEN_SCRIPTLET = "scriptlet";
    @NonNls
    private static final String TOKEN_DECLARATION = "declaration";
    @NonNls
    private static final String TOKEN_EXPRESSION = "expression";
    private static final int BASE_STATE_MASK = 7;
    private static final int XML_LEXER_STATE_SHIFT = 3;
    private static final int JAVA_IN_ATTR_PREFIX_LEN = 2;
    private static final int JAVA_IN_ATTR_SUFFIX_LEN = 1;

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JspxHighlightingLexer.$$$reportNull$$$0(0);
        }
        this.myState = initialState;
        if (this.checkState(3)) {
            LOG.error("This type of lexer could not be restarted in Java context");
        }
        this.myXmlLexer.start(buffer, startOffset, endOffset, this.myState >> 3);
        this.myTokenType = null;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myXmlLexer.getBufferSequence();
        if (charSequence == null) {
            JspxHighlightingLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getState() {
        this.locateToken();
        return this.myState;
    }

    public IElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public int getTokenStart() {
        this.locateToken();
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public int getBufferEnd() {
        return this.myXmlLexer.getBufferEnd();
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        if (this.checkState(3)) {
            this.myTokenType = this.myJavaLexer.getTokenType();
            if (this.myTokenType != null) {
                if (this.myTokenType == TokenType.WHITE_SPACE) {
                    this.myTokenType = JspTokenType.JSP_WHITE_SPACE;
                }
                this.myTokenStart = this.myJavaLexer.getTokenStart();
                this.myTokenEnd = this.myJavaLexer.getTokenEnd();
            } else {
                this.setState(this.myXmlLexer.getTokenType() == JspTokenType.JSPX_JAVA_IN_ATTR ? 5 : 0);
                this.locateToken();
            }
        } else if (this.checkState(4)) {
            this.myTokenStart = this.myXmlLexer.getTokenStart();
            this.myTokenEnd = this.myTokenStart + 2;
            this.myTokenType = JspTokenType.JSPX_JAVA_IN_ATTR_START;
            this.myState = this.myState & 7 | this.myXmlLexer.getState() << 3;
        } else if (this.checkState(5)) {
            this.myTokenEnd = this.myXmlLexer.getTokenEnd();
            this.myTokenStart = this.myTokenEnd - 1;
            this.myTokenType = JspTokenType.JSPX_JAVA_IN_ATTR_END;
            this.myState = this.myState & 7 | this.myXmlLexer.getState() << 3;
        } else {
            this.myTokenType = this.myXmlLexer.getTokenType();
            this.myTokenStart = this.myXmlLexer.getTokenStart();
            this.myTokenEnd = this.myXmlLexer.getTokenEnd();
            this.myState = this.myState & 7 | this.myXmlLexer.getState() << 3;
        }
    }

    public void advance() {
        boolean advanceXmlLexer = true;
        if (this.checkState(3)) {
            this.myJavaLexer.advance();
        } else {
            IElementType tokenType = this.myXmlLexer.getTokenType();
            if (tokenType == XmlTokenType.XML_TAG_NAME && this.checkState(2)) {
                String token = TreeUtil.getTokenText((Lexer)this.myXmlLexer);
                int index = token.indexOf(58);
                if (index > 0 && index < token.length() - 1) {
                    token = token.substring(index + 1);
                }
                if (TOKEN_SCRIPTLET.equals(token) || TOKEN_DECLARATION.equals(token) || TOKEN_EXPRESSION.equals(token)) {
                    this.setState(1);
                }
            } else if (tokenType == XmlTokenType.XML_TAG_END && this.checkState(1)) {
                this.setState(3);
                int javaStart = this.myXmlLexer.getTokenEnd();
                while (this.myXmlLexer.getTokenType() != null) {
                    this.myXmlLexer.advance();
                    IElementType advanceTokenType = this.myXmlLexer.getTokenType();
                    if (advanceTokenType != XmlTokenType.XML_END_TAG_START && advanceTokenType != XmlTokenType.XML_START_TAG_START) continue;
                    break;
                }
                int javaEnd = this.myXmlLexer.getTokenStart();
                this.myJavaLexer.start(this.myXmlLexer.getBufferSequence(), javaStart, javaEnd);
            } else if (tokenType == XmlTokenType.XML_START_TAG_START && this.checkState(0)) {
                this.setState(2);
            } else if (tokenType != XmlTokenType.XML_WHITE_SPACE && this.checkState(2)) {
                this.setState(0);
            } else if ((tokenType == XmlTokenType.XML_START_TAG_START || tokenType == XmlTokenType.XML_EMPTY_ELEMENT_END || tokenType == XmlTokenType.XML_END_TAG_START) && this.checkState(1)) {
                this.setState(0);
            } else if (tokenType == JspTokenType.JSPX_JAVA_IN_ATTR && this.checkState(4)) {
                this.setState(3);
                this.myJavaLexer.start(this.myXmlLexer.getBufferSequence(), this.myXmlLexer.getTokenStart() + 2, this.myXmlLexer.getTokenEnd() - 1);
            } else if (tokenType == JspTokenType.JSPX_JAVA_IN_ATTR && this.checkState(5)) {
                this.setState(0);
            }
        }
        if (!this.checkState(3) && advanceXmlLexer) {
            this.myXmlLexer.advance();
        }
        this.myTokenType = null;
        this.locateToken();
        if (this.myTokenType == JspTokenType.JSPX_JAVA_IN_ATTR && this.checkState(0)) {
            this.setState(4);
            this.myTokenType = null;
            this.locateToken();
        }
    }

    private void setState(int state) {
        this.myState = this.myState & 0xFFFFFFF8 | state;
    }

    private boolean checkState(int flag) {
        return (this.myState & 7) == flag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lexer/JspxHighlightingLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lexer/JspxHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

