/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.reference;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VelocityNamingUtil {
    private VelocityNamingUtil() {
    }

    public static boolean isWaitOrNotifyOfObject(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            VelocityNamingUtil.$$$reportNull$$$0(0);
        }
        if ((psiClass = method.getContainingClass()) == null || !"java.lang.Object".equals(psiClass.getQualifiedName())) {
            return false;
        }
        String name = method.getName();
        return "wait".equals(name) || "notify".equals(name) || "notifyAll".equals(name);
    }

    public static boolean isPropertyGetter(@NotNull PsiMethod method) {
        if (method == null) {
            VelocityNamingUtil.$$$reportNull$$$0(1);
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        PsiType returnType = method.getReturnType();
        if (methodName.startsWith("get") && methodName.length() > "get".length()) {
            if (returnType == null || PsiType.VOID.equals((Object)returnType)) {
                return false;
            }
        } else if (methodName.startsWith("is")) {
            if (!PsiType.BOOLEAN.equals((Object)returnType)) {
                return false;
            }
        } else {
            return false;
        }
        return method.getParameterList().getParametersCount() == 0;
    }

    public static boolean isGetByStringOrByObjectMethod(@NotNull PsiMethod method) {
        String methodName;
        if (method == null) {
            VelocityNamingUtil.$$$reportNull$$$0(2);
        }
        if (!"get".equals(methodName = method.getName())) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != 1) {
            return false;
        }
        PsiParameter parameter = parameterList.getParameters()[0];
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
        PsiClassType javaLangString = factory.createTypeByFQClassName("java.lang.String", method.getResolveScope());
        if (parameter.getType().isAssignableFrom((PsiType)javaLangString)) {
            return true;
        }
        PsiClassType javaLangObject = factory.createTypeByFQClassName("java.lang.Object", method.getResolveScope());
        return parameter.getType().isAssignableFrom((PsiType)javaLangObject);
    }

    public static boolean isPropertySetter(@NotNull PsiMethod method) {
        if (method == null) {
            VelocityNamingUtil.$$$reportNull$$$0(3);
        }
        if (method.isConstructor()) {
            return false;
        }
        String methodName = method.getName();
        return methodName.startsWith("set") && methodName.length() > "set".length() && method.getParameterList().getParametersCount() == 1 && (method.getReturnType() == null || PsiType.VOID.equals((Object)method.getReturnType()));
    }

    public static boolean isPropertyAccessor(PsiMethod method) {
        return VelocityNamingUtil.isPropertyGetter(method) || VelocityNamingUtil.isPropertySetter(method);
    }

    public static String getPropertyNameFromAccessor(@NotNull PsiMethod accessor, boolean firstCharInLowerCase) {
        if (accessor == null) {
            VelocityNamingUtil.$$$reportNull$$$0(4);
        }
        if (VelocityNamingUtil.isPropertySetter(accessor)) {
            return VelocityNamingUtil.adjustFirstCharCase(VelocityNamingUtil.getPropertyNameFromSetter(accessor), firstCharInLowerCase);
        }
        if (VelocityNamingUtil.isPropertyGetter(accessor)) {
            return VelocityNamingUtil.adjustFirstCharCase(VelocityNamingUtil.getPropertyNameFromGetter(accessor), firstCharInLowerCase);
        }
        return null;
    }

    public static String getPropertyNameFromAccessor(@NotNull PsiMethod accessor) {
        if (accessor == null) {
            VelocityNamingUtil.$$$reportNull$$$0(5);
        }
        if (VelocityNamingUtil.isPropertySetter(accessor)) {
            return VelocityNamingUtil.getPropertyNameFromSetter(accessor);
        }
        if (VelocityNamingUtil.isPropertyGetter(accessor)) {
            return VelocityNamingUtil.getPropertyNameFromGetter(accessor);
        }
        return null;
    }

    public static String adjustFirstCharCase(@NotNull String name, boolean lowerCase) {
        if (name == null) {
            VelocityNamingUtil.$$$reportNull$$$0(6);
        }
        char[] chars = name.toCharArray();
        chars[0] = lowerCase ? StringUtil.toLowerCase((char)chars[0]) : StringUtil.toUpperCase((char)chars[0]);
        return new String(chars);
    }

    public static String getPropertyName(String methodName, boolean firstCharInLowerCase) {
        String propName;
        if (methodName.startsWith("get")) {
            propName = methodName.substring("get".length());
        } else if (methodName.startsWith("set")) {
            propName = methodName.substring("set".length());
        } else if (methodName.startsWith("is")) {
            propName = methodName.substring("is".length());
        } else {
            return null;
        }
        return VelocityNamingUtil.adjustFirstCharCase(propName, firstCharInLowerCase);
    }

    private static String getPropertyNameFromGetter(@NotNull PsiMethod getter) {
        String methodName;
        if (getter == null) {
            VelocityNamingUtil.$$$reportNull$$$0(7);
        }
        int prefixLength = (methodName = getter.getName()).startsWith("get") ? "get".length() : "is".length();
        return methodName.substring(prefixLength);
    }

    private static String getPropertyNameFromSetter(@NotNull PsiMethod setter) {
        if (setter == null) {
            VelocityNamingUtil.$$$reportNull$$$0(8);
        }
        return setter.getName().substring("set".length());
    }

    @Nullable
    public static PsiMethod findPropertyGetter(PsiClass aClass, String propertyName) {
        return VelocityNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                return VelocityNamingUtil.isPropertyGetter(method) ? VelocityNamingUtil.getPropertyNameFromGetter(method) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil$1", "extractPropertyName"));
            }
        });
    }

    @Nullable
    public static PsiMethod findPropertySetter(PsiClass aClass, String propertyName) {
        return VelocityNamingUtil.findPropertyAccessor(aClass, propertyName, new PropertyNameExtractor(){

            @Override
            public String extractPropertyName(@NotNull PsiMethod method) {
                if (method == null) {
                    2.$$$reportNull$$$0(0);
                }
                return VelocityNamingUtil.isPropertySetter(method) ? VelocityNamingUtil.getPropertyNameFromSetter(method) : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/velocity/psi/reference/VelocityNamingUtil$2", "extractPropertyName"));
            }
        });
    }

    @Nullable
    private static PsiMethod findPropertyAccessor(PsiClass aClass, String propertyName, PropertyNameExtractor extractor) {
        if (aClass == null) {
            return null;
        }
        PsiMethod found = null;
        String propertyNameWithoutFirstChar = propertyName.substring(1);
        for (PsiMethod method : aClass.getAllMethods()) {
            String wouldBePropertyName = extractor.extractPropertyName(method);
            if (wouldBePropertyName == null || !propertyNameWithoutFirstChar.equals(wouldBePropertyName.substring(1))) continue;
            if (wouldBePropertyName.charAt(0) == propertyName.charAt(0)) {
                return method;
            }
            if (StringUtil.toLowerCase((char)wouldBePropertyName.charAt(0)) != StringUtil.toLowerCase((char)propertyName.charAt(0))) continue;
            found = method;
        }
        return found;
    }

    @Nullable
    public static PsiType getPropertyType(PsiMethod psiMethod) {
        if (VelocityNamingUtil.isPropertyGetter(psiMethod)) {
            return psiMethod.getReturnType();
        }
        if (VelocityNamingUtil.isPropertySetter(psiMethod)) {
            return psiMethod.getParameterList().getParameters()[0].getType();
        }
        return null;
    }

    public static String[] suggestGetterNames(String propertyName) {
        String upperCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, false);
        String lowerCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, true);
        return new String[]{"is" + upperCaseName, "get" + upperCaseName, "is" + lowerCaseName, "get" + lowerCaseName};
    }

    public static String[] suggestSetterNames(String propertyName) {
        String upperCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, false);
        String lowerCaseName = VelocityNamingUtil.adjustFirstCharCase(propertyName, true);
        return new String[]{"set" + upperCaseName, "set" + lowerCaseName};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/psi/reference/VelocityNamingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isWaitOrNotifyOfObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyGetter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isGetByStringOrByObjectMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertySetter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNameFromAccessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustFirstCharCase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNameFromGetter";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNameFromSetter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface PropertyNameExtractor {
        @Nullable
        public String extractPropertyName(@NotNull PsiMethod var1);
    }
}

