/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.VtlInspectionBase;
import com.intellij.velocity.psi.directives.VtlDirective;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlReferencesInspection
extends VtlInspectionBase {
    public static final String SHORT_NAME = "VtlReferencesInspection";
    public boolean fieldsExposed = false;

    private static boolean isInsideLiteralDirective(PsiElement element) {
        while (element != null) {
            if (element instanceof VtlDirective && "literal".equals(((VtlDirective)element).getPresentableName())) {
                return true;
            }
            element = element.getParent();
        }
        return false;
    }

    @Override
    protected void registerProblems(PsiElement element, ProblemsHolder holder) {
        boolean resolvedWithError;
        if (!(element instanceof VtlReferenceExpression) || VtlReferencesInspection.isInsideLiteralDirective(element)) {
            return;
        }
        VtlReferenceExpression ref = (VtlReferenceExpression)element;
        if (!ref.isQualifierResolved()) {
            return;
        }
        PsiFile file = ref.getContainingFile();
        if (file instanceof VtlFile && ((VtlFile)file).isIdeTemplateFile()) {
            return;
        }
        ResolveResult[] results = ref.multiResolve(false);
        boolean bl = resolvedWithError = results.length > 0 && !results[0].isValidResult();
        if (resolvedWithError || ref.resolve() == null) {
            String message = ref.getUnresolvedMessage(resolvedWithError);
            holder.registerProblem((PsiReference)ref, message, resolvedWithError ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = VelocityBundle.message("vtl.references.inspection", new Object[0]);
        if (string == null) {
            VtlReferencesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            VtlReferencesInspection.$$$reportNull$$$0(1);
        }
        return SHORT_NAME;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox cbExpose = new JCheckBox("Public fields are exposed");
        cbExpose.setSelected(this.fieldsExposed);
        panel.add((Component)cbExpose, "North");
        cbExpose.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VtlReferencesInspection.this.fieldsExposed = cbExpose.isSelected();
            }
        });
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/velocity/inspections/VtlReferencesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

