/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.editorActions;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.psi.files.VtlFileViewProvider;

class EditorUtil {
    private EditorUtil() {
    }

    static char getCharAt(Document document, int offset) {
        if (offset < 0 || offset >= document.getTextLength()) {
            return '\u0000';
        }
        return document.getCharsSequence().charAt(offset);
    }

    static IElementType getElementType(PsiElement element) {
        if (element == null) {
            return null;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return null;
        }
        return node.getElementType();
    }

    static boolean isNotVtlFile(PsiFile file, Editor editor) {
        return !(file.getViewProvider() instanceof VtlFileViewProvider) || editor.getCaretModel().getOffset() == 0;
    }
}

