/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "useFileScheme", "", "(Z)V", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteUrls", "", "file", "JavaScriptDebugger"})
public class LocalFileSystemFileFinder
implements DebuggableFileFinder {
    private final boolean useFileScheme;

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile virtualFile;
        String projectBasePath;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String path = url.getPath();
        if (!FileUtil.isAbsolutePlatformIndependent((String)path)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((String)projectBasePath, (String)path, (boolean)true)) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
        if ((virtualFile = file) == null) {
            String string = path;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path");
            virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(string, project);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return CollectionsKt.listOf((Object)(this.useFileScheme ? Urls.newUri((String)"file", (String)file.getPath()) : Urls.newLocalFileUrl((String)file.getPath())));
    }

    public LocalFileSystemFileFinder(boolean useFileScheme) {
        this.useFileScheme = useFileScheme;
    }

    public /* synthetic */ LocalFileSystemFileFinder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public LocalFileSystemFileFinder() {
        this(false, 1, null);
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.findFile(this, url, project, findByName2);
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.findNavigatable(this, url, project);
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.canSetRemoteUrl(this, file, project);
    }

    @Override
    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints(this, file);
    }
}

