/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.javaee.jmxremote.JmxRemoteAware;
import com.intellij.javaee.jmxremote.JmxRemoteUtil;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyLocalModel;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.JavaCommandLineStartupPolicy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class JettyStartupPolicy
implements JavaCommandLineStartupPolicy {
    @NonNls
    public static final String START_JAR_PATH = "start.jar";

    public JavaParameters createCommandLine(CommonModel commonModel) throws ExecutionException {
        JavaParameters result = new JavaParameters();
        Project project = commonModel.getProject();
        JettyLocalModel jettyModel = (JettyLocalModel)commonModel.getServerModel();
        result.setWorkingDirectory(jettyModel.getWorkDir());
        JettyVersionHandler versionHandler = jettyModel.getVersionHandler();
        result.setMainClass(versionHandler.getStartClassName());
        ParametersList vmParams = result.getVMParametersList();
        vmParams.defineProperty("STOP.PORT", "0");
        vmParams.defineProperty("com.sun.management.jmxremote", "");
        vmParams.defineProperty("com.sun.management.jmxremote.port", String.valueOf(jettyModel.getServerPort()));
        JmxRemoteUtil.prepare((JmxRemoteAware)jettyModel, (ParametersList)vmParams);
        vmParams.defineProperty("com.sun.management.jmxremote.ssl", "false");
        vmParams.defineProperty("OPTIONS", "jmx");
        result.getClassPath().add(FileUtil.toSystemDependentName((String)(jettyModel.getHome() + "/" + START_JAR_PATH)));
        ParametersList jettyParams = result.getProgramParametersList();
        Set<String> activeConfigFiles = JettyConfigFile.getActivePaths(jettyModel.getConfigFiles());
        for (String parameter : versionHandler.getCommandLineParameters(activeConfigFiles)) {
            jettyParams.add(parameter);
        }
        try {
            File contextDeployTempDir = FileUtil.createTempDirectory((String)"context", (String)"deploy");
            contextDeployTempDir.deleteOnExit();
            File contextConfigTempDir = FileUtil.createTempDirectory((String)"context", (String)"config");
            contextConfigTempDir.deleteOnExit();
            File contextsConfigFile = versionHandler.writeStartupConfigFile(project, contextConfigTempDir, contextDeployTempDir);
            jettyParams.add(contextsConfigFile.getAbsolutePath());
            jettyModel.setSessionTemporalContextsFolder(contextDeployTempDir);
        }
        catch (IOException e) {
            throw new ExecutionException("Can't configure temporary contexts folder", (Throwable)e);
        }
        return result;
    }
}

