/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentMethod;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.server.JettyDeployTarget;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentMethod;
import com.intellij.javaee.oss.jetty.server.JettyModelData;
import com.intellij.javaee.oss.jetty.server.JettyRemoteEditor;
import com.intellij.javaee.oss.jetty.server.JettyServerModel;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModel;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModelData;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModelDelegate;
import com.intellij.javaee.oss.transport.MultiTargetRemoteStagingProvider;
import com.intellij.javaee.oss.transport.RemoteStagingTargetDefinition;
import com.intellij.javaee.oss.transport.TransportTargetKind;
import com.intellij.javaee.oss.transport.TransportTargetModelBase;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;

public class JettyRemoteModel
extends JettyServerModel<JettyRemoteModelData>
implements MultiTargetRemoteServerModel {
    @NonNls
    public static final String CONTEXT_TARGET_NAME = "CONTEXT";
    @NonNls
    public static final String STAGING_TARGET_NAME = "STAGING";
    public static final MultiTargetRemoteStagingProvider STAGING_PROVIDER = new MultiTargetRemoteStagingProvider(new RemoteStagingTargetDefinition[]{new RemoteStagingTargetDefinition("CONTEXT", JettyBundle.getText("JettyRemoteModel.target.defnition.context", new Object[0]), TransportTargetKind.WATCHED), new RemoteStagingTargetDefinition("STAGING", JettyBundle.getText("JettyRemoteModel.target.defnition.staging", new Object[0]), TransportTargetKind.STAGING)});
    private MultiTargetRemoteServerModelDelegate myTransportDelegate = STAGING_PROVIDER.initModelDelegate(new MultiTargetRemoteServerModelDelegate(), (MultiTargetRemoteServerModel)this);

    public String getTransportHostId() {
        return this.myTransportDelegate.getTransportHostId();
    }

    public void setTransportHostId(String transportHostId) {
        this.myTransportDelegate.setTransportHostId(transportHostId);
    }

    public TransportTargetModelBase getTarget(String targetName) {
        return this.myTransportDelegate.getTarget(targetName);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        LinkedHashSet<String> requiredTargetNames = new LinkedHashSet<String>();
        for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
            DeploymentMethod method = deploymentModel.getDeploymentMethod();
            if (method == null) continue;
            requiredTargetNames.addAll(((JettyDeploymentMethod)method).getRequiredRemoteTargetNames());
        }
        this.myTransportDelegate.checkConfiguration(requiredTargetNames);
    }

    public boolean isDeployAllowed() {
        return this.myTransportDelegate.isDeployAllowed();
    }

    @Override
    public boolean transferFile(File webAppFile, JettyDeployTarget deployTarget) {
        return this.myTransportDelegate.transferFile(deployTarget.getRemoteTargetName(), webAppFile);
    }

    @Override
    public boolean deleteFile(File webAppFile, JettyDeployTarget deployTarget) {
        return this.myTransportDelegate.deleteFile(deployTarget.getRemoteTargetName(), webAppFile);
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new JettyRemoteEditor();
    }

    public String prepareDeployment(String sourcePath) throws RuntimeConfigurationException {
        return this.myTransportDelegate.prepareDeployment(STAGING_TARGET_NAME, sourcePath, false);
    }

    @Override
    protected Class<JettyRemoteModelData> getDataClass() {
        return JettyRemoteModelData.class;
    }

    @Override
    protected JettyRemoteModelData createData() {
        return new JettyRemoteModelData();
    }

    @Override
    protected void readFromData(JettyRemoteModelData settings) {
        this.myTransportDelegate.readFromData((MultiTargetRemoteServerModelData)settings);
    }

    @Override
    protected void writeToData(JettyRemoteModelData settings) {
        this.myTransportDelegate.writeToData((MultiTargetRemoteServerModelData)settings);
    }

    public Object clone() throws CloneNotSupportedException {
        JettyRemoteModel result = (JettyRemoteModel)((Object)super.clone());
        result.myTransportDelegate = STAGING_PROVIDER.initModelDelegate((MultiTargetRemoteServerModelDelegate)this.myTransportDelegate.clone(), (MultiTargetRemoteServerModel)result);
        return result;
    }

    @Tag(value="data")
    public static class JettyRemoteModelData
    extends MultiTargetRemoteServerModelData
    implements JettyModelData {
        @Tag(value="jndi-port")
        private int myJndiPort = 1099;

        @Override
        public int getJndiPort() {
            return this.myJndiPort;
        }

        @Override
        public void setJndiPort(int jndiPort) {
            this.myJndiPort = jndiPort;
        }
    }
}

