/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.admin;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.admin.jmx.JavaeeJmxAdminServerBase;
import com.intellij.javaee.oss.admin.jmx.JmxAdminException;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentMethod;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentModel;
import com.intellij.javaee.oss.jetty.server.JettyIntegration;
import com.intellij.javaee.oss.jetty.server.JettyServerModel;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.oss.util.AbstractConnectorCommand;
import com.intellij.openapi.util.Ref;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JettyAdminServerImpl
extends JavaeeJmxAdminServerBase {
    private final JettyVersionHandler myVersionHandler;
    private final String myJmxUsername;
    private final String myJmxPassword;

    public JettyAdminServerImpl(@NotNull JettyVersionHandler versionHandler, @Nullable String jmxUsername, @Nullable String jmxPassword) {
        if (versionHandler == null) {
            JettyAdminServerImpl.$$$reportNull$$$0(0);
        }
        this.myVersionHandler = versionHandler;
        this.myJmxUsername = jmxUsername;
        this.myJmxPassword = jmxPassword;
    }

    protected JavaeeJmxAdminServerBase.JmxAdminCommandBase<Boolean> createConnectCommand() {
        return new JavaeeJmxAdminServerBase.JmxAdminCommandBase<Boolean>(){

            protected Boolean doExecute(MBeanServerConnection connection) throws JMException, IOException {
                return JettyAdminServerImpl.this.myVersionHandler.isStarted(connection);
            }

            @Nullable
            protected String getJmxUsername() {
                return JettyAdminServerImpl.this.myJmxUsername;
            }

            @Nullable
            protected String getJmxPassword() {
                return JettyAdminServerImpl.this.myJmxPassword;
            }
        };
    }

    private static JettyDeploymentMethod getDeploymentMethod(DeploymentModel deployment) {
        JettyDeploymentMethod result = (JettyDeploymentMethod)deployment.getDeploymentMethod();
        if (result == null) {
            result = JettyIntegration.DEFAULT_DEPLOYMENT_METHOD;
        }
        return result;
    }

    private static JettyServerModel getServerModel(DeploymentModel deployment) {
        return (JettyServerModel)deployment.getServerModel();
    }

    protected boolean isUndeploySyncNeeded() {
        return false;
    }

    protected boolean doDeploy(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        try {
            DeploymentModel deployment = context.getDeploymentModel();
            return JettyAdminServerImpl.getDeploymentMethod(deployment).deploy(deployment, context.getSource(), JettyAdminServerImpl.getServerModel(deployment));
        }
        catch (IOException e) {
            throw new JmxAdminException((Exception)e);
        }
        catch (RuntimeConfigurationException e) {
            throw new JmxAdminException((Exception)((Object)e));
        }
    }

    protected boolean doUndeploy(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        new DeployCommandBase(context){

            @Override
            protected void processWebAppInstance(MBeanServerConnection connection, ObjectName objectName) throws JMException, IOException {
                AbstractConnectorCommand.invokeOperation((MBeanServerConnection)connection, (ObjectName)objectName, (String)"stop", (Object[])new Object[0]);
            }
        }.adminExecute();
        DeploymentModel deployment = context.getDeploymentModel();
        return JettyAdminServerImpl.getDeploymentMethod(deployment).undeploy(deployment, context.getSource(), JettyAdminServerImpl.getServerModel(deployment));
    }

    protected DeploymentStatus doGetDeploymentStatus(JavaeeJmxAdminServerBase.DeploymentContext context) throws JmxAdminException {
        final Ref statusRef = new Ref((Object)DeploymentStatus.NOT_DEPLOYED);
        new DeployCommandBase(context){

            @Override
            protected void processWebAppInstance(MBeanServerConnection connection, ObjectName objectName) throws JMException, IOException {
                DeploymentStatus state = JettyAdminServerImpl.this.myVersionHandler.getDeploymentStatus(connection, objectName);
                if (state != DeploymentStatus.NOT_DEPLOYED) {
                    statusRef.set((Object)state);
                }
            }
        }.adminExecute();
        return (DeploymentStatus)statusRef.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionHandler", "com/intellij/javaee/oss/jetty/admin/JettyAdminServerImpl", "<init>"));
    }

    private abstract class DeployCommandBase
    extends JavaeeJmxAdminServerBase.JmxAdminCommandBase {
        private final JavaeeJmxAdminServerBase.DeploymentContext myContext;

        public DeployCommandBase(JavaeeJmxAdminServerBase.DeploymentContext context) {
            super((JavaeeJmxAdminServerBase)JettyAdminServerImpl.this);
            this.myContext = context;
        }

        @Nullable
        protected Object doExecute(MBeanServerConnection connection) throws JMException, IOException {
            String[] objectNameTexts;
            for (String objectNameText : objectNameTexts = JettyAdminServerImpl.this.myVersionHandler.getWebAppObjectNames((JettyDeploymentModel)this.myContext.getDeploymentModel(), this.myContext.getSource())) {
                ObjectName webAppObjectName = AbstractConnectorCommand.createObjectName((String)objectNameText);
                for (ObjectName webAppInstanceName : connection.queryNames(webAppObjectName, null)) {
                    this.processWebAppInstance(connection, webAppInstanceName);
                }
            }
            return null;
        }

        protected abstract void processWebAppInstance(MBeanServerConnection var1, ObjectName var2) throws JMException, IOException;

        @Nullable
        protected String getJmxUsername() {
            return JettyAdminServerImpl.this.myJmxUsername;
        }

        @Nullable
        protected String getJmxPassword() {
            return JettyAdminServerImpl.this.myJmxPassword;
        }
    }
}

