/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.sql;

import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.sql.TextFileFragment;
import org.jetbrains.dekaf.util.Collects;

abstract class ScriptumResource {
    protected TextFileFragment[] myFragments = null;
    protected Map<String, TextFileFragment> myFragmentsMap = null;

    ScriptumResource() {
    }

    @NotNull
    protected abstract TextFileFragment[] loadFragments();

    protected void loadIfNeeded() {
        if (this.myFragments == null) {
            this.myFragments = this.loadFragments();
            this.myFragmentsMap = new TreeMap<String, TextFileFragment>(String.CASE_INSENSITIVE_ORDER);
            for (TextFileFragment fragment : this.myFragments) {
                if (fragment.getFragmentName() == null) continue;
                this.myFragmentsMap.put(fragment.getFragmentName(), fragment);
            }
        }
    }

    @NotNull
    TextFileFragment get(@NotNull String name) {
        TextFileFragment fragment = this.find(name);
        if (fragment == null) {
            if (this.myFragmentsMap == null) {
                throw new IllegalStateException("The scriptum resource is not loaded yet.");
            }
            String msg = "No such fragment with name: " + name + '\n' + Collects.collectionToString(this.myFragmentsMap.keySet(), ", ", "There are fragments: ", ".", "This resource is empty");
            throw new IllegalArgumentException(msg);
        }
        return fragment;
    }

    @Nullable
    TextFileFragment find(@NotNull String name) {
        this.loadIfNeeded();
        return this.myFragmentsMap.get(name);
    }

    @NotNull
    String[] getExistentNames() {
        this.loadIfNeeded();
        int n = this.myFragments.length;
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            names[i] = this.myFragments[i].getFragmentName();
        }
        return names;
    }

    int count() {
        this.loadIfNeeded();
        return this.myFragments.length;
    }
}

