/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.SybaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.SybaseIntermediateFacade;

public class SybaseIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final SybaseIntermediateProvider INSTANCE = new SybaseIntermediateProvider();
    static final Pattern SYBASE_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:(jtds:)?sybase:(Tds:)?.+$", 2);
    static final String SYBASE_JTDS_CONNECTION_STRING_EXAMPLE = "jdbc:jtds:sybase://localhost/Testing";
    static final String SYBASE_NATIVE_CONNECTION_STRING_EXAMPLE = "jdbc:sybase:Tds://";
    private static final String SYBASE_JTDS_DRIVER_CLASS_NAME = "net.sourceforge.jtds.jdbc.Driver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return SYBASE_JTDS_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver() {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(SYBASE_JTDS_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("Sybase Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Sybase.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return SYBASE_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected SybaseIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        Properties properties = new Properties(connectionProperties);
        properties.setProperty("GET_BY_NAME_USES_COLUMN_LABEL", "true");
        return new SybaseIntermediateFacade(connectionString, properties, driver, connectionsLimit, SybaseExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return SybaseExceptionRecognizer.INSTANCE;
    }
}

