/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Exasol;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.ExasolExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.ExasolIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;

public class ExasolIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final ExasolIntermediateProvider INSTANCE = new ExasolIntermediateProvider();
    static final Pattern EXASOL_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:exa:.+$");
    static final String EXASOL_CONNECTION_STRING_EXAMPLE = "jdbc:exa:localhost:8888";
    private static final String EXASOL_DRIVER_CLASS_NAME = "com.exasol.jdbc.EXADriver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return EXASOL_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver() {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(EXASOL_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("Exasol SQL Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Exasol.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return EXASOL_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected ExasolIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new ExasolIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, ExasolExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return ExasolExceptionRecognizer.INSTANCE;
    }
}

