/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexResourceBuildTargetType;
import com.intellij.flex.build.FlexSourceRootDescriptor;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import gnu.trove.THashSet;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class FlexResourceBuildTarget
extends ModuleBasedTarget<BuildRootDescriptor> {
    FlexResourceBuildTarget(FlexResourceBuildTargetType type, @NotNull JpsTypedModule<JpsFlexBuildConfigurationManager> module) {
        if (module == null) {
            FlexResourceBuildTarget.$$$reportNull$$$0(0);
        }
        super((ModuleBasedBuildTargetType)type, module);
    }

    public String getId() {
        return this.getModule().getName();
    }

    @NotNull
    public JpsTypedModule<JpsFlexBuildConfigurationManager> getModule() {
        JpsTypedModule jpsTypedModule = (JpsTypedModule)super.getModule();
        if (jpsTypedModule == null) {
            FlexResourceBuildTarget.$$$reportNull$$$0(1);
        }
        return jpsTypedModule;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        return Collections.emptyList();
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        JavaSourceRootType rootType = this.getTargetType() == FlexResourceBuildTargetType.PRODUCTION ? JavaSourceRootType.SOURCE : JavaSourceRootType.TEST_SOURCE;
        for (JpsModuleSourceRoot sourceRoot : this.getModule().getSourceRoots((JpsModuleSourceRootType)rootType)) {
            File root = JpsPathUtil.urlToFile((String)sourceRoot.getUrl());
            result.add((BuildRootDescriptor)new FlexSourceRootDescriptor((BuildTarget)this, root));
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            FlexResourceBuildTarget.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public boolean isTests() {
        return ((FlexResourceBuildTargetType)this.getTargetType()).isTests();
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (BuildRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getTargetType().getTypeId() + ":" + this.getModule().getName();
        if (string == null) {
            FlexResourceBuildTarget.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        if (this.getTargetType() == FlexResourceBuildTargetType.TEST) {
            File outputDir = ProjectPaths.getModuleOutputDir(this.getModule(), (boolean)true);
            List<Object> list = outputDir == null ? Collections.emptyList() : Collections.singletonList(outputDir);
            if (list == null) {
                FlexResourceBuildTarget.$$$reportNull$$$0(4);
            }
            return list;
        }
        THashSet result = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (JpsFlexBuildConfiguration bc : ((JpsFlexBuildConfigurationManager)this.getModule().getProperties()).getBuildConfigurations()) {
            if (!FlexCommonUtils.canHaveResourceFiles(bc.getNature())) continue;
            result.add(new File(PathUtilRt.getParentPath((String)bc.getActualOutputFilePath())));
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            FlexResourceBuildTarget.$$$reportNull$$$0(5);
        }
        return tHashSet;
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        out.println("Module: " + this.getModule().getName());
        for (JpsFlexBuildConfiguration bc : ((JpsFlexBuildConfigurationManager)this.getModule().getProperties()).getBuildConfigurations()) {
            JpsJavaCompilerConfiguration c;
            if (bc.isSkipCompile() || !FlexCommonUtils.canHaveResourceFiles(bc.getNature()) || bc.getCompilerOptions().getResourceFilesMode() == JpsFlexCompilerOptions.ResourceFilesMode.None) continue;
            out.print("BC: " + bc.getName());
            out.print(", output folder: " + PathUtilRt.getParentPath((String)bc.getActualOutputFilePath()));
            out.print(", mode: " + (Object)((Object)bc.getCompilerOptions().getResourceFilesMode()));
            if (bc.getCompilerOptions().getResourceFilesMode() == JpsFlexCompilerOptions.ResourceFilesMode.ResourcePatterns && (c = JpsJavaExtensionService.getInstance().getCompilerConfiguration(this.getModule().getProject())) != null) {
                out.print(", patterns: " + StringUtil.join((Collection)c.getResourcePatterns(), (String)" "));
            }
            out.println();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/flex/build/FlexResourceBuildTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/flex/build/FlexResourceBuildTarget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

