/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.flex.FlexCommonBundle;
import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexBuildTargetType;
import com.intellij.flex.build.FlexResourceBuildTarget;
import com.intellij.flex.build.FlexResourceBuildTargetType;
import com.intellij.flex.build.FlexSourceRootDescriptor;
import com.intellij.flex.model.JpsFlexProjectLevelCompilerOptionsExtension;
import com.intellij.flex.model.bc.BuildConfigurationNature;
import com.intellij.flex.model.bc.JpsAirPackagingOptions;
import com.intellij.flex.model.bc.JpsFlexBCDependencyEntry;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexDependencyEntry;
import com.intellij.flex.model.bc.JpsFlexModuleOrProjectCompilerOptions;
import com.intellij.flex.model.bc.JpsLibraryDependencyEntry;
import com.intellij.flex.model.bc.impl.JpsFlexBCState;
import com.intellij.flex.model.bc.impl.JpsFlexCompilerOptionsImpl;
import com.intellij.flex.model.run.JpsBCBasedRunnerParameters;
import com.intellij.flex.model.run.JpsFlashRunConfigurationType;
import com.intellij.flex.model.run.JpsFlexUnitRunConfigurationType;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.runConfiguration.JpsRunConfigurationType;
import org.jetbrains.jps.model.runConfiguration.JpsTypedRunConfiguration;
import org.jetbrains.jps.util.JpsPathUtil;

public class FlexBuildTarget
extends BuildTarget<BuildRootDescriptor> {
    @NotNull
    private final JpsFlexBuildConfiguration myBC;
    @NotNull
    private final String myId;

    private FlexBuildTarget(@NotNull JpsFlexBuildConfiguration bc, @NotNull String id) {
        if (bc == null) {
            FlexBuildTarget.$$$reportNull$$$0(0);
        }
        if (id == null) {
            FlexBuildTarget.$$$reportNull$$$0(1);
        }
        super((BuildTargetType)FlexBuildTargetType.INSTANCE);
        this.myBC = bc;
        this.myId = id;
    }

    @NotNull
    public static FlexBuildTarget create(@NotNull JpsFlexBuildConfiguration bc, @Nullable Boolean forcedDebugStatus) {
        if (bc == null) {
            FlexBuildTarget.$$$reportNull$$$0(2);
        }
        String id = FlexCommonUtils.getBuildTargetId(bc.getModule().getName(), bc.getName(), forcedDebugStatus);
        if (forcedDebugStatus == null) {
            FlexBuildTarget flexBuildTarget = new FlexBuildTarget(bc, id);
            if (flexBuildTarget == null) {
                FlexBuildTarget.$$$reportNull$$$0(3);
            }
            return flexBuildTarget;
        }
        JpsFlexBuildConfiguration bcCopy = ((JpsFlexBuildConfigurationManager)bc.getModule().getProperties()).createCopy(bc);
        String additionalOptions = FlexCommonUtils.removeOptions(bc.getCompilerOptions().getAdditionalOptions(), "debug", "compiler.debug");
        bcCopy.getCompilerOptions().setAdditionalOptions(additionalOptions + " -debug=" + forcedDebugStatus.toString());
        FlexBuildTarget flexBuildTarget = new FlexBuildTarget(bcCopy, id);
        if (flexBuildTarget == null) {
            FlexBuildTarget.$$$reportNull$$$0(4);
        }
        return flexBuildTarget;
    }

    @Nullable
    public static FlexBuildTarget create(JpsProject project, @NotNull JpsRunConfigurationType<? extends JpsBCBasedRunnerParameters<?>> runConfigType, @NotNull String runConfigName) {
        if (runConfigType == null) {
            FlexBuildTarget.$$$reportNull$$$0(5);
        }
        if (runConfigName == null) {
            FlexBuildTarget.$$$reportNull$$$0(6);
        }
        assert (runConfigType instanceof JpsFlashRunConfigurationType || runConfigType instanceof JpsFlexUnitRunConfigurationType) : runConfigType;
        String runConfigTypeId = runConfigType instanceof JpsFlashRunConfigurationType ? "FlashRunConfigurationType" : "FlexUnitRunConfigurationType";
        JpsTypedRunConfiguration<? extends JpsBCBasedRunnerParameters<?>> runConfig = FlexCommonUtils.findRunConfiguration(project, runConfigType, runConfigName);
        JpsFlexBuildConfiguration bc = runConfig == null ? null : ((JpsBCBasedRunnerParameters)runConfig.getProperties()).getBC(project);
        String id = FlexCommonUtils.getBuildTargetIdForRunConfig(runConfigTypeId, runConfigName);
        return bc == null ? null : new FlexBuildTarget(bc, id);
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            FlexBuildTarget.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public JpsFlexBuildConfiguration getBC() {
        JpsFlexBuildConfiguration jpsFlexBuildConfiguration = this.myBC;
        if (jpsFlexBuildConfiguration == null) {
            FlexBuildTarget.$$$reportNull$$$0(8);
        }
        return jpsFlexBuildConfiguration;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList();
        FlexResourceBuildTargetType type = FlexCommonUtils.isFlexUnitBC(this.myBC) ? FlexResourceBuildTargetType.TEST : FlexResourceBuildTargetType.PRODUCTION;
        result.add((BuildTarget<?>)new FlexResourceBuildTarget(type, this.myBC.getModule()));
        for (JpsFlexDependencyEntry entry : this.myBC.getDependencies().getEntries()) {
            JpsFlexBuildConfiguration dependencyBC;
            if (!(entry instanceof JpsFlexBCDependencyEntry) || (dependencyBC = ((JpsFlexBCDependencyEntry)entry).getBC()) == null) continue;
            result.add(FlexBuildTarget.create(dependencyBC, null));
        }
        result.trimToSize();
        return result;
    }

    @NotNull
    public List<BuildRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        File root;
        ArrayList<BuildRootDescriptor> result = new ArrayList<BuildRootDescriptor>();
        ArrayList<File> srcRoots = new ArrayList<File>();
        for (JpsModuleSourceRoot sourceRoot : this.myBC.getModule().getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.SOURCE)) {
            root = JpsPathUtil.urlToFile((String)sourceRoot.getUrl());
            result.add((BuildRootDescriptor)new FlexSourceRootDescriptor(this, root));
            srcRoots.add(root);
        }
        if (FlexCommonUtils.isFlexUnitBC(this.myBC)) {
            for (JpsModuleSourceRoot sourceRoot : this.myBC.getModule().getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE)) {
                root = JpsPathUtil.urlToFile((String)sourceRoot.getUrl());
                result.add((BuildRootDescriptor)new FlexSourceRootDescriptor(this, root));
                srcRoots.add(root);
            }
        }
        for (JpsFlexDependencyEntry entry : this.myBC.getDependencies().getEntries()) {
            JpsLibrary library;
            if (entry instanceof JpsFlexBCDependencyEntry) {
                JpsFlexBuildConfiguration dependencyBC = ((JpsFlexBCDependencyEntry)entry).getBC();
                if (dependencyBC == null) continue;
                result.add((BuildRootDescriptor)new FlexSourceRootDescriptor(this, new File(dependencyBC.getActualOutputFilePath())));
                continue;
            }
            if (!(entry instanceof JpsLibraryDependencyEntry) || (library = ((JpsLibraryDependencyEntry)entry).getLibrary()) == null) continue;
            for (String rootUrl : library.getRootUrls(JpsOrderRootType.COMPILED)) {
                result.add((BuildRootDescriptor)new FlexSourceRootDescriptor(this, JpsPathUtil.urlToFile((String)rootUrl)));
            }
        }
        BuildConfigurationNature nature = this.myBC.getNature();
        if (nature.isWebPlatform() && nature.isApp() && this.myBC.isUseHtmlWrapper() && !this.myBC.getWrapperTemplatePath().isEmpty()) {
            this.addIfNotUnderRoot(result, new File(this.myBC.getWrapperTemplatePath()), srcRoots);
        }
        if (FlexCommonUtils.canHaveRLMsAndRuntimeStylesheets(this.myBC)) {
            for (String cssPath : this.myBC.getCssFilesToCompile()) {
                if (cssPath.isEmpty()) continue;
                this.addIfNotUnderRoot(result, new File(cssPath), srcRoots);
            }
        }
        if (!this.myBC.getCompilerOptions().getAdditionalConfigFilePath().isEmpty()) {
            this.addIfNotUnderRoot(result, new File(this.myBC.getCompilerOptions().getAdditionalConfigFilePath()), srcRoots);
        }
        if (nature.isApp()) {
            if (nature.isDesktopPlatform()) {
                this.addAirDescriptorPathIfCustom(result, this.myBC.getAirDesktopPackagingOptions(), srcRoots);
            } else if (nature.isMobilePlatform()) {
                if (this.myBC.getAndroidPackagingOptions().isEnabled()) {
                    this.addAirDescriptorPathIfCustom(result, this.myBC.getAndroidPackagingOptions(), srcRoots);
                }
                if (this.myBC.getIosPackagingOptions().isEnabled()) {
                    this.addAirDescriptorPathIfCustom(result, this.myBC.getIosPackagingOptions(), srcRoots);
                }
            }
        }
        ArrayList<BuildRootDescriptor> arrayList = result;
        if (arrayList == null) {
            FlexBuildTarget.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private void addIfNotUnderRoot(List<BuildRootDescriptor> descriptors, File file, Collection<File> roots) {
        for (File root : roots) {
            if (!FileUtil.isAncestor((File)root, (File)file, (boolean)false)) continue;
            return;
        }
        descriptors.add((BuildRootDescriptor)new FlexSourceRootDescriptor(this, file));
    }

    private void addAirDescriptorPathIfCustom(List<BuildRootDescriptor> descriptors, JpsAirPackagingOptions packagingOptions, Collection<File> srcRoots) {
        if (!packagingOptions.isUseGeneratedDescriptor() && !packagingOptions.getCustomDescriptorPath().isEmpty()) {
            this.addIfNotUnderRoot(descriptors, new File(packagingOptions.getCustomDescriptorPath()), srcRoots);
        }
    }

    @Nullable
    public BuildRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (BuildRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        String string = FlexCommonBundle.message("bc.0.module.1", this.myBC.getName(), this.myBC.getModule().getName());
        if (string == null) {
            FlexBuildTarget.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        Set<File> set = Collections.singleton(new File(PathUtilRt.getParentPath((String)this.myBC.getActualOutputFilePath())));
        if (set == null) {
            FlexBuildTarget.$$$reportNull$$$0(11);
        }
        return set;
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
        out.println("id: " + this.myId);
        out.println(JDOMUtil.writeElement((Element)XmlSerializer.serialize((Object)JpsFlexBCState.getState(this.myBC))));
        JpsFlexModuleOrProjectCompilerOptions moduleOptions = ((JpsFlexBuildConfigurationManager)this.myBC.getModule().getProperties()).getModuleLevelCompilerOptions();
        out.println(JDOMUtil.writeElement((Element)XmlSerializer.serialize((Object)((JpsFlexCompilerOptionsImpl)moduleOptions).getState())));
        JpsFlexModuleOrProjectCompilerOptions projectOptions = JpsFlexProjectLevelCompilerOptionsExtension.getProjectLevelCompilerOptions(this.myBC.getModule().getProject());
        out.println(JDOMUtil.writeElement((Element)XmlSerializer.serialize((Object)((JpsFlexCompilerOptionsImpl)projectOptions).getState())));
    }

    public String toString() {
        return this.myId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FlexBuildTarget target = (FlexBuildTarget)((Object)o);
        return this.myId.equals(target.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bc";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/flex/build/FlexBuildTarget";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/flex/build/FlexBuildTarget";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBC";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

