/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.header.Attrs;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.libg.cryptography.SHA256;
import java.io.File;
import java.util.ArrayList;
import org.osgi.resource.Resource;

public class WorkspaceResourcesRepository
extends ResourcesRepository {
    public static final String WORKSPACE_NAMESPACE = "bnd.workspace.project";

    public WorkspaceResourcesRepository(Workspace workspace) throws Exception {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Project p : workspace.getAllProjects()) {
            File[] files = p.getBuildFiles(false);
            if (files == null) continue;
            for (File file : files) {
                Domain manifest = Domain.domain((File)file);
                ResourceBuilder rb = new ResourceBuilder();
                rb.addManifest(manifest);
                Attrs attrs = new Attrs();
                attrs.put("url", file.toURI().toString());
                attrs.putTyped("size", (Object)file.length());
                attrs.put("osgi.content", SHA256.digest(file).asHex());
                rb.addCapability(CapabilityBuilder.createCapReqBuilder((String)"osgi.content", (Attrs)attrs));
                attrs = new Attrs();
                attrs.put(WORKSPACE_NAMESPACE, p.getName());
                rb.addCapability(CapabilityBuilder.createCapReqBuilder((String)WORKSPACE_NAMESPACE, (Attrs)attrs));
                Resource resource = rb.build();
                resources.add(resource);
            }
        }
        this.addAll(resources);
    }

    public String toString() {
        return "Workspace";
    }
}

