/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.deployer.repository.FixedIndexedRepo;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResolutionDirective;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.Registry;
import aQute.lib.strings.Strings;
import aQute.service.reporter.Reporter;
import biz.aQute.resolve.BndrunResolveContext;
import biz.aQute.resolve.LogReporter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolverImpl;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.repository.Repository;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.Resolver;

public class ResolverValidator
extends Processor {
    LogReporter reporter = new LogReporter((Reporter)this);
    Resolver resolver = new ResolverImpl((Logger)this.reporter, null);
    List<URI> repositories = new ArrayList<URI>();
    Resource system = null;

    public ResolverValidator(Processor parent) throws Exception {
        super(parent);
    }

    public ResolverValidator() {
    }

    public void addRepository(URI url) throws Exception {
        this.repositories.add(url);
    }

    public void setSystem(Resource resource) throws Exception {
        assert (resource != null);
        this.system = resource;
    }

    public List<Resolution> validate() throws Exception {
        FixedIndexedRepo repository = this.getRepository();
        Set<Resource> resources = ResolverValidator.getAllResources((Repository)repository);
        return this.validateResources((Repository)repository, resources);
    }

    public List<Resolution> validate(Collection<Resource> toBeChecked) throws Exception {
        LinkedHashSet<Resource> allResources = new LinkedHashSet<Resource>();
        for (URI uri : this.repositories) {
            allResources.addAll(XMLResourceParser.getResources((URI)uri));
        }
        allResources.addAll(toBeChecked);
        ResourcesRepository repository = new ResourcesRepository(allResources);
        return this.validateResources((Repository)repository, toBeChecked);
    }

    FixedIndexedRepo getRepository() throws MalformedURLException, URISyntaxException {
        FixedIndexedRepo repository = new FixedIndexedRepo();
        repository.setLocations(Strings.join(this.repositories));
        return repository;
    }

    public List<Resolution> validateResources(Repository repository, Collection<Resource> resources) throws Exception {
        this.setProperty("-runfw", "dummy");
        ArrayList<Resolution> result = new ArrayList<Resolution>();
        ArrayList<Resource> resourceList = new ArrayList<Resource>(resources);
        while (!resourceList.isEmpty()) {
            Resource resource = (Resource)resourceList.remove(0);
            Resolution resolution = this.resolve(repository, resource);
            result.add(resolution);
            for (Resource resolved : resolution.resolved) {
                if (!resourceList.remove(resolved)) continue;
                Resolution curResolution = new Resolution();
                curResolution.resource = resolved;
                curResolution.succeeded = true;
                result.add(curResolution);
            }
        }
        return result;
    }

    public static Set<Resource> getAllResources(Repository repository) {
        Requirement r = ResourceUtils.createWildcardRequirement();
        Map providers = repository.findProviders(Collections.singleton(r));
        Set resources = ResourceUtils.getResources((Collection)((Collection)providers.get(r)));
        return resources;
    }

    private BndrunResolveContext getResolveContext() throws Exception {
        BndrunResolveContext context = new BndrunResolveContext(this, null, (Registry)this, this.reporter){

            @Override
            void loadFramework(ResourceBuilder systemBuilder) throws Exception {
                systemBuilder.addCapabilities(ResolverValidator.this.system.getCapabilities(null));
            }
        };
        return context;
    }

    public Requirement getIdentity(Resource resource) {
        ResourceUtils.IdentityCapability identityCapability = ResourceUtils.getIdentityCapability((Resource)resource);
        return CapReqBuilder.createRequirementFromCapability((Capability)identityCapability).buildSyntheticRequirement();
    }

    public Resolution resolve(Repository repository, Resource resource) throws Exception {
        Resolution resolution = new Resolution();
        Requirement identity = this.getIdentity(resource);
        this.setProperty("-runrequires", ResourceUtils.toRequireCapability((Requirement)identity));
        BndrunResolveContext context = this.getResolveContext();
        context.addRepository(repository);
        context.init();
        resolution.resource = resource;
        try {
            Map<Resource, List<Wire>> resolve2 = this.resolver.resolve(context);
            resolution.succeeded = true;
            resolution.resolved = resolve2.keySet();
            this.trace("resolving %s succeeded", new Object[]{resource});
        }
        catch (ResolutionException e) {
            this.trace("resolving %s failed", new Object[]{resource});
            resolution.succeeded = false;
            resolution.message = e.getMessage();
            for (Requirement req : e.getUnresolvedRequirements()) {
                this.trace("    missing %s", new Object[]{req});
                resolution.unresolved.add(req);
            }
            ResourcesRepository systemRepository = new ResourcesRepository(this.system);
            for (Requirement r : resource.getRequirements(null)) {
                Collection caps = systemRepository.findProvider(r);
                boolean missing = caps.isEmpty();
                if (missing) {
                    Set<Requirement> requirements = Collections.singleton(r);
                    caps = (Collection)repository.findProviders(requirements).get(r);
                    missing = caps.isEmpty();
                    if (missing) {
                        if (ResourceUtils.getResolution((Requirement)r) == ResolutionDirective.optional) {
                            resolution.optionals.add(r);
                            continue;
                        }
                        resolution.missing.add(r);
                        continue;
                    }
                    this.trace("     found %s in repo", new Object[]{r});
                    resolution.repos.add(r);
                    continue;
                }
                this.trace("     found %s in system", new Object[]{r});
                resolution.system.add(r);
            }
            this.error("resolving %s failed with %s", new Object[]{resource, resolution.message});
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error("resolving %s failed with %s", new Object[]{context.getInputResource().getRequirements(null), e});
            resolution.message = e.getMessage();
        }
        return resolution;
    }

    public static class Resolution {
        public Resource resource;
        public boolean succeeded;
        public String message;
        public Set<Resource> resolved = new LinkedHashSet<Resource>();
        public List<Requirement> system = new ArrayList<Requirement>();
        public List<Requirement> repos = new ArrayList<Requirement>();
        public List<Requirement> missing = new ArrayList<Requirement>();
        public List<Requirement> optionals = new ArrayList<Requirement>();
        public List<Requirement> unresolved = new ArrayList<Requirement>();
    }
}

