/*
 * Decompiled with CFR 0.152.
 */
package biz.aQute.resolve;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.bnd.build.model.BndEditModel;
import aQute.bnd.build.model.EE;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.AggregateRepository;
import aQute.bnd.osgi.repository.AugmentRepository;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.RequirementBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.service.Registry;
import aQute.bnd.service.Strategy;
import aQute.bnd.service.resolve.hook.ResolverHook;
import aQute.lib.converter.Converter;
import biz.aQute.resolve.AbstractResolveContext;
import biz.aQute.resolve.ResolutionCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.log.LogService;
import org.osgi.service.repository.Repository;

public class BndrunResolveContext
extends AbstractResolveContext {
    private static final String BND_AUGMENT = "bnd.augment";
    public static final String RUN_EFFECTIVE_INSTRUCTION = "-resolve.effective";
    public static final String PROP_RESOLVE_PREFERENCES = "-resolve.preferences";
    private Registry registry;
    private Parameters resolvePrefs;
    private final Processor properties;
    private Project project;
    private boolean initialized;

    @Deprecated
    public BndrunResolveContext(BndEditModel runModel, Registry registry, LogService log) {
        super(log);
        try {
            this.registry = registry;
            this.properties = runModel.getProperties();
            this.project = runModel.getProject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BndrunResolveContext(Processor runModel, Project project, Registry registry, LogService log) {
        super(log);
        try {
            this.registry = registry;
            this.properties = runModel;
            this.project = project;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        try {
            Integer level;
            if (this.getLevel() <= 0 && (level = Converter.cnv(Integer.class, (Object)this.properties.getProperty("-resolvedebug", "0"))) != null) {
                this.setLevel(level);
            }
            this.loadPreferences();
            Processor augments = this.loadRepositories();
            this.constructBlacklist(augments);
            Map<String, Set<String>> effectiveSet = this.loadEffectiveSet();
            if (effectiveSet != null) {
                this.addEffectiveSet(effectiveSet);
            }
            this.setInputResource(this.constructInputRequirements());
            ResourceBuilder system = new ResourceBuilder();
            String distro = this.properties.mergeProperties("-distro");
            if (distro != null && !distro.trim().isEmpty()) {
                this.loadPath(system, distro, "-distro");
            } else {
                EE tmp = EE.parse((String)this.properties.getProperty("-runee"));
                EE ee = tmp != null ? tmp : EE.JavaSE_1_6;
                system.addAllExecutionEnvironments(ee);
                Parameters systemPackages = new Parameters(this.properties.mergeProperties("-runsystempackages"));
                system.addExportPackages(systemPackages);
                Parameters systemCapabilities = new Parameters(this.properties.mergeProperties("-runsystemcapabilities"));
                system.addProvideCapabilities(systemCapabilities);
                Parameters providedCapabilities = new Parameters(this.properties.mergeProperties("-runprovidedcapabilities"));
                system.addProvideCapabilities(providedCapabilities);
                this.loadFramework(system);
                String runpath = this.properties.mergeProperties("-runpath");
                if (runpath != null && !runpath.trim().isEmpty()) {
                    this.loadPath(system, runpath, "-runpath");
                }
            }
            List frameworkPackages = system.findCapabilities("osgi.wiring.package", "(osgi.wiring.package=org.osgi.framework)");
            if (!frameworkPackages.isEmpty()) {
                Capability c = (Capability)frameworkPackages.get(0);
                Version version = (Version)c.getAttributes().get("version");
                CapReqBuilder crb = new CapReqBuilder("osgi.identity");
                crb.addAttribute("osgi.identity", (Object)"system.bundle");
                crb.addAttribute("version", (Object)version);
                system.addCapability(crb);
            }
            this.setSystemResource(system.build());
        }
        catch (Exception e) {
            this.log.log(1, e.getMessage(), e);
            throw new RuntimeException(e);
        }
        super.init();
    }

    void loadFramework(ResourceBuilder system) throws Exception {
        Parameters parameters = new Parameters(this.properties.getProperty("-runfw"));
        if (parameters.isEmpty()) {
            this.log.log(2, "No -runfw set");
            return;
        }
        if (parameters.size() > 1) {
            throw new IllegalArgumentException("Too many frameworks specified in -runfw (" + parameters + ")");
        }
        Map.Entry bsn = (Map.Entry)parameters.entrySet().iterator().next();
        String name = (String)bsn.getKey();
        String version = ((Attrs)bsn.getValue()).getVersion();
        this.log.log(3, "Using frameowork " + name + ";" + version);
        if ("none".equals(name)) {
            return;
        }
        Resource framework = this.getHighestResource(name, version);
        if (framework == null) {
            this.log.log(1, "Cannot find framework " + name + ";" + version);
        } else {
            super.setFramework(system, framework);
        }
    }

    @Override
    public void loadPath(ResourceBuilder system, String path, String what) throws Exception {
        if (this.project != null) {
            List containers = Container.flatten((Collection)this.project.getBundles(Strategy.HIGHEST, path, what));
            for (Container c : containers) {
                Manifest manifest = c.getManifest();
                if (manifest == null) continue;
                ResourceBuilder rb = new ResourceBuilder();
                rb.addManifest(Domain.domain((Manifest)manifest));
                this.addSystemResource(system, rb.build());
            }
        } else {
            super.loadPath(system, path, what);
        }
    }

    Map<String, Set<String>> loadEffectiveSet() {
        String effective = this.properties.getProperty(RUN_EFFECTIVE_INSTRUCTION);
        if (effective == null) {
            return null;
        }
        HashMap<String, Set<String>> effectiveSet = new HashMap<String, Set<String>>();
        for (Map.Entry entry : new Parameters(effective).entrySet()) {
            String skip = ((Attrs)entry.getValue()).get("skip:");
            HashSet toSkip = skip == null ? new HashSet() : new HashSet<String>(Arrays.asList(skip.split(",")));
            effectiveSet.put((String)entry.getKey(), toSkip);
        }
        return effectiveSet;
    }

    private Processor loadRepositories() throws Exception {
        Collection<Object> orderedRepositories;
        ArrayList allRepos = this.registry.getPlugins(Repository.class);
        String rn = this.properties.mergeProperties("-runrepos");
        if (rn == null) {
            orderedRepositories = allRepos;
        } else {
            Parameters repoNames = new Parameters(rn);
            HashMap<String, Repository> repoNameMap = new HashMap<String, Repository>(allRepos.size());
            for (Repository repository : allRepos) {
                repoNameMap.put(repository.toString(), repository);
            }
            orderedRepositories = new ArrayList();
            for (String string : repoNames.keySet()) {
                Repository repo = (Repository)repoNameMap.get(string);
                if (repo == null) continue;
                orderedRepositories.add(repo);
            }
        }
        Processor repositoryAugments = this.findRepositoryAugments((Collection<Repository>)orderedRepositories);
        Parameters augments = new Parameters(repositoryAugments.mergeProperties("-augment"));
        augments.putAll((Map)new Parameters(this.properties.mergeProperties("-augment")));
        if (!augments.isEmpty()) {
            AggregateRepository aggregate = new AggregateRepository(orderedRepositories);
            AugmentRepository augmentRepository = new AugmentRepository(augments, (Repository)aggregate);
            orderedRepositories = Collections.singleton(augmentRepository);
        }
        for (Repository repository : orderedRepositories) {
            super.addRepository(repository);
        }
        return repositoryAugments;
    }

    private Processor findRepositoryAugments(Collection<Repository> orderedRepositories) {
        Processor main = new Processor();
        RequirementBuilder rb = new RequirementBuilder(BND_AUGMENT);
        rb.filter((CharSequence)"(path=*)");
        Requirement req = rb.buildSyntheticRequirement();
        for (Repository r : orderedRepositories) {
            Map found = r.findProviders(Collections.singleton(req));
            Collection capabilities = (Collection)found.get(req);
            if (capabilities == null) continue;
            for (Capability capability : capabilities) {
                this.findAdditionalAugmentsFromResource(main, capability);
            }
        }
        return main;
    }

    /*
     * Exception decompiling
     */
    private void findAdditionalAugmentsFromResource(Processor augments, Capability capability) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isSystemResource(Resource resource) {
        Resource systemResource = this.getSystemResource();
        return resource == systemResource;
    }

    Resource constructInputRequirements() throws Exception {
        ResourceBuilder resBuilder = new ResourceBuilder();
        CapReqBuilder identity = new CapReqBuilder("osgi.identity").addAttribute("osgi.identity", (Object)"<<INITIAL>>");
        resBuilder.addCapability(identity);
        Parameters inputRequirements = new Parameters(this.properties.mergeProperties("-runrequires"));
        if (inputRequirements != null && !inputRequirements.isEmpty()) {
            List requires = CapReqBuilder.getRequirementsFrom((Parameters)inputRequirements);
            resBuilder.addRequirements(requires);
        }
        return resBuilder.build();
    }

    private void constructBlacklist(Processor augments) throws Exception {
        Parameters blacklist = new Parameters(augments.mergeProperties("-runblacklist"));
        blacklist.putAll((Map)new Parameters(this.properties.mergeProperties("-runblacklist")));
        if (blacklist != null && !blacklist.isEmpty()) {
            List reject = CapReqBuilder.getRequirementsFrom((Parameters)blacklist);
            this.setBlackList(reject);
        }
    }

    private void loadPreferences() {
        this.resolvePrefs = new Parameters(this.properties.getProperty(PROP_RESOLVE_PREFERENCES));
    }

    @Override
    protected void postProcessProviders(Requirement requirement, Set<Capability> wired, List<Capability> candidates) {
        if (candidates.size() == 0) {
            return;
        }
        for (ResolverHook resolverHook : this.registry.getPlugins(ResolverHook.class)) {
            resolverHook.filterMatches(requirement, candidates);
        }
        boolean prefsUsed = false;
        if (this.resolvePrefs != null && !this.resolvePrefs.isEmpty()) {
            LinkedList<Capability> insertions = new LinkedList<Capability>();
            Iterator<Capability> iterator = candidates.iterator();
            while (iterator.hasNext()) {
                Capability cap = iterator.next();
                if (!this.resolvePrefs.containsKey(BndrunResolveContext.getResourceIdentity(cap.getResource()))) continue;
                iterator.remove();
                insertions.add(cap);
            }
            if (!insertions.isEmpty()) {
                candidates.addAll(0, insertions);
                prefsUsed = true;
            }
        }
        if (!prefsUsed) {
            for (ResolutionCallback callback : this.getCallbacks()) {
                callback.processCandidates(requirement, wired, candidates);
            }
        }
    }
}

