/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.jetbrains.firefox.FirefoxDeclarativeScope;
import com.jetbrains.firefox.FirefoxEvaluateContext;
import com.jetbrains.firefox.FirefoxValueManager;
import com.jetbrains.firefox.rdp.Bindings;
import com.jetbrains.firefox.rdp.Frame;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrameBase;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ObjectScope;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.rpc.CommandProcessorKt;

class FirefoxCallFrame
extends CallFrameBase {
    final String scriptUrl;
    final String scriptId;
    private final Variable thisObject;

    public FirefoxCallFrame(final @NotNull FirefoxValueManager valueManager, @NotNull Frame frame, final boolean useBindingsFromFrameData) {
        if (valueManager == null) {
            FirefoxCallFrame.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            FirefoxCallFrame.$$$reportNull$$$0(1);
        }
        super(FirefoxCallFrame.getFunctionName(frame.environment().function()), frame.where().line() - 1, frame.where().column(), (EvaluateContext)new FirefoxEvaluateContext(frame.actor(), valueManager));
        if (frame.source() == null) {
            this.scriptId = null;
            this.scriptUrl = frame.where().source().url();
        } else {
            this.scriptId = frame.source().actor();
            this.scriptUrl = null;
        }
        this.thisObject = frame.receiver() == null ? null : valueManager.createVariable("this", frame.receiver(), null);
        final Frame.Environment environment = frame.environment();
        this.setHasOnlyGlobalScope(environment.parent() == null);
        this.setScopes(new NotNullLazyValue(){

            @NotNull
            protected List<Scope> compute() {
                SmartList scopes = new SmartList();
                scopes.add(FirefoxCallFrame.createScope(environment, valueManager, true, useBindingsFromFrameData));
                Frame.Environment parent = environment;
                while ((parent = parent.parent()) != null) {
                    scopes.add(FirefoxCallFrame.createScope(parent, valueManager, false, useBindingsFromFrameData));
                }
                valueManager.promoteRecentlyAddedActorsToThreadLifetime();
                SmartList smartList = scopes;
                if (smartList == null) {
                    1.$$$reportNull$$$0(0);
                }
                return smartList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/firefox/FirefoxCallFrame$1", "compute"));
            }
        });
    }

    @NotNull
    private static Scope createScope(@NotNull Frame.Environment environment, @NotNull FirefoxValueManager valueManager, boolean local, boolean useBindingsFromFrameData) {
        ScopeType type;
        if (environment == null) {
            FirefoxCallFrame.$$$reportNull$$$0(2);
        }
        if (valueManager == null) {
            FirefoxCallFrame.$$$reportNull$$$0(3);
        }
        switch (environment.type()) {
            case OBJECT: {
                type = environment.parent() == null ? ScopeType.GLOBAL : ScopeType.WITH;
                break;
            }
            case WITH: {
                type = ScopeType.WITH;
                break;
            }
            default: {
                type = local ? ScopeType.LOCAL : ScopeType.CLOSURE;
            }
        }
        Bindings bindings = environment.bindings();
        if (bindings == null) {
            ObjectValue value = (ObjectValue)valueManager.createValue(environment.object(), null, null);
            CommandProcessorKt.getLOG().assertTrue(value != null);
            ObjectScope objectScope = new ObjectScope(type, value);
            if (objectScope == null) {
                FirefoxCallFrame.$$$reportNull$$$0(4);
            }
            return objectScope;
        }
        FirefoxDeclarativeScope firefoxDeclarativeScope = new FirefoxDeclarativeScope(type, environment, valueManager, useBindingsFromFrameData);
        if (firefoxDeclarativeScope == null) {
            FirefoxCallFrame.$$$reportNull$$$0(5);
        }
        return firefoxDeclarativeScope;
    }

    @Nullable
    static String getFunctionName(@Nullable Frame.Function function) {
        if (function == null) {
            return null;
        }
        if (StringUtil.isEmpty((String)function.userDisplayName())) {
            return StringUtil.isEmpty((String)function.displayName()) ? StringUtil.nullize((String)function.name()) : function.displayName();
        }
        return function.userDisplayName();
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        Promise promise = Promise.resolve((Object)this.thisObject);
        if (promise == null) {
            FirefoxCallFrame.$$$reportNull$$$0(6);
        }
        return promise;
    }

    public Object getEqualityObject() {
        return (String)ObjectUtils.chooseNotNull((Object)this.scriptId, (Object)this.scriptUrl) + "#" + this.getFunctionName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/firefox/FirefoxCallFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/firefox/FirefoxCallFrame";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverVariable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

