/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.firefoxConnector.configuration;

import com.intellij.CommonBundle;
import com.intellij.firefoxConnector.CannotInstallExtensionException;
import com.intellij.firefoxConnector.FirefoxConnectorBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.firefox.FirefoxSettings;
import com.intellij.ide.browsers.firefox.FirefoxSettingsConfigurable;
import com.intellij.ide.browsers.firefox.FirefoxUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.io.ZipUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public class FirefoxExtensionUtil {
    private static final String CURRENT_EXTENSION_VERSION = "0.6.2";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.firefoxConnector.configuration.FirefoxExtensionUtil");
    @NonNls
    private static final String EXTENSION_ID = "firefox-connector@jetbrains.com";
    @NonNls
    private static final String EXTENSION_FILE_NAME = "jb.xpi";
    @NonNls
    private static final String DESCRIPTION_ELEMENT = "Description";
    @NonNls
    private static final String EM_NAMESPACE = "http://www.mozilla.org/2004/em-rdf#";
    @NonNls
    private static final String RDF_NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    @NonNls
    private static final String MENU_FILE_PATH = "chrome/chromeFiles/content/browserOverlay.xul";
    @NonNls
    private static final String MAC_OS_DEFAULT_FIREFOX_EXECUTABLE_PATH = "/Applications/Firefox.app/Contents/MacOS/firefox-bin";

    private FirefoxExtensionUtil() {
    }

    @Nullable
    private static String getExtensionVersion(FirefoxSettings settings) {
        File extensionsDir = FirefoxUtil.getFirefoxExtensionsDir((FirefoxSettings)settings);
        if (extensionsDir == null || !extensionsDir.exists()) {
            return null;
        }
        File[] children = extensionsDir.listFiles();
        if (children != null) {
            for (File child : children) {
                String name = child.getName();
                if (name.equals(EXTENSION_ID)) {
                    if (child.isFile()) {
                        try {
                            child = new File(FileUtil.loadFile((File)child).trim());
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                            return null;
                        }
                    }
                    return FirefoxExtensionUtil.getExtensionVersion(new File(child, "install.rdf"));
                }
                if (!name.equals("firefox-connector@jetbrains.com.xpi")) continue;
                child.delete();
            }
        }
        return null;
    }

    @Nullable
    public static String getExtensionVersion(File child) {
        if (!child.isFile()) {
            return null;
        }
        try {
            Element descriptionElement = JDOMUtil.load((File)child).getChild(DESCRIPTION_ELEMENT, Namespace.getNamespace((String)RDF_NAMESPACE));
            if (descriptionElement != null) {
                return descriptionElement.getChildText("version", Namespace.getNamespace((String)EM_NAMESPACE));
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    public static void installExtension(FirefoxSettings settings) throws CannotInstallExtensionException {
        File extensionsBaseDir = FirefoxUtil.getFirefoxExtensionsDir((FirefoxSettings)settings);
        if (extensionsBaseDir == null) {
            throw new CannotInstallExtensionException(FirefoxConnectorBundle.message("error.message.cannot.install.extension.firefox.profiles.directory.not.found", new Object[0]));
        }
        File extensionFile = FirefoxExtensionUtil.getExtensionFile();
        if (!extensionFile.exists()) {
            throw new CannotInstallExtensionException(FirefoxConnectorBundle.message("error.message.extension.file.not.found.0", extensionFile.getAbsolutePath()));
        }
        try {
            LOG.debug("installing extension to " + extensionsBaseDir.getAbsolutePath());
            File extensionDir = new File(extensionsBaseDir, EXTENSION_ID);
            if (!extensionDir.exists() && !extensionDir.mkdirs()) {
                throw new CannotInstallExtensionException(FirefoxConnectorBundle.message("error.message.cannot.create.directory", extensionsBaseDir.getAbsolutePath()));
            }
            ZipUtil.extract((File)extensionFile, (File)extensionDir, null);
            FirefoxExtensionUtil.copyProductIcon(extensionDir);
            FirefoxExtensionUtil.substituteProductName(extensionDir);
            LOG.debug("extension installed");
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            throw new CannotInstallExtensionException(FirefoxConnectorBundle.message("error.message.cannot.install.extension", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyProductIcon(File extensionDir) throws IOException {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        String iconUrl = ApplicationInfoEx.getInstanceEx().getIconUrl();
        InputStream inputStream = FirefoxExtensionUtil.class.getResourceAsStream(iconUrl);
        if (inputStream != null) {
            File iconFile = new File(extensionDir, "skin" + File.separator + "icon.png");
            FileUtil.createParentDirs((File)iconFile);
            FileOutputStream output = new FileOutputStream(iconFile);
            try {
                StreamUtil.copyStreamContent((InputStream)inputStream, (OutputStream)output);
            }
            finally {
                output.close();
                inputStream.close();
            }
        } else {
            LOG.info("Application icon not found by path: " + iconUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void substituteProductName(File extensionDir) throws CannotInstallExtensionException, IOException {
        File menuFile = new File(extensionDir, FileUtil.toSystemDependentName((String)MENU_FILE_PATH));
        if (!menuFile.exists()) {
            throw new CannotInstallExtensionException("chrome/chromeFiles/content/browserOverlay.xul not found");
        }
        String text = FileUtil.loadFile((File)menuFile);
        String updatedText = StringUtil.replace((String)text, (String)"PRODUCT_NAME", (String)ApplicationNamesInfo.getInstance().getFullProductName());
        try (BufferedWriter fileWriter = new BufferedWriter(new FileWriter(menuFile));){
            fileWriter.write(updatedText);
        }
    }

    private static File getExtensionFile() {
        return new File(PathManager.getPreInstalledPluginsPath(), FileUtil.toSystemDependentName((String)"JavaScriptDebugger/extensions/jb.xpi"));
    }

    @NotNull
    public static Promise<Void> ensureFirefoxExtensionInstalled(final @Nullable Project project) {
        final WebBrowser browser = WebBrowserManager.getInstance().getFirstBrowser(BrowserFamily.FIREFOX);
        final FirefoxSettings firefoxSettings = (FirefoxSettings)browser.getSpecificSettings();
        assert (firefoxSettings != null);
        LOG.debug("Checking Firefox extension, profile = " + firefoxSettings.getProfile() + ", path = " + firefoxSettings.getProfilesIniPath());
        final AsyncPromise result = new AsyncPromise();
        if (FirefoxUtil.getFirefoxExtensionsDir((FirefoxSettings)firefoxSettings) == null) {
            FileChooserDescriptor descriptor = FirefoxSettingsConfigurable.createProfilesIniChooserDescriptor();
            descriptor.setTitle(FirefoxConnectorBundle.message("dialog.title.select.profiles.ini.file", new Object[0]));
            descriptor.setDescription(FirefoxConnectorBundle.message("chooser.description.profiles.ini.file.not.found.please.specify.path.to.it", ApplicationNamesInfo.getInstance().getFullProductName()));
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null, (Consumer)new FileChooser.FileChooserConsumer(){

                public void consume(List<VirtualFile> files) {
                    firefoxSettings.setProfilesIniPath(files.get(0).getPath());
                    if (FirefoxUtil.getFirefoxExtensionsDir((FirefoxSettings)firefoxSettings) == null) {
                        Messages.showErrorDialog((String)FirefoxConnectorBundle.message("error.message.cannot.find.firefox", new Object[0]), (String)CommonBundle.getErrorTitle());
                        result.setError("Cannot fin Firefox profiles directory");
                    } else {
                        WebBrowserManager.getInstance().setBrowserSpecificSettings(browser, (BrowserSpecificSettings)firefoxSettings);
                        FirefoxExtensionUtil.ensureExtensionInstalled(project, browser, firefoxSettings, (AsyncPromise<Void>)result);
                    }
                }

                public void cancelled() {
                    result.setError("Cancelled");
                }
            });
        } else {
            FirefoxExtensionUtil.ensureExtensionInstalled(project, browser, firefoxSettings, (AsyncPromise<Void>)result);
        }
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(0);
        }
        return asyncPromise;
    }

    private static void ensureExtensionInstalled(@Nullable Project project, final @NotNull WebBrowser browser, final @NotNull FirefoxSettings firefoxSettings, final @NotNull AsyncPromise<Void> callback) {
        if (browser == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(1);
        }
        if (firefoxSettings == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(3);
        }
        if (SystemInfo.isMac) {
            String path = browser.getPath();
            boolean canStartUsingOpenCommand = FirefoxExtensionUtil.canStartUsingOpenCommand((BrowserSpecificSettings)firefoxSettings);
            assert (path != null);
            if (!canStartUsingOpenCommand && !path.startsWith("/")) {
                File firefoxExecutable = new File(MAC_OS_DEFAULT_FIREFOX_EXECUTABLE_PATH);
                if (firefoxExecutable.exists()) {
                    FirefoxExtensionUtil.ensureExtensionInstalled(browser, firefoxSettings, FileUtil.toSystemIndependentName((String)firefoxExecutable.getAbsolutePath()), callback);
                    return;
                }
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                descriptor.setTitle(FirefoxConnectorBundle.message("dialog.title.select.firefox.executable", new Object[0]));
                descriptor.setDescription(FirefoxConnectorBundle.message("dialog.description.javascript.debugger.need.to.pass.parameters.to.firefox.so.it.requires.full.path.to.firefox.executable", new Object[0]));
                FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)project, null, (Consumer)new FileChooser.FileChooserConsumer(){

                    public void consume(List<VirtualFile> files) {
                        FirefoxExtensionUtil.ensureExtensionInstalled(browser, firefoxSettings, files.get(0).getPath(), (AsyncPromise<Void>)callback);
                    }

                    public void cancelled() {
                        callback.setError("Cancelled");
                    }
                });
            } else if (canStartUsingOpenCommand && path.equals(MAC_OS_DEFAULT_FIREFOX_EXECUTABLE_PATH)) {
                FirefoxExtensionUtil.ensureExtensionInstalled(browser, firefoxSettings, browser.getFamily().getExecutionPath(), callback);
                return;
            }
        }
        FirefoxExtensionUtil.ensureExtensionInstalled(browser, firefoxSettings, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureExtensionInstalled(@NotNull WebBrowser browser, @NotNull FirefoxSettings firefoxSettings, @Nullable String suggestedPath, @NotNull AsyncPromise<Void> callback) {
        if (browser == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(4);
        }
        if (firefoxSettings == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(6);
        }
        try {
            if (suggestedPath != null) {
                WebBrowserManager.getInstance().setBrowserPath(browser, suggestedPath, true);
            }
            if (FirefoxExtensionUtil.ensureExtensionInstalled(firefoxSettings)) {
                callback.setResult(null);
            }
        }
        finally {
            if (callback.getState() == Promise.State.PENDING) {
                callback.setError("");
            }
        }
    }

    private static boolean ensureExtensionInstalled(@NotNull FirefoxSettings firefoxSettings) {
        if (firefoxSettings == null) {
            FirefoxExtensionUtil.$$$reportNull$$$0(7);
        }
        try {
            String version = FirefoxExtensionUtil.getExtensionVersion(firefoxSettings);
            if (version == null) {
                LOG.debug("firefox extension not found for " + firefoxSettings.getProfile() + " profile");
                if (Messages.showOkCancelDialog((String)FirefoxConnectorBundle.message("message.info.install.extension", ApplicationNamesInfo.getInstance().getFullProductName()), (String)FirefoxConnectorBundle.message("dialog.title.install.extension", new Object[0]), (Icon)Messages.getInformationIcon()) != 0) {
                    return false;
                }
                FirefoxExtensionUtil.installExtension(firefoxSettings);
            } else if (!version.equals(CURRENT_EXTENSION_VERSION)) {
                LOG.debug("firefox extension installed for " + firefoxSettings.getProfile() + " profile has version " + version + ", but " + CURRENT_EXTENSION_VERSION + " expected");
                if (Messages.showOkCancelDialog((String)FirefoxConnectorBundle.message("message.info.update.extension", ApplicationNamesInfo.getInstance().getFullProductName()), (String)FirefoxConnectorBundle.message("dialog.title.install.extension", new Object[0]), (Icon)Messages.getInformationIcon()) != 0) {
                    return false;
                }
                FirefoxExtensionUtil.installExtension(firefoxSettings);
            } else {
                LOG.debug("Firefox extension of version " + version + " found");
            }
            return true;
        }
        catch (CannotInstallExtensionException e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)CommonBundle.getErrorTitle());
            return false;
        }
    }

    private static boolean canStartUsingOpenCommand(BrowserSpecificSettings firefoxSettings) {
        return firefoxSettings.getAdditionalParameters().isEmpty() || BrowserUtil.isOpenCommandSupportArgs();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/firefoxConnector/configuration/FirefoxExtensionUtil";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firefoxSettings";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFirefoxExtensionInstalled";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/firefoxConnector/configuration/FirefoxExtensionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "ensureExtensionInstalled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

