/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config;

import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.web.config.ServletFileSet;
import com.intellij.spring.web.config.SpringWebModelContributor;
import com.intellij.spring.web.config.anno.PsiBasedServlet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DispatcherServletAutoConfigurationWebModelContributor
extends SpringWebModelContributor {
    @NonNls
    private static final String DISPATCHER_SERVLET_NAME = "dispatcherServlet";

    public Pair<List<SpringFileSet>, Object[]> getFilesets(@NotNull SpringFacet springFacet, @NotNull WebFacet webFacet) {
        Module module;
        if (springFacet == null) {
            DispatcherServletAutoConfigurationWebModelContributor.$$$reportNull$$$0(0);
        }
        if (webFacet == null) {
            DispatcherServletAutoConfigurationWebModelContributor.$$$reportNull$$$0(1);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)(module = springFacet.getModule()))) {
            return NO_RESULT;
        }
        PsiClass springBootApplication = DispatcherServletAutoConfigurationWebModelContributor.findSingleSpringBootApplication(module);
        if (springBootApplication == null) {
            return NO_RESULT;
        }
        LocalAnnotationModel model = SpringManager.getInstance((Project)springBootApplication.getProject()).getLocalSpringModel(springBootApplication);
        if (model == null) {
            return NO_RESULT;
        }
        SpringBeanPointer dispatcherServletRegistrationConfiguration = SpringModelSearchers.findBean((CommonSpringModel)model, (String)DispatcherServletAutoConfigurationWebModelContributor.getDispatcherServletRegistrationConfigurationBeanName(module));
        if (dispatcherServletRegistrationConfiguration == null) {
            return NO_RESULT;
        }
        SpringBeanPointer dispatcherServlet = SpringModelSearchers.findBean((CommonSpringModel)model, (String)DISPATCHER_SERVLET_NAME);
        if (dispatcherServlet == null) {
            return NO_RESULT;
        }
        CommonSpringBean dispatcherServletBean = dispatcherServlet.getSpringBean();
        assert (dispatcherServletBean instanceof JamPsiMemberSpringBean);
        PsiMember dispatcherServletMethod = ((JamPsiMemberSpringBean)dispatcherServletBean).getPsiElement();
        PsiBasedServlet servlet = new PsiBasedServlet(DISPATCHER_SERVLET_NAME, dispatcherServlet.getBeanClass(), (PsiElement)dispatcherServletMethod, (PsiElement)dispatcherServletMethod, new String[]{"/"});
        ServletFileSet springBootMvcFileSet = new ServletFileSet("spring-boot-dispatcherServletAutoConfiguration-mvc", springBootApplication.getName() + " MVC", (CommonServlet)servlet, springFacet);
        DispatcherServletAutoConfigurationWebModelContributor.addInFileset((SpringFileSet)springBootMvcFileSet, (PsiFile)springBootApplication.getContainingFile());
        return Pair.create(Collections.singletonList(springBootMvcFileSet), (Object)ArrayUtil.EMPTY_OBJECT_ARRAY);
    }

    @Nullable
    private static PsiClass findSingleSpringBootApplication(Module module) {
        List results = SpringBootApplicationUtil.getSpringApplications((Module)module);
        return results.size() == 1 ? (PsiClass)ContainerUtil.getFirstItem((List)results) : null;
    }

    @NotNull
    private static String getDispatcherServletRegistrationConfigurationBeanName(Module module) {
        if (SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0)) {
            if ("dispatcherServletRegistrationConfiguration" == null) {
                DispatcherServletAutoConfigurationWebModelContributor.$$$reportNull$$$0(2);
            }
            return "dispatcherServletRegistrationConfiguration";
        }
        if ("dispatcherServletConfiguration" == null) {
            DispatcherServletAutoConfigurationWebModelContributor.$$$reportNull$$$0(3);
        }
        return "dispatcherServletConfiguration";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springFacet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webFacet";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/mvc/config/DispatcherServletAutoConfigurationWebModelContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/mvc/config/DispatcherServletAutoConfigurationWebModelContributor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatcherServletRegistrationConfigurationBeanName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesets";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

