/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class VMDebug {
    public static final int TRACE_COUNT_ALLOCS = 1;
    private static final int KIND_ALLOCATED_OBJECTS = 1;
    private static final int KIND_ALLOCATED_BYTES = 2;
    private static final int KIND_FREED_OBJECTS = 4;
    private static final int KIND_FREED_BYTES = 8;
    private static final int KIND_GC_INVOCATIONS = 16;
    private static final int KIND_CLASS_INIT_COUNT = 32;
    private static final int KIND_CLASS_INIT_TIME = 64;
    private static final int KIND_EXT_ALLOCATED_OBJECTS = 4096;
    private static final int KIND_EXT_ALLOCATED_BYTES = 8192;
    private static final int KIND_EXT_FREED_OBJECTS = 16384;
    private static final int KIND_EXT_FREED_BYTES = 32768;
    public static final int KIND_GLOBAL_ALLOCATED_OBJECTS = 1;
    public static final int KIND_GLOBAL_ALLOCATED_BYTES = 2;
    public static final int KIND_GLOBAL_FREED_OBJECTS = 4;
    public static final int KIND_GLOBAL_FREED_BYTES = 8;
    public static final int KIND_GLOBAL_GC_INVOCATIONS = 16;
    public static final int KIND_GLOBAL_CLASS_INIT_COUNT = 32;
    public static final int KIND_GLOBAL_CLASS_INIT_TIME = 64;
    public static final int KIND_GLOBAL_EXT_ALLOCATED_OBJECTS = 4096;
    public static final int KIND_GLOBAL_EXT_ALLOCATED_BYTES = 8192;
    public static final int KIND_GLOBAL_EXT_FREED_OBJECTS = 16384;
    public static final int KIND_GLOBAL_EXT_FREED_BYTES = 32768;
    public static final int KIND_THREAD_ALLOCATED_OBJECTS = 65536;
    public static final int KIND_THREAD_ALLOCATED_BYTES = 131072;
    public static final int KIND_THREAD_FREED_OBJECTS = 262144;
    public static final int KIND_THREAD_FREED_BYTES = 524288;
    public static final int KIND_THREAD_GC_INVOCATIONS = 0x100000;
    public static final int KIND_THREAD_CLASS_INIT_COUNT = 0x200000;
    public static final int KIND_THREAD_CLASS_INIT_TIME = 0x400000;
    public static final int KIND_THREAD_EXT_ALLOCATED_OBJECTS = 0x10000000;
    public static final int KIND_THREAD_EXT_ALLOCATED_BYTES = 0x20000000;
    public static final int KIND_THREAD_EXT_FREED_OBJECTS = 0x40000000;
    public static final int KIND_THREAD_EXT_FREED_BYTES = Integer.MIN_VALUE;
    public static final int KIND_ALL_COUNTS = -1;
    private static final HashMap<String, Integer> runtimeStatsMap = new HashMap();

    private VMDebug() {
    }

    public static long lastDebuggerActivity() {
        return OverrideMethod.invokeL("dalvik.system.VMDebug#lastDebuggerActivity()J", true, null);
    }

    public static boolean isDebuggingEnabled() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#isDebuggingEnabled()Z", true, null) != 0;
    }

    public static boolean isDebuggerConnected() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#isDebuggerConnected()Z", true, null) != 0;
    }

    public static String[] getVmFeatureList() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMDebug#getVmFeatureList()[Ljava/lang/String;", true, null);
    }

    @Deprecated
    public static void startMethodTracing() {
        throw new UnsupportedOperationException();
    }

    public static void startMethodTracing(String traceFileName, int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingFilename(traceFileName, VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    public static void startMethodTracing(String traceFileName, FileDescriptor fd, int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        if (fd == null) {
            throw new NullPointerException("fd == null");
        }
        VMDebug.startMethodTracingFd(traceFileName, fd, VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    public static void startMethodTracingDdms(int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingDdmsImpl(VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    private static int checkBufferSize(int bufferSize) {
        if (bufferSize == 0) {
            bufferSize = 0x800000;
        }
        if (bufferSize < 1024) {
            throw new IllegalArgumentException("buffer size < 1024: " + bufferSize);
        }
        return bufferSize;
    }

    private static void startMethodTracingDdmsImpl(int n, int n2, boolean bl, int n3) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startMethodTracingDdmsImpl(IIZI)V", true, null);
    }

    private static void startMethodTracingFd(String string2, FileDescriptor fileDescriptor, int n, int n2, boolean bl, int n3) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startMethodTracingFd(Ljava/lang/String;Ljava/io/FileDescriptor;IIZI)V", true, null);
    }

    private static void startMethodTracingFilename(String string2, int n, int n2, boolean bl, int n3) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startMethodTracingFilename(Ljava/lang/String;IIZI)V", true, null);
    }

    public static int getMethodTracingMode() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#getMethodTracingMode()I", true, null);
    }

    public static void stopMethodTracing() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#stopMethodTracing()V", true, null);
    }

    public static void startEmulatorTracing() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startEmulatorTracing()V", true, null);
    }

    public static void stopEmulatorTracing() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#stopEmulatorTracing()V", true, null);
    }

    public static long threadCpuTimeNanos() {
        return OverrideMethod.invokeL("dalvik.system.VMDebug#threadCpuTimeNanos()J", true, null);
    }

    public static void startAllocCounting() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startAllocCounting()V", true, null);
    }

    public static void stopAllocCounting() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#stopAllocCounting()V", true, null);
    }

    public static int getAllocCount(int n) {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#getAllocCount(I)I", true, null);
    }

    public static void resetAllocCount(int n) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#resetAllocCount(I)V", true, null);
    }

    @Deprecated
    public static int setAllocationLimit(int limit) {
        return -1;
    }

    @Deprecated
    public static int setGlobalAllocationLimit(int limit) {
        return -1;
    }

    public static void startInstructionCounting() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#startInstructionCounting()V", true, null);
    }

    public static void stopInstructionCounting() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#stopInstructionCounting()V", true, null);
    }

    public static void getInstructionCount(int[] nArray) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#getInstructionCount([I)V", true, null);
    }

    public static void resetInstructionCount() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#resetInstructionCount()V", true, null);
    }

    public static void printLoadedClasses(int n) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#printLoadedClasses(I)V", true, null);
    }

    public static int getLoadedClassCount() {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#getLoadedClassCount()I", true, null);
    }

    public static void dumpHprofData(String filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        VMDebug.dumpHprofData(filename, null);
    }

    public static void dumpHprofDataDdms() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#dumpHprofDataDdms()V", true, null);
    }

    public static void dumpHprofData(String string2, FileDescriptor fileDescriptor) throws IOException {
        OverrideMethod.invokeV("dalvik.system.VMDebug#dumpHprofData(Ljava/lang/String;Ljava/io/FileDescriptor;)V", true, null);
    }

    public static boolean cacheRegisterMap(String string2) {
        return OverrideMethod.invokeI("dalvik.system.VMDebug#cacheRegisterMap(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static void dumpReferenceTables() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#dumpReferenceTables()V", true, null);
    }

    public static void crash() {
        OverrideMethod.invokeV("dalvik.system.VMDebug#crash()V", true, null);
    }

    public static void infopoint(int n) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#infopoint(I)V", true, null);
    }

    private static void startGC() {
    }

    private static void startClassPrep() {
    }

    public static long countInstancesOfClass(Class clazz, boolean bl) {
        return OverrideMethod.invokeL("dalvik.system.VMDebug#countInstancesOfClass(Ljava/lang/Class;Z)J", true, null);
    }

    public static long[] countInstancesOfClasses(Class[] classArray, boolean bl) {
        return (long[])OverrideMethod.invokeA("dalvik.system.VMDebug#countInstancesOfClasses([Ljava/lang/Class;Z)[J", true, null);
    }

    public static void getHeapSpaceStats(long[] lArray) {
        OverrideMethod.invokeV("dalvik.system.VMDebug#getHeapSpaceStats([J)V", true, null);
    }

    public static String getRuntimeStat(String statName) {
        if (statName == null) {
            throw new NullPointerException("statName == null");
        }
        Integer statId = runtimeStatsMap.get(statName);
        if (statId != null) {
            return VMDebug.getRuntimeStatInternal(statId);
        }
        return null;
    }

    public static Map<String, String> getRuntimeStats() {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] values = VMDebug.getRuntimeStatsInternal();
        for (String name : runtimeStatsMap.keySet()) {
            int id2 = runtimeStatsMap.get(name);
            String value = values[id2];
            map.put(name, value);
        }
        return map;
    }

    private static String getRuntimeStatInternal(int n) {
        return (String)OverrideMethod.invokeA("dalvik.system.VMDebug#getRuntimeStatInternal(I)Ljava/lang/String;", true, null);
    }

    private static String[] getRuntimeStatsInternal() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMDebug#getRuntimeStatsInternal()[Ljava/lang/String;", true, null);
    }

    static {
        runtimeStatsMap.put("art.gc.gc-count", 0);
        runtimeStatsMap.put("art.gc.gc-time", 1);
        runtimeStatsMap.put("art.gc.bytes-allocated", 2);
        runtimeStatsMap.put("art.gc.bytes-freed", 3);
        runtimeStatsMap.put("art.gc.blocking-gc-count", 4);
        runtimeStatsMap.put("art.gc.blocking-gc-time", 5);
        runtimeStatsMap.put("art.gc.gc-count-rate-histogram", 6);
        runtimeStatsMap.put("art.gc.blocking-gc-count-rate-histogram", 7);
    }
}

