/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.ref.WeakReference;

public class SparseWeakArray<E> {
    private static final Object DELETED_REF = new Object();
    private static final WeakReference<?> DELETED = new WeakReference<Object>(DELETED_REF);
    private boolean mGarbage = false;
    private long[] mKeys;
    private WeakReference<?>[] mValues;
    private int mSize;

    public SparseWeakArray() {
        this(10);
    }

    public SparseWeakArray(int initialCapacity) {
        this.mKeys = ArrayUtils.newUnpaddedLongArray(initialCapacity);
        this.mValues = new WeakReference[this.mKeys.length];
        this.mSize = 0;
    }

    public E get(long key) {
        return this.get(key, null);
    }

    public E get(long key, E valueIfKeyNotFound) {
        int i = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED || this.mValues[i].get() == null) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i].get();
    }

    public void delete(long key) {
        int i = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(long key) {
        this.delete(key);
    }

    public void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    private void gc() {
        int n = this.mSize;
        int o = 0;
        long[] keys = this.mKeys;
        WeakReference<?>[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            WeakReference<?> val = values[i];
            if (val == DELETED || val.get() == null) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    public void put(long key, E value) {
        int i = SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = new WeakReference<E>(value);
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && (this.mValues[i] == DELETED || this.mValues[i].get() == null)) {
                this.mKeys[i] = key;
                this.mValues[i] = new WeakReference<E>(value);
                return;
            }
            if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
                this.gc();
                i = ~SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
            }
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i, key);
            this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, i, new WeakReference<E>(value));
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public long keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index].get();
    }

    public void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = new WeakReference<E>(value);
    }

    public int indexOfKey(long key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseWeakArray.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        int n = this.mSize;
        WeakReference<?>[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(long key, E value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mSize >= this.mKeys.length && (this.mGarbage || this.hasReclaimedRefs())) {
            this.gc();
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, new WeakReference<E>(value));
        ++this.mSize;
    }

    private boolean hasReclaimedRefs() {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i].get() != null) continue;
            return true;
        }
        return false;
    }

    private static int binarySearch(long[] a, int start, int len, long key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a[high] == key) {
            return high;
        }
        return ~high;
    }
}

