/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.android.internal.widget.ImageFloatingTextView;

@RemoteViews.RemoteView
public class MessagingLinearLayout
extends ViewGroup {
    private int mSpacing;
    private int mMaxHeight;
    private int mIndentLines;
    private int mContractedChildId;

    public MessagingLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MessagingLinearLayout, 0, 0);
        int N = a.getIndexCount();
        block4: for (int i = 0; i < N; ++i) {
            int attr2 = a.getIndex(i);
            switch (attr2) {
                case 1: {
                    this.mMaxHeight = a.getDimensionPixelSize(i, 0);
                    continue block4;
                }
                case 0: {
                    this.mSpacing = a.getDimensionPixelSize(i, 0);
                }
            }
        }
        if (this.mMaxHeight <= 0) {
            throw new IllegalStateException("MessagingLinearLayout: Must specify positive maxHeight");
        }
        a.recycle();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        switch (View.MeasureSpec.getMode(heightMeasureSpec)) {
            case -2147483648: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.min(this.mMaxHeight, View.MeasureSpec.getSize(heightMeasureSpec)), Integer.MIN_VALUE);
                break;
            }
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mMaxHeight, Integer.MIN_VALUE);
                break;
            }
        }
        int targetHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.hide = true;
        }
        int totalHeight = this.mPaddingTop + this.mPaddingBottom;
        boolean first = true;
        for (int i = count - 1; i >= 0 && totalHeight < targetHeight; --i) {
            if (this.getChildAt(i).getVisibility() == 8) continue;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            if (child instanceof ImageFloatingTextView) {
                ((ImageFloatingTextView)child).setNumIndentLines(this.mIndentLines);
            }
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            int childHeight = child.getMeasuredHeight();
            int newHeight = Math.max(totalHeight, totalHeight + childHeight + lp.topMargin + lp.bottomMargin + (first ? 0 : this.mSpacing));
            first = false;
            if (newHeight > targetHeight) break;
            totalHeight = newHeight;
            lp.hide = false;
        }
        int measuredWidth = this.mPaddingLeft + this.mPaddingRight;
        int imageLines = this.mIndentLines;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 || lp.hide) continue;
            if (child instanceof ImageFloatingTextView) {
                boolean changed;
                ImageFloatingTextView textChild = (ImageFloatingTextView)child;
                if (imageLines == 2 && textChild.getLineCount() > 2) {
                    imageLines = 3;
                }
                if (changed = textChild.setNumIndentLines(Math.max(0, imageLines))) {
                    this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
                }
                imageLines -= textChild.getLineCount();
            }
            measuredWidth = Math.max(measuredWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin + this.mPaddingLeft + this.mPaddingRight);
        }
        this.setMeasuredDimension(MessagingLinearLayout.resolveSize(Math.max(this.getSuggestedMinimumWidth(), measuredWidth), widthMeasureSpec), MessagingLinearLayout.resolveSize(Math.max(this.getSuggestedMinimumHeight(), totalHeight), heightMeasureSpec));
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int paddingLeft = this.mPaddingLeft;
        int width = right - left;
        int childRight = width - this.mPaddingRight;
        int layoutDirection = this.getLayoutDirection();
        int count = this.getChildCount();
        int childTop = this.mPaddingTop;
        boolean first = true;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (child.getVisibility() == 8 || lp.hide) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            int childLeft = layoutDirection == 1 ? childRight - childWidth - lp.rightMargin : paddingLeft + lp.leftMargin;
            if (!first) {
                childTop += this.mSpacing;
            }
            child.layout(childLeft, childTop += lp.topMargin, childLeft + childWidth, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
            first = false;
        }
    }

    @Override
    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.hide) {
            return true;
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.mContext, attrs);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        LayoutParams copy = new LayoutParams(lp.width, lp.height);
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            copy.copyMarginsFrom((ViewGroup.MarginLayoutParams)lp);
        }
        return copy;
    }

    @RemotableViewMethod
    public void setNumIndentLines(int numberLines) {
        this.mIndentLines = numberLines;
    }

    @RemotableViewMethod
    public void setContractedChildId(int contractedChildId) {
        this.mContractedChildId = contractedChildId;
    }

    public int getContractedChildId() {
        return this.mContractedChildId;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        boolean hide = false;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }
    }
}

